/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.gemini.engine.fs;

import java.util.BitSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.runtime.state.gemini.engine.fs.FileID;
import org.apache.flink.runtime.state.gemini.engine.fs.FileIDImpl;
import org.apache.flink.util.Preconditions;

public class FileIDGenerator {
    private final FileIdMode fileIdMode;
    private final int initValue;
    private final int subTaskIndex;
    private final int totalTaskNum;
    private final AtomicInteger uniqueId;
    private final FileIDRecorder fileIDRecorder;

    public FileIDGenerator(int subTaskIndex, int totalTaskNum) {
        this(subTaskIndex, totalTaskNum, 0);
    }

    @VisibleForTesting
    FileIDGenerator(int subTaskIndex, int totalTaskNum, int initUniqueIdValue) {
        Preconditions.checkArgument((subTaskIndex >= 0 ? 1 : 0) != 0, (Object)("Illegal sub task index: " + subTaskIndex));
        Preconditions.checkArgument((totalTaskNum > 0 ? 1 : 0) != 0, (Object)("Illegal total task num: " + totalTaskNum));
        Preconditions.checkArgument((subTaskIndex < totalTaskNum ? 1 : 0) != 0, (Object)("Illegal subTaskIndex v.s totalTaskNum: " + totalTaskNum + " v.s " + totalTaskNum));
        if (totalTaskNum <= FileIdMode.MODE1.getMaxAllowedTaskNum()) {
            this.fileIdMode = FileIdMode.MODE1;
        } else if (totalTaskNum <= FileIdMode.MODE2.getMaxAllowedTaskNum()) {
            this.fileIdMode = FileIdMode.MODE2;
        } else {
            throw new IllegalArgumentException("Unexpected total task number: " + totalTaskNum + ", cannot initialize any file id mode.");
        }
        this.totalTaskNum = totalTaskNum;
        this.subTaskIndex = subTaskIndex;
        this.initValue = this.fileIdMode.getInitValue() | this.subTaskIndex << this.fileIdMode.getSubtaskIndexOffset();
        this.uniqueId = new AtomicInteger(initUniqueIdValue);
        this.fileIDRecorder = new FileIDRecorder(this.fileIdMode.maxAllowedUniqueID);
    }

    public FileID generate() {
        if (this.fileIDRecorder.recordedFileIDNum() >= this.getMaxAllowedUniqueID()) {
            throw new IllegalStateException("Useful file unique ids have been consumed completely, not able to create new file writer.");
        }
        int currentUniqueId = this.uniqueId.get();
        while (this.fileIDRecorder.isIDRecorded(currentUniqueId)) {
            currentUniqueId = this.uniqueId.incrementAndGet();
            if (currentUniqueId <= this.fileIdMode.getMaxAllowedUniqueID()) continue;
            this.uniqueId.set(0);
            currentUniqueId = 0;
        }
        this.fileIDRecorder.recordUniqueID(currentUniqueId);
        return new FileIDImpl(this.initValue | currentUniqueId);
    }

    public void recycleFileID(FileID fileID) {
        this.recycleUniqueID(fileID.getUniqueID());
    }

    @VisibleForTesting
    void recycleUniqueID(int uniqueID) {
        this.fileIDRecorder.recycleFileID(uniqueID);
    }

    void restoreFileID(FileID fileID) {
        if (fileID.getMaxAllowedUniqueID() == this.getMaxAllowedUniqueID()) {
            this.fileIDRecorder.recordUniqueID(fileID.getUniqueID());
        }
    }

    void restoreFileIDs(Set<FileID> fileIDs) {
        if (!fileIDs.isEmpty()) {
            fileIDs.forEach(f -> {
                if (f.getMaxAllowedUniqueID() == this.getMaxAllowedUniqueID()) {
                    this.fileIDRecorder.recordUniqueID(f.getUniqueID());
                }
            });
        }
    }

    @VisibleForTesting
    FileID get() {
        return new FileIDImpl(this.initValue | this.uniqueId.get());
    }

    @VisibleForTesting
    int getUniqueID() {
        return this.uniqueId.get();
    }

    @VisibleForTesting
    FileIDRecorder getFileIDRecorder() {
        return this.fileIDRecorder;
    }

    @VisibleForTesting
    void setUniqueID(int uniqueID) {
        Preconditions.checkArgument((uniqueID <= this.fileIdMode.getMaxAllowedUniqueID() ? 1 : 0) != 0, (Object)("UniqueID to set: " + uniqueID + " is larger than max allowed uniqueID."));
        this.uniqueId.set(uniqueID);
    }

    public int getMaxAllowedUniqueID() {
        return this.fileIdMode.getMaxAllowedUniqueID();
    }

    @VisibleForTesting
    FileIdMode getFileIdMode() {
        return this.fileIdMode;
    }

    int recordedFileIDNum() {
        return this.fileIDRecorder.recordedFileIDNum();
    }

    boolean isFileIDRecorded(FileID fileID) {
        return this.fileIDRecorder.isFileIDRecorded(fileID);
    }

    public int getUniqueId() {
        return this.uniqueId.get();
    }

    public int getSubTaskIndex() {
        return this.subTaskIndex;
    }

    public int getTotalTaskNum() {
        return this.totalTaskNum;
    }

    public static FileIDGenerator fromFileID(FileIDImpl fileID) {
        return new FileIDGenerator(fileID.getSubTaskIndex(), fileID.getFileIdMode().getMaxAllowedTaskNum(), fileID.getUniqueID());
    }

    public String toString() {
        return "FileIDGenerator{fileIdMode=" + (Object)((Object)this.fileIdMode) + ", subTaskIndex=" + this.subTaskIndex + ", totalTaskNum=" + this.totalTaskNum + ", uniqueId=" + this.uniqueId + '}';
    }

    public class FileIDRecorder {
        private final BitSet usedFileUniqueIDs;
        private final int maxAllowedUniqueID;

        public FileIDRecorder(int maxAllowedUniqueID) {
            this.maxAllowedUniqueID = maxAllowedUniqueID;
            this.usedFileUniqueIDs = new BitSet(maxAllowedUniqueID);
        }

        public int recordedFileIDNum() {
            return this.usedFileUniqueIDs.cardinality();
        }

        public boolean isFileIDRecorded(FileID fileID) {
            return this.usedFileUniqueIDs.get(fileID.getUniqueID());
        }

        boolean isIDRecorded(int uniqueID) {
            return this.usedFileUniqueIDs.get(uniqueID);
        }

        void recordFileID(FileID fileID) {
            if (fileID.getMaxAllowedUniqueID() == this.maxAllowedUniqueID) {
                this.usedFileUniqueIDs.set(fileID.getUniqueID());
            }
        }

        void recordUniqueID(int uniqueID) {
            this.usedFileUniqueIDs.set(uniqueID);
        }

        void recycleFileID(int uniqueID) {
            this.usedFileUniqueIDs.clear(uniqueID);
        }

        public void recordFileIDs(Set<FileID> fileIDs) {
            if (!fileIDs.isEmpty() & fileIDs.iterator().next().getMaxAllowedUniqueID() == this.maxAllowedUniqueID) {
                fileIDs.forEach(f -> this.usedFileUniqueIDs.set(f.getUniqueID()));
            }
        }

        @VisibleForTesting
        BitSet getUsedFileUniqueIDs() {
            return BitSet.valueOf(this.usedFileUniqueIDs.toLongArray());
        }
    }

    public static enum FileIdMode {
        MODE1(0, Integer.MIN_VALUE, 31, 2145386496, 21, 131071),
        MODE2(2, -1073741824, 30, 1073709056, 15, Short.MAX_VALUE);

        private final int flagValue;
        private final int maxAllowedTaskNum;
        private final int maxAllowedUniqueID;
        private final int flagMask;
        private final int flagOffset;
        private final int subtaskIndexMask;
        private final int subtaskIndexOffset;
        private final int uniqueIDMask;
        private final int initValue;
        private static final int TOTAL_LENGTH = 32;

        private FileIdMode(int flagValue, int flagMask, int flagOffset, int subTaskMask, int subTaskIndexOffset, int uniqueIDMask) {
            this.flagValue = flagValue;
            this.flagMask = flagMask;
            this.flagOffset = flagOffset;
            this.initValue = flagValue << flagOffset;
            this.subtaskIndexMask = subTaskMask;
            this.subtaskIndexOffset = subTaskIndexOffset;
            this.maxAllowedTaskNum = (subTaskMask >> subTaskIndexOffset) + 1;
            this.uniqueIDMask = uniqueIDMask;
            this.maxAllowedUniqueID = uniqueIDMask;
        }

        public int getFlagValue() {
            return this.flagValue;
        }

        public int getFlagOffset() {
            return this.flagOffset;
        }

        public int getMaxAllowedTaskNum() {
            return this.maxAllowedTaskNum;
        }

        public int getFlagMask() {
            return this.flagMask;
        }

        public int getSubtaskIndexOffset() {
            return this.subtaskIndexOffset;
        }

        public int getSubtaskIndexMask() {
            return this.subtaskIndexMask;
        }

        public int getUniqueIDMask() {
            return this.uniqueIDMask;
        }

        public int getMaxAllowedUniqueID() {
            return this.maxAllowedUniqueID;
        }

        public int getInitValue() {
            return this.initValue;
        }

        public int getTotalLength() {
            return 32;
        }
    }
}

