/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.gemini.engine.fs;

import java.util.Objects;
import org.apache.flink.runtime.state.gemini.engine.fs.FileID;
import org.apache.flink.runtime.state.gemini.engine.fs.FileIDGenerator;
import org.apache.flink.util.Preconditions;

public class FileIDImpl
implements FileID {
    private final FileIDGenerator.FileIdMode fileIdMode;
    private final int subTaskIndex;
    private final int uniqueId;
    private final int value;

    public FileIDImpl(int fileIDValue) {
        FileIDGenerator.FileIdMode fileIdMode = null;
        for (FileIDGenerator.FileIdMode idMode : FileIDGenerator.FileIdMode.values()) {
            if (fileIDValue >>> idMode.getFlagOffset() != idMode.getFlagValue()) continue;
            fileIdMode = idMode;
            break;
        }
        if (fileIdMode == null) {
            throw new IllegalArgumentException("Fail to parse given fileIDValue " + fileIDValue + " (binaryString: " + Integer.toBinaryString(fileIDValue) + ") to expected file modes.");
        }
        this.fileIdMode = fileIdMode;
        this.subTaskIndex = (fileIDValue & fileIdMode.getSubtaskIndexMask()) >>> fileIdMode.getSubtaskIndexOffset();
        this.uniqueId = fileIDValue & fileIdMode.getUniqueIDMask();
        this.value = fileIDValue;
    }

    public FileIDImpl(FileIDGenerator.FileIdMode fileIdMode, int subTaskIndex, int uniqueId) {
        Preconditions.checkArgument((subTaskIndex < fileIdMode.getMaxAllowedTaskNum() && subTaskIndex >= 0 ? 1 : 0) != 0, (Object)("Illegal of sub task index: " + subTaskIndex + "\uff0cless than zero or larger than the max allowed total task num " + fileIdMode.getMaxAllowedTaskNum() + " of fileID mode: " + (Object)((Object)fileIdMode)));
        Preconditions.checkArgument((uniqueId <= fileIdMode.getMaxAllowedUniqueID() ? 1 : 0) != 0, (Object)("Illegal of uniqueId: " + uniqueId + ", larger than the max allowed uniqueId " + fileIdMode.getMaxAllowedUniqueID() + "  of fileId mode: " + (Object)((Object)fileIdMode)));
        this.fileIdMode = fileIdMode;
        this.subTaskIndex = subTaskIndex;
        this.uniqueId = uniqueId;
        this.value = fileIdMode.getInitValue() | subTaskIndex << fileIdMode.getSubtaskIndexOffset() | uniqueId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FileIDImpl fileID = (FileIDImpl)o;
        return this.value == fileID.value;
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    @Override
    public int get() {
        return this.value;
    }

    @Override
    public int getUniqueID() {
        return this.uniqueId;
    }

    @Override
    public int getMaxAllowedUniqueID() {
        return this.fileIdMode.getMaxAllowedUniqueID();
    }

    public int getSubTaskIndex() {
        return this.subTaskIndex;
    }

    public FileIDGenerator.FileIdMode getFileIdMode() {
        return this.fileIdMode;
    }

    public String toString() {
        return "FileID{fileIdMode=" + (Object)((Object)this.fileIdMode) + ", subTaskIndex=" + this.subTaskIndex + ", uniqueId=" + this.uniqueId + '}';
    }
}

