/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.gemini.engine.fs;

import java.io.Closeable;
import java.util.Map;
import java.util.Set;
import org.apache.flink.core.fs.Path;
import org.apache.flink.runtime.state.gemini.engine.fs.FileID;
import org.apache.flink.runtime.state.gemini.engine.fs.FileMeta;
import org.apache.flink.runtime.state.gemini.engine.fs.FileReader;
import org.apache.flink.runtime.state.gemini.engine.fs.FileWriter;
import org.apache.flink.runtime.state.gemini.engine.page.DataPageUtil;

public interface FileManager
extends Closeable {
    public void start();

    public String getFileManagerIdentifier();

    public Path getBasePath();

    public String getFilePath(FileID var1);

    public String getFilePath(int var1);

    public FileMeta getFileMeta(int var1);

    public FileID getFileID(long var1);

    public int getSimpleFileID(long var1);

    public long getAddress(FileID var1, long var2);

    public long getFileOffset(long var1);

    public FileReader getFileReader(long var1);

    public FileWriter createNewFileWriter();

    public void closeFileWriter(FileWriter var1);

    public void incDBReference(long var1, long var3);

    public void decDBReference(long var1, long var3, long var5, long var7);

    public void incSnapshotReference(FileID var1);

    public void decSnapshotReference(FileID var1);

    public Set<String> getMarkedDeletionFiles();

    public void restore(Map<Integer, FileMeta.RestoredFileMeta> var1);

    public Map<Integer, FileMeta> getFileMapping();

    public Map<FileID, String> getFileMapping(Set<FileID> var1);

    public void increaseFileWriterErrorCount();

    public void resetFileWriterErrorCount();

    public boolean isValid();

    public DataPageUtil getDataPageUtil();
}

