/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.gemini.engine.fs;

import java.net.URI;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.core.fs.FileSystem;
import org.apache.flink.core.fs.Path;
import org.apache.flink.metrics.Gauge;
import org.apache.flink.metrics.MetricGroup;
import org.apache.flink.runtime.state.gemini.engine.ExceptionStat;
import org.apache.flink.runtime.state.gemini.engine.dbms.GContext;
import org.apache.flink.runtime.state.gemini.engine.exceptions.GeminiRuntimeException;
import org.apache.flink.runtime.state.gemini.engine.fs.FTFileWriter;
import org.apache.flink.runtime.state.gemini.engine.fs.FileID;
import org.apache.flink.runtime.state.gemini.engine.fs.FileIDGenerator;
import org.apache.flink.runtime.state.gemini.engine.fs.FileIDImpl;
import org.apache.flink.runtime.state.gemini.engine.fs.FileManager;
import org.apache.flink.runtime.state.gemini.engine.fs.FileManagerStat;
import org.apache.flink.runtime.state.gemini.engine.fs.FileMeta;
import org.apache.flink.runtime.state.gemini.engine.fs.FileReader;
import org.apache.flink.runtime.state.gemini.engine.fs.FileReaderImpl;
import org.apache.flink.runtime.state.gemini.engine.fs.FileWriter;
import org.apache.flink.runtime.state.gemini.engine.fs.GeminiDataOutputStream;
import org.apache.flink.runtime.state.gemini.engine.fs.GeminiInputStream;
import org.apache.flink.runtime.state.gemini.engine.fs.GeminiOutputStream;
import org.apache.flink.runtime.state.gemini.engine.metrics.FileManagerMetrics;
import org.apache.flink.runtime.state.gemini.engine.page.DataPageUtil;
import org.apache.flink.runtime.state.gemini.engine.page.DfsDataPageUtil;
import org.apache.flink.runtime.state.gemini.engine.page.LocalDataPageUtil;
import org.apache.flink.shaded.guava18.com.google.common.util.concurrent.ThreadFactoryBuilder;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileManagerImpl
implements FileManager {
    private static final Logger LOG = LoggerFactory.getLogger(FileManagerImpl.class);
    private final GContext gContext;
    private final String fileManagerIdentifier;
    private final Path workingBasePath;
    private final Integer writerFailCountThreshold;
    private final Integer fileManagerFailCountThreshold;
    private final long retryCreateFileWriterInterval;
    private Tuple2<Long, Integer> fileWriterErrorStatus = new Tuple2();
    private ExceptionStat exceptionStat;
    private final String invalidMessage;
    private final Map<Integer, FileMeta> fileMapping;
    private final FileIDGenerator fileIDGenerator;
    private final String backendUID;
    private final AtomicLong fileSuffix;
    private final boolean snapshotStorage;
    private final long fileAliveTimeAfterNoDBReference;
    private final SortedSet<FileMeta> waitingDBDeletionFiles;
    private final Set<FileMeta> waitingSnapshotDeletionFiles;
    private final Set<String> markedDeletionFiles;
    private final ScheduledThreadPoolExecutor fileDeletionCheckExecutor;
    private final FileManagerStat fileManagerStat;
    private long lastPrintStatTime;
    private volatile boolean closed;
    private final DataPageUtil dataPageUtil;
    @Nullable
    private FileManagerMetrics fileManagerMetrics;

    @VisibleForTesting
    public FileManagerImpl(GContext gContext, String fileManagerIdentifier, Path workingBasePath) {
        this(gContext, fileManagerIdentifier, workingBasePath, false);
    }

    @VisibleForTesting
    public FileManagerImpl(GContext gContext, String fileManagerIdentifier, Path workingBasePath, boolean snapshotStorage) {
        this(gContext, fileManagerIdentifier, workingBasePath, snapshotStorage, snapshotStorage ? new DfsDataPageUtil(gContext.getGConfiguration().isChecksumEnable()) : new LocalDataPageUtil(gContext.getSupervisor().getForReadAllocator(), gContext.getGConfiguration().isChecksumEnable()));
    }

    public FileManagerImpl(GContext gContext, String fileManagerIdentifier, Path workingBasePath, boolean snapshotStorage, DataPageUtil dataPageUtil) {
        this.gContext = (GContext)Preconditions.checkNotNull((Object)gContext);
        this.fileManagerIdentifier = fileManagerIdentifier;
        this.workingBasePath = workingBasePath;
        this.fileMapping = new ConcurrentHashMap<Integer, FileMeta>();
        this.fileIDGenerator = new FileIDGenerator(gContext.getGConfiguration().getSubTaskIndex(), gContext.getGConfiguration().getNumParallelSubtasks());
        this.backendUID = gContext.getGConfiguration().getBackendUID();
        this.fileSuffix = new AtomicLong(0L);
        this.snapshotStorage = snapshotStorage;
        this.fileAliveTimeAfterNoDBReference = gContext.getGConfiguration().getFileAliveTimeAfterNoDataReference();
        this.waitingDBDeletionFiles = new ConcurrentSkipListSet<FileMeta>(new Comparator<FileMeta>(){

            @Override
            public int compare(FileMeta o1, FileMeta o2) {
                long diffAccessNumber = o1.getDiscardAccessNumber() - o2.getDiscardAccessNumber();
                if (diffAccessNumber != 0L) {
                    return diffAccessNumber < 0L ? -1 : 1;
                }
                long diffTimestamp = o1.getDiscardAccessNumber() - o2.getDiscardAccessNumber();
                if (diffTimestamp != 0L) {
                    return diffTimestamp < 0L ? -1 : 1;
                }
                return Integer.compare(o1.getFileId().get(), o2.getFileId().get());
            }
        });
        this.waitingSnapshotDeletionFiles = ConcurrentHashMap.newKeySet();
        this.markedDeletionFiles = ConcurrentHashMap.newKeySet();
        this.lastPrintStatTime = 0L;
        this.fileManagerStat = new FileManagerStat();
        MetricGroup fileManagerMetricGroup = gContext.getFileManagerMetricGroup();
        if (fileManagerMetricGroup != null) {
            MetricGroup metricGroup = fileManagerMetricGroup.addGroup(fileManagerIdentifier);
            this.fileManagerMetrics = new FileManagerMetrics(metricGroup, gContext.getGConfiguration().getMetricSampleCount());
            this.fileManagerMetrics.register(this.fileManagerStat);
            this.fileManagerMetrics.registerUsedFile((Gauge<Integer>)((Gauge)this.fileMapping::size));
            this.fileManagerMetrics.registerWaitingDbDeletion((Gauge<Integer>)((Gauge)this.waitingDBDeletionFiles::size));
            this.fileManagerMetrics.registerWaitingSnapshotDeletion((Gauge<Integer>)((Gauge)this.waitingSnapshotDeletionFiles::size));
            this.fileManagerMetrics.registerMarkDeletionFile((Gauge<Integer>)((Gauge)this.markedDeletionFiles::size));
        }
        this.fileDeletionCheckExecutor = new ScheduledThreadPoolExecutor(1, new ThreadFactoryBuilder().setNameFormat(gContext.getGConfiguration().getExecutorPrefixName() + "FileManager-" + fileManagerIdentifier + "-%d").build());
        this.fileDeletionCheckExecutor.setRemoveOnCancelPolicy(true);
        this.fileDeletionCheckExecutor.setContinueExistingPeriodicTasksAfterShutdownPolicy(false);
        this.fileDeletionCheckExecutor.setExecuteExistingDelayedTasksAfterShutdownPolicy(false);
        this.closed = false;
        this.writerFailCountThreshold = gContext.getGConfiguration().getWriterFailCountThreshold();
        this.fileManagerFailCountThreshold = gContext.getGConfiguration().getFileManagerFailCountThreshold();
        this.retryCreateFileWriterInterval = gContext.getGConfiguration().getFileManagerCreateFileWriterRetryInterval() * 1000;
        this.fileWriterErrorStatus.f0 = -1L;
        this.fileWriterErrorStatus.f1 = 0;
        this.exceptionStat = new ExceptionStat();
        if (gContext.getExceptionMetrics() != null) {
            gContext.getExceptionMetrics().register(this.exceptionStat);
        }
        this.invalidMessage = "Can't create file writer anymore, because of exceed the threshold(" + this.fileManagerFailCountThreshold + ") of continues filewriter error";
        this.dataPageUtil = dataPageUtil;
        LOG.info("FileManager is created for {}", (Object)workingBasePath);
    }

    @Override
    public void start() {
        this.fileDeletionCheckExecutor.scheduleWithFixedDelay(new DBDeletionCheckRunner(), 1500L, this.gContext.getGConfiguration().getFileDeletionCheckInterval(), TimeUnit.MILLISECONDS);
        LOG.info("FileManager is started for {}", (Object)this.workingBasePath);
    }

    @Override
    public String getFileManagerIdentifier() {
        return this.fileManagerIdentifier;
    }

    @Override
    public Path getBasePath() {
        return this.workingBasePath;
    }

    @Override
    public String getFilePath(FileID fileID) {
        return this.getFilePath(fileID.get());
    }

    @Override
    public String getFilePath(int fileId) {
        FileMeta fileMeta = this.fileMapping.get(fileId);
        Preconditions.checkNotNull((Object)fileMeta, (String)("file not in file mapping for " + fileId));
        return fileMeta.getFilePath();
    }

    @Override
    public FileMeta getFileMeta(int fileId) {
        return this.fileMapping.get(fileId);
    }

    @Override
    public FileID getFileID(long address) {
        return new FileIDImpl(this.getIDFromAddress(address));
    }

    @Override
    public int getSimpleFileID(long address) {
        return this.getIDFromAddress(address);
    }

    @Override
    public long getAddress(FileID fileID, long offset) {
        return (long)fileID.get() << 32 | offset;
    }

    @Override
    public long getFileOffset(long address) {
        return address & 0xFFFFFFFFL;
    }

    @VisibleForTesting
    FileID getCurrentFileID() {
        return this.fileIDGenerator.get();
    }

    private int getIDFromAddress(long address) {
        return (int)(address >>> 32);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FileReader getFileReader(long address) {
        this.checkDBStatus();
        int id = this.getIDFromAddress(address);
        FileMeta fileMeta = this.fileMapping.get(id);
        Preconditions.checkNotNull((Object)fileMeta, (String)("file not in file mapping for file id " + id));
        FileReader fileReader = fileMeta.getFileReader();
        if (fileReader == null) {
            FileMeta fileMeta2 = fileMeta;
            synchronized (fileMeta2) {
                fileReader = fileMeta.getFileReader();
                if (fileReader == null) {
                    GeminiInputStream inputStream = null;
                    try {
                        inputStream = new GeminiInputStream(new Path(fileMeta.getFilePath()));
                        fileReader = new FileReaderImpl(inputStream, fileMeta);
                        fileMeta.setFileReader(fileReader);
                        if (this.closed) {
                            fileMeta.setFileReader(null);
                            LOG.warn("File manager has been closed, and close file reader for file {}", (Object)fileMeta);
                            throw new GeminiRuntimeException("File manager has been closed");
                        }
                    }
                    catch (Exception e) {
                        try {
                            if (fileReader != null) {
                                fileReader.close();
                            } else if (inputStream != null) {
                                inputStream.close();
                            }
                        }
                        catch (Exception innerException) {
                            LOG.error("failed to close input stream {}", (Object)inputStream, (Object)innerException);
                        }
                        throw new GeminiRuntimeException("failed to create file reader for " + fileMeta, e);
                    }
                }
            }
        }
        return fileReader;
    }

    @Override
    public FileWriter createNewFileWriter() {
        this.checkDBStatus();
        Tuple2<FileID, String> tuple = this.getNewFilePath();
        FileID fileID = (FileID)tuple.f0;
        String filePath = (String)tuple.f1;
        FileMeta fileMeta = new FileMeta(filePath, fileID);
        GeminiDataOutputStream fileWriter = null;
        GeminiOutputStream outputStream = null;
        try {
            if (!this.isValid()) {
                throw new IllegalStateException(this.invalidMessage);
            }
            outputStream = new GeminiOutputStream(new Path(filePath));
            fileWriter = new FTFileWriter(outputStream, this, fileID, filePath, this.writerFailCountThreshold, this.exceptionStat);
            fileMeta.setFileWriter((FileWriter)fileWriter);
            fileMeta.addAndGetDBReference(1);
            FileMeta oldFileMeta = this.fileMapping.putIfAbsent(fileID.get(), fileMeta);
            LOG.info("{} file manager put fileID {} with meta {}.", new Object[]{this.getFileManagerIdentifier(), fileID, fileMeta});
            Preconditions.checkState((oldFileMeta == null ? 1 : 0) != 0, (String)"{} has existed", (Object[])new Object[]{fileMeta});
            if (this.closed && this.fileMapping.remove(fileID.get()) != null) {
                LOG.warn("File manager has been closed, and close file writer for file {}", (Object)fileMeta);
                throw new GeminiRuntimeException("File manager has been closed.");
            }
        }
        catch (Exception e) {
            try {
                if (fileWriter != null) {
                    fileWriter.close();
                } else if (outputStream != null) {
                    outputStream.close();
                }
            }
            catch (Exception innerException) {
                LOG.error("failed to close output stream, {}, {}", (Object)outputStream, (Object)innerException);
            }
            this.recycleFileID(fileID);
            this.deleteFile(filePath, false);
            this.fileManagerStat.addTotalFailCreateFile(1);
            LOG.error("Failed to create new file writer for {}", (Object)fileID, (Object)e);
            throw new GeminiRuntimeException("Failed to create new file writer for " + fileID + ", exception " + e, e);
        }
        this.fileManagerStat.addTotalCreatedFile(1);
        this.fileManagerStat.setMaxUsedFile(this.fileMapping.size());
        LOG.debug("Create new file {}.", (Object)fileMeta);
        return fileWriter;
    }

    @Override
    public void closeFileWriter(FileWriter fileWriter) {
        this.checkDBStatus();
        Preconditions.checkNotNull((Object)fileWriter);
        FileID fileID = fileWriter.getFileID();
        FileMeta fileMeta = this.fileMapping.get(fileID.get());
        Preconditions.checkNotNull((Object)fileMeta, (String)"file not in file mapping for {}", (Object[])new Object[]{fileID});
        if (fileWriter.isValid()) {
            this.resetFileWriterErrorCount();
        } else {
            this.increaseFileWriterErrorCount();
        }
        try {
            fileWriter.close();
            LOG.debug("close file writer successfully: {}", (Object)fileMeta);
        }
        catch (Exception e) {
            LOG.error("failed to close file writer: file id {}", (Object)fileMeta, (Object)e);
        }
        fileMeta.setFileWriter(null);
        this.internalDecDBReference(fileMeta, this.gContext.getAccessNumber(), System.currentTimeMillis(), 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    Tuple2<FileID, String> getNewFilePath() {
        FileID fileID;
        FileIDGenerator fileIDGenerator = this.fileIDGenerator;
        synchronized (fileIDGenerator) {
            fileID = this.fileIDGenerator.generate();
        }
        String filePath = new Path(this.workingBasePath, this.backendUID + "-" + this.fileSuffix.getAndIncrement()).toUri().toString();
        if (LOG.isDebugEnabled()) {
            LOG.debug("FileID {} with new path {} is ready to create.", (Object)fileID, (Object)filePath);
        }
        return Tuple2.of((Object)fileID, (Object)filePath);
    }

    @Override
    public void incDBReference(long address, long dataSize) {
        this.checkDBStatus();
        FileMeta fileMeta = this.fileMapping.get(this.getIDFromAddress(address));
        Preconditions.checkNotNull((Object)fileMeta);
        this.internalIncDBReference(fileMeta, dataSize);
    }

    private void internalIncDBReference(FileMeta fileMeta, long dataSize) {
        long ref = fileMeta.addAndGetDBReference(1);
        Preconditions.checkState((ref > 0L ? 1 : 0) != 0, (Object)"snapshot reference should be positive");
        fileMeta.addAndGetDataSize(dataSize);
        this.fileManagerStat.addTotalDataSize(dataSize);
    }

    @Override
    public void decDBReference(long address, long accessNumber, long ts, long dataSize) {
        this.checkDBStatus();
        FileMeta fileMeta = this.fileMapping.get(this.getIDFromAddress(address));
        Preconditions.checkNotNull((Object)fileMeta);
        this.internalDecDBReference(fileMeta, accessNumber, ts, dataSize);
    }

    private void internalDecDBReference(FileMeta fileMeta, long accessNumber, long ts, long dataSize) {
        fileMeta.updateDiscardAccessNumberAndTimestamp(accessNumber, ts);
        fileMeta.addAndGetDataSize(-dataSize);
        long ref = fileMeta.addAndGetDBReference(-1);
        Preconditions.checkState((ref >= 0L ? 1 : 0) != 0, (Object)"data reference should not be negative");
        if (ref == 0L) {
            boolean success = this.waitingDBDeletionFiles.add(fileMeta);
            Preconditions.checkState((boolean)success, (Object)("failed to add file to waitingDBDeletionFiles " + fileMeta));
            LOG.debug("add file to waitingDBDeletionFiles {}", (Object)fileMeta);
        }
        this.fileManagerStat.addTotalDataSize(-dataSize);
    }

    @Override
    public void incSnapshotReference(FileID fileID) {
        this.checkDBStatus();
        if (this.snapshotStorage) {
            FileMeta fileMeta = this.fileMapping.get(fileID.get());
            Preconditions.checkNotNull((Object)fileMeta);
            long ref = fileMeta.addAndGetSnapshotReference(1);
            Preconditions.checkState((ref > 0L ? 1 : 0) != 0, (Object)"snapshot reference should be positive");
        }
    }

    @Override
    public void decSnapshotReference(FileID fileID) {
        this.checkDBStatus();
        if (this.snapshotStorage) {
            FileMeta fileMeta = this.fileMapping.get(fileID.get());
            Preconditions.checkNotNull((Object)fileMeta);
            long ref = fileMeta.addAndGetSnapshotReference(-1);
            Preconditions.checkState((ref >= 0L ? 1 : 0) != 0, (Object)"snapshot reference should not be negative");
            if (ref == 0L && this.waitingSnapshotDeletionFiles.remove(fileMeta)) {
                this.markFileDeletion(fileMeta);
                LOG.debug("Mark file deletion by snapshot {}", (Object)fileMeta);
            }
        }
    }

    @Override
    public Set<String> getMarkedDeletionFiles() {
        HashSet<String> deletedFilePath = new HashSet<String>();
        Iterator<String> iterator = this.markedDeletionFiles.iterator();
        while (iterator.hasNext()) {
            deletedFilePath.add(iterator.next());
            iterator.remove();
        }
        return deletedFilePath;
    }

    @Override
    public void restore(Map<Integer, FileMeta.RestoredFileMeta> restoredFileMapping) {
        HashSet<FileID> fileIDS = new HashSet<FileID>();
        long totalDataSize = 0L;
        for (Map.Entry<Integer, FileMeta.RestoredFileMeta> entry : restoredFileMapping.entrySet()) {
            int id = entry.getKey();
            FileMeta.RestoredFileMeta restoredFileMeta = entry.getValue();
            FileMeta fileMeta = this.fileMapping.get(id);
            if (fileMeta != null) {
                LOG.error("file mapping should not have contained file id {}, old path: {}, new path: {}", new Object[]{id, fileMeta.getFilePath(), restoredFileMeta.filePath});
                throw new GeminiRuntimeException("file mapping should not have contained file id " + id);
            }
            Preconditions.checkState((restoredFileMeta.dbReference != 0 || restoredFileMeta.snapshotReference != 0 ? 1 : 0) != 0, (Object)("db reference and snapshot reference can not be both 0: " + restoredFileMeta.id + ", " + restoredFileMeta.filePath));
            FileIDImpl fileID = new FileIDImpl(restoredFileMeta.id);
            fileMeta = new FileMeta(restoredFileMeta.filePath, fileID, restoredFileMeta.fileSize, restoredFileMeta.dataSize, restoredFileMeta.dbReference, restoredFileMeta.snapshotReference, restoredFileMeta.canDeleted);
            this.fileMapping.put(id, fileMeta);
            fileIDS.add(fileID);
            totalDataSize += restoredFileMeta.dataSize;
            if (fileMeta.addAndGetDBReference(0) != 0) continue;
            this.waitingSnapshotDeletionFiles.add(fileMeta);
        }
        this.fileIDGenerator.restoreFileIDs(fileIDS);
        this.fileManagerStat.addTotalDataSize(totalDataSize);
        this.fileManagerStat.setMaxUsedFile(this.fileMapping.size());
        this.fileManagerStat.setNumberUsedFile(this.fileMapping.size());
        LOG.info("restore file manager successfully at {}", (Object)this.workingBasePath);
    }

    @Override
    public Map<Integer, FileMeta> getFileMapping() {
        return Collections.unmodifiableMap(this.fileMapping);
    }

    @Override
    public Map<FileID, String> getFileMapping(Set<FileID> fileIDs) {
        Set extractFileIDs = fileIDs.stream().map(FileID::get).collect(Collectors.toSet());
        return this.fileMapping.entrySet().stream().filter(extractFileIDs::contains).collect(Collectors.toMap(f -> new FileIDImpl((Integer)f.getKey()), e -> ((FileMeta)e.getValue()).getFilePath()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void increaseFileWriterErrorCount() {
        Tuple2<Long, Integer> tuple2 = this.fileWriterErrorStatus;
        synchronized (tuple2) {
            if ((Long)this.fileWriterErrorStatus.f0 == -1L) {
                this.fileWriterErrorStatus.f0 = System.currentTimeMillis();
            }
            Tuple2<Long, Integer> tuple22 = this.fileWriterErrorStatus;
            Integer n = (Integer)tuple22.f1;
            tuple22.f1 = (Integer)tuple22.f1 + 1;
            Integer n2 = tuple22.f1;
        }
        this.exceptionStat.addTotalFileWriterShift(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resetFileWriterErrorCount() {
        Tuple2<Long, Integer> tuple2 = this.fileWriterErrorStatus;
        synchronized (tuple2) {
            this.fileWriterErrorStatus.f0 = -1L;
            this.fileWriterErrorStatus.f1 = 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isValid() {
        long disableCreateFileWriterTimestamp;
        int errorCount;
        boolean ret = true;
        Tuple2<Long, Integer> tuple2 = this.fileWriterErrorStatus;
        synchronized (tuple2) {
            errorCount = (Integer)this.fileWriterErrorStatus.f1;
            disableCreateFileWriterTimestamp = (Long)this.fileWriterErrorStatus.f0;
        }
        if (errorCount >= this.fileManagerFailCountThreshold) {
            if (System.currentTimeMillis() - disableCreateFileWriterTimestamp < this.retryCreateFileWriterInterval) {
                ret = false;
            } else {
                this.resetFileWriterErrorCount();
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Iterator<FileMeta> iterator = this;
        synchronized (iterator) {
            if (this.closed) {
                LOG.warn("FileManager ({}) has been closed", (Object)this.workingBasePath);
                return;
            }
            this.closed = true;
        }
        this.fileDeletionCheckExecutor.shutdownNow();
        for (FileMeta fileMeta : this.fileMapping.values()) {
            FileReader fileReader;
            FileWriter fileWriter = fileMeta.getFileWriter();
            if (fileWriter != null) {
                try {
                    fileWriter.close();
                }
                catch (Exception e) {
                    LOG.error("failed to close writer {}", (Object)fileMeta, (Object)e);
                }
                finally {
                    fileMeta.setFileWriter(null);
                }
            }
            if ((fileReader = fileMeta.getFileReader()) == null) continue;
            try {
                fileReader.close();
            }
            catch (Exception e) {
                LOG.error("failed to close reader {}", (Object)fileMeta, (Object)e);
            }
        }
        if (this.snapshotStorage) {
            for (FileMeta fileMeta : this.fileMapping.values()) {
                if (fileMeta.addAndGetSnapshotReference(0) != 0 || !fileMeta.canDeleted()) continue;
                this.markedDeletionFiles.add(fileMeta.getFilePath());
                LOG.info("Mark file deletion when close: {}", (Object)fileMeta);
            }
            this.fileMapping.clear();
            this.gContext.getSupervisor().getFileCleaner().triggerCleanup(this);
        } else {
            try {
                this.workingBasePath.getFileSystem().delete(this.workingBasePath, true);
                LOG.info("FileManager is not a snapshot storage, delete the whole working base path, {}", (Object)this.workingBasePath);
            }
            catch (Exception e) {
                LOG.warn("Fail to delete the working base path {}", (Object)this.workingBasePath);
            }
        }
        LOG.info("File manager ({}) is closed", (Object)this.workingBasePath);
    }

    public String toString() {
        return "FileManager{" + this.workingBasePath + "}";
    }

    @VisibleForTesting
    FileIDGenerator getFileIDGenerator() {
        return this.fileIDGenerator;
    }

    @VisibleForTesting
    SortedSet<FileMeta> getWaitingDBDeletionFiles() {
        return this.waitingDBDeletionFiles;
    }

    @VisibleForTesting
    Set<FileMeta> getWaitingSnapshotDeletionFiles() {
        return this.waitingSnapshotDeletionFiles;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void markFileDeletion(FileMeta fileMeta) {
        FileReader fileReader;
        FileID fileID = fileMeta.getFileId();
        FileMeta oldFileMeta = this.fileMapping.get(fileID.get());
        Preconditions.checkState((oldFileMeta == fileMeta ? 1 : 0) != 0, (Object)"delete a file not in mapping table");
        FileWriter fileWriter = fileMeta.getFileWriter();
        if (fileWriter != null) {
            try {
                fileWriter.close();
            }
            catch (Exception e) {
                LOG.error("failed to close writer when marking deletion, {}, ", (Object)fileMeta, (Object)e);
            }
            finally {
                fileMeta.setFileWriter(null);
            }
        }
        if ((fileReader = fileMeta.getFileReader()) != null) {
            try {
                fileReader.close();
            }
            catch (Exception e) {
                LOG.error("failed to close reader when marking deletion, {}, {}", (Object)fileMeta, (Object)e);
            }
            finally {
                fileMeta.setFileReader(null);
            }
        }
        if (fileMeta.canDeleted()) {
            this.markedDeletionFiles.add(fileMeta.getFilePath());
            if (this.closed) {
                this.deleteFile(fileMeta.getFilePath(), false);
            }
        }
        this.fileMapping.remove(fileID.get());
        this.recycleFileID(fileID);
        this.fileManagerStat.addTotalDeletedFile(1);
    }

    private void checkDBStatus() {
        if (this.closed) {
            throw new GeminiRuntimeException("FileManager (" + this.workingBasePath + ") has been closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void recycleFileID(FileID fileID) {
        FileIDGenerator fileIDGenerator = this.fileIDGenerator;
        synchronized (fileIDGenerator) {
            this.fileIDGenerator.recycleFileID(fileID);
        }
    }

    private void deleteFile(String fileName, boolean recursive) {
        try {
            Path path = new Path(fileName);
            FileSystem.get((URI)path.toUri()).delete(path, recursive);
        }
        catch (Exception e) {
            LOG.warn("Fail to delete file {}, {}", (Object)fileName, (Object)e);
        }
    }

    private void printStat() {
        long time;
        if (LOG.isDebugEnabled() && this.lastPrintStatTime + 60000L < (time = System.currentTimeMillis())) {
            this.lastPrintStatTime = time;
            this.fileManagerStat.setNumberUsedFile(this.fileMapping.size());
            this.fileManagerStat.setNumberWaitingDBDeletionFile(this.waitingDBDeletionFiles.size());
            this.fileManagerStat.setNumberWaitingSnapshotDeletionFile(this.waitingSnapshotDeletionFiles.size());
            this.fileManagerStat.setNumberMarkDeletionFile(this.markedDeletionFiles.size());
            LOG.info("FileManagerStat {}, {}", (Object)this.workingBasePath, (Object)this.fileManagerStat);
        }
    }

    private long getCurrentAccessNumber() {
        return Math.min(this.gContext.getAccessNumber(), this.gContext.getMinSnapshotAccessNumber());
    }

    @Override
    public DataPageUtil getDataPageUtil() {
        return this.dataPageUtil;
    }

    private class DBDeletionCheckRunner
    implements Runnable {
        private DBDeletionCheckRunner() {
        }

        @Override
        public void run() {
            long currentTime = System.currentTimeMillis();
            long deleteTime = currentTime - FileManagerImpl.this.fileAliveTimeAfterNoDBReference;
            while (!FileManagerImpl.this.closed && !FileManagerImpl.this.waitingDBDeletionFiles.isEmpty()) {
                FileMeta fileMeta = (FileMeta)FileManagerImpl.this.waitingDBDeletionFiles.first();
                long currentAccessNumber = FileManagerImpl.this.getCurrentAccessNumber();
                if (fileMeta.getDiscardAccessNumber() >= currentAccessNumber || fileMeta.getDiscardTimeStamp() >= deleteTime) break;
                FileManagerImpl.this.waitingDBDeletionFiles.remove(fileMeta);
                try {
                    FileReader fileReader = fileMeta.getFileReader();
                    if (fileReader != null) {
                        fileReader.close();
                        fileMeta.setFileReader(null);
                    }
                }
                catch (Exception e) {
                    LOG.error("failed to close file reader when moving from db deletion set to snapshot set, {}, {}", (Object)fileMeta, (Object)e);
                }
                FileManagerImpl.this.waitingSnapshotDeletionFiles.add(fileMeta);
                LOG.debug("Add file to waitingSnapshotDeletionFiles {}, current time {}, current access number {}", new Object[]{fileMeta, currentTime, currentAccessNumber});
                if (fileMeta.addAndGetSnapshotReference(0) != 0 || !FileManagerImpl.this.waitingSnapshotDeletionFiles.remove(fileMeta)) continue;
                FileManagerImpl.this.markFileDeletion(fileMeta);
                LOG.debug("Mark file deletion by DB {}", (Object)fileMeta);
            }
            FileManagerImpl.this.printStat();
        }
    }
}

