/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.gemini.engine.fs;

import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.flink.shaded.guava18.com.google.common.base.MoreObjects;

public class FileManagerStat {
    public AtomicInteger maxUsedFile = new AtomicInteger(0);
    public AtomicInteger numberUsedFile = new AtomicInteger(0);
    public AtomicInteger numberWaitingDBDeletionFile = new AtomicInteger(0);
    public AtomicInteger numberWaitingSnapshotDeletionFile = new AtomicInteger(0);
    public AtomicInteger numberMarkDeletionFile = new AtomicInteger(0);
    public AtomicInteger totalCreatedFile = new AtomicInteger(0);
    public AtomicInteger totalFailCreateFile = new AtomicInteger(0);
    public AtomicInteger totalDeletedFile = new AtomicInteger(0);
    public AtomicLong totalDataSize = new AtomicLong(0L);

    public void setMaxUsedFile(int number) {
        int prev = this.maxUsedFile.get();
        int cur = Math.max(prev, number);
        this.maxUsedFile.compareAndSet(prev, cur);
    }

    public void setNumberUsedFile(int number) {
        this.numberUsedFile.set(number);
    }

    public void setNumberWaitingDBDeletionFile(int number) {
        this.numberWaitingDBDeletionFile.set(number);
    }

    public void setNumberWaitingSnapshotDeletionFile(int number) {
        this.numberWaitingSnapshotDeletionFile.set(number);
    }

    public void setNumberMarkDeletionFile(int number) {
        this.numberMarkDeletionFile.set(number);
    }

    public int addTotalCreatedFile(int delta) {
        return this.totalCreatedFile.addAndGet(delta);
    }

    public int addTotalFailCreateFile(int delta) {
        return this.totalFailCreateFile.addAndGet(delta);
    }

    public int addTotalDeletedFile(int delta) {
        return this.totalDeletedFile.addAndGet(delta);
    }

    public long addTotalDataSize(long dataSize) {
        return this.totalDataSize.addAndGet(dataSize);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("maxUsedFile", this.maxUsedFile.get()).add("numberUsedFile", this.numberUsedFile.get()).add("numberWaitingDBDeletionFile", this.numberWaitingDBDeletionFile.get()).add("numberWaitingSnapshotDeletionFile", this.numberWaitingSnapshotDeletionFile.get()).add("numberMarkDeletionFile", this.numberMarkDeletionFile.get()).add("totalCreatedFile", this.totalCreatedFile.get()).add("totalFailCreateFile", this.totalFailCreateFile.get()).add("totalDeletedFile", this.totalDeletedFile.get()).add("totalDataSize", this.totalDataSize.get()).toString();
    }
}

