/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.gemini.engine.fs;

import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.Nullable;
import org.apache.flink.runtime.state.gemini.engine.fs.FileID;
import org.apache.flink.runtime.state.gemini.engine.fs.FileReader;
import org.apache.flink.runtime.state.gemini.engine.fs.FileWriter;

public class FileMeta {
    private final boolean canDeleted;
    private final String filePath;
    private final FileID fileId;
    private AtomicLong dataSize;
    private AtomicLong fileSize;
    private AtomicInteger dbReference;
    private AtomicInteger snapshotReference;
    private long discardTimeStamp;
    private long discardAccessNumber;
    @Nullable
    private FileWriter fileWriter;
    @Nullable
    private FileReader fileReader;

    public FileMeta(String filePath, FileID fileId) {
        this(filePath, fileId, 0L, 0L, 0, 0, true);
    }

    public FileMeta(String filePath, FileID fileId, long fileSize, long dataSize, int dbReference, int snapshotReference, boolean canDeleted) {
        this.filePath = filePath;
        this.fileId = fileId;
        this.fileSize = new AtomicLong(fileSize);
        this.dataSize = new AtomicLong(dataSize);
        this.dbReference = new AtomicInteger(dbReference);
        this.snapshotReference = new AtomicInteger(snapshotReference);
        this.canDeleted = canDeleted;
        this.discardAccessNumber = -1L;
        this.discardTimeStamp = -1L;
    }

    public String getFilePath() {
        return this.filePath;
    }

    public FileID getFileId() {
        return this.fileId;
    }

    public long getFileSize() {
        return this.fileSize.get();
    }

    public long addAndGetDataSize(long size) {
        this.fileSize.addAndGet(size > 0L ? size : 0L);
        return this.dataSize.addAndGet(size);
    }

    public int addAndGetDBReference(int delta) {
        return this.dbReference.addAndGet(delta);
    }

    public int addAndGetSnapshotReference(int delta) {
        return this.snapshotReference.addAndGet(delta);
    }

    public long getDiscardTimeStamp() {
        return this.discardTimeStamp;
    }

    public long getDiscardAccessNumber() {
        return this.discardAccessNumber;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateDiscardAccessNumberAndTimestamp(long accessNumber, long timestamp) {
        FileMeta fileMeta = this;
        synchronized (fileMeta) {
            this.discardAccessNumber = Math.max(accessNumber, this.discardAccessNumber);
            this.discardTimeStamp = Math.max(timestamp, this.discardTimeStamp);
        }
    }

    public void setFileWriter(FileWriter fileWriter) {
        this.fileWriter = fileWriter;
    }

    public FileWriter getFileWriter() {
        return this.fileWriter;
    }

    public void setFileReader(FileReader fileReader) {
        this.fileReader = fileReader;
    }

    public FileReader getFileReader() {
        return this.fileReader;
    }

    public boolean canDeleted() {
        return this.canDeleted;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FileMeta)) {
            return false;
        }
        FileMeta fileMeta = (FileMeta)o;
        return Objects.equals(this.fileId, fileMeta.fileId) && Objects.equals(this.filePath, fileMeta.filePath) && this.canDeleted == fileMeta.canDeleted;
    }

    public int hashCode() {
        int result = Objects.hashCode(this.fileId);
        result = 31 * result + Objects.hashCode(this.filePath);
        result = 31 * result + Objects.hashCode(this.canDeleted);
        return result;
    }

    public String toString() {
        return "FileMeta{filePath=" + this.filePath + ", fileId=" + this.fileId + ", canDeleted=" + this.canDeleted + ", fileSize=" + this.fileSize + ", dataSize=" + this.dataSize + ", dataRef=" + this.dbReference + ", snapshotRef=" + this.snapshotReference + ", discardTimeStamp=" + this.discardTimeStamp + ", discardAccessNumber=" + this.discardAccessNumber + '}';
    }

    public static class RestoredFileMeta {
        public int id;
        public String filePath;
        public long fileSize;
        public long dataSize;
        public int dbReference;
        public int snapshotReference;
        public boolean canDeleted;

        public static RestoredFileMeta of(int id, String filePath, long fileSize) {
            RestoredFileMeta restoredFileMeta = new RestoredFileMeta();
            restoredFileMeta.id = id;
            restoredFileMeta.filePath = filePath;
            restoredFileMeta.fileSize = fileSize;
            return restoredFileMeta;
        }

        public static RestoredFileMeta of(int id, String filePath, long fileSize, long dataSize, int dbReference, int snapshotReference, boolean canDeleted) {
            RestoredFileMeta restoredFileMeta = new RestoredFileMeta();
            restoredFileMeta.id = id;
            restoredFileMeta.filePath = filePath;
            restoredFileMeta.fileSize = fileSize;
            restoredFileMeta.dataSize = dataSize;
            restoredFileMeta.dbReference = dbReference;
            restoredFileMeta.snapshotReference = snapshotReference;
            restoredFileMeta.canDeleted = canDeleted;
            return restoredFileMeta;
        }

        public void setUsedDataSizeAndReference(long dataSize, int dbReference, int snapshotReference, boolean canDeleted) {
            this.dataSize = dataSize;
            this.dbReference = dbReference;
            this.snapshotReference = snapshotReference;
            this.canDeleted = canDeleted;
        }
    }
}

