/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.gemini.engine.fs;

import java.io.IOException;
import org.apache.flink.core.fs.FSDataInputStream;

public class GeminiBufferedInputStream
extends FSDataInputStream {
    private static final int DEFAULT_BUFFER_SIZE = 8192;
    protected volatile byte[] buffer;
    protected int count;
    protected int pos;
    private final FSDataInputStream in;

    public GeminiBufferedInputStream(FSDataInputStream in) {
        this(in, 8192);
    }

    public GeminiBufferedInputStream(FSDataInputStream in, int size) {
        this.in = in;
        if (size <= 0) {
            throw new IllegalArgumentException("Buffer size <= 0");
        }
        this.buffer = new byte[size];
    }

    private void fill() throws IOException {
        this.count = 0;
        this.pos = 0;
        int n = this.in.read(this.buffer, this.pos, this.buffer.length);
        if (n > 0) {
            this.count = n + this.pos;
        }
    }

    public int read() throws IOException {
        if (this.pos >= this.count) {
            this.fill();
            if (this.pos >= this.count) {
                return -1;
            }
        }
        return this.buffer[this.pos++] & 0xFF;
    }

    private int read1(byte[] b, int off, int len) throws IOException {
        int avail = this.count - this.pos;
        if (avail <= 0) {
            if (len >= this.buffer.length) {
                return this.in.read(b, off, len);
            }
            this.fill();
            avail = this.count - this.pos;
            if (avail <= 0) {
                return -1;
            }
        }
        int cnt = avail < len ? avail : len;
        System.arraycopy(this.buffer, this.pos, b, off, cnt);
        this.pos += cnt;
        return cnt;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        int nread;
        if ((off | len | off + len | b.length - (off + len)) < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return 0;
        }
        int n = 0;
        do {
            if ((nread = this.read1(b, off + n, len - n)) > 0) continue;
            return n == 0 ? nread : n;
        } while ((n += nread) < len && this.in.available() > 0);
        return n;
    }

    public long skip(long n) throws IOException {
        if (n <= 0L) {
            return 0L;
        }
        long avail = this.count - this.pos;
        if (avail <= 0L) {
            return this.in.skip(n);
        }
        long skipped = avail < n ? avail : n;
        this.pos = (int)((long)this.pos + skipped);
        return skipped;
    }

    public int available() throws IOException {
        int n = this.count - this.pos;
        int avail = this.in.available();
        return n > Integer.MAX_VALUE - avail ? Integer.MAX_VALUE : n + avail;
    }

    public void close() throws IOException {
        this.in.close();
        this.buffer = null;
    }

    public void seek(long desired) throws IOException {
        int avail = this.count - this.pos;
        if (avail <= 0) {
            this.in.seek(desired);
            return;
        }
        long upperPos = this.in.getPos();
        long lowerPos = upperPos - (long)this.count;
        if (desired > upperPos || desired < lowerPos) {
            this.pos = this.count;
            this.in.seek(desired);
            return;
        }
        this.pos = (int)(desired - lowerPos);
    }

    public long getPos() throws IOException {
        long streamPos = this.in.getPos();
        int n = this.count - this.pos;
        return streamPos - (long)n;
    }

    public FSDataInputStream getWrappedInputStream() {
        return this.in;
    }
}

