/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.gemini.engine.fs;

import java.io.IOException;
import org.apache.flink.core.fs.FSDataOutputStream;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeminiBufferedOutputStream
extends FSDataOutputStream {
    private static final Logger LOG = LoggerFactory.getLogger(GeminiBufferedOutputStream.class);
    private final byte[] writeBuffer;
    private int pos;
    private FSDataOutputStream outStream;
    private volatile boolean closed;

    public GeminiBufferedOutputStream(FSDataOutputStream outStream, int bufferSize) {
        this.outStream = (FSDataOutputStream)Preconditions.checkNotNull((Object)outStream);
        this.writeBuffer = new byte[bufferSize];
    }

    public synchronized void write(int b) throws IOException {
        if (this.pos >= this.writeBuffer.length) {
            this.flush();
        }
        this.writeBuffer[this.pos++] = (byte)b;
    }

    public synchronized void write(byte[] b, int off, int len) throws IOException {
        if (len < this.writeBuffer.length / 2) {
            int remaining = this.writeBuffer.length - this.pos;
            if (len > remaining) {
                System.arraycopy(b, off, this.writeBuffer, this.pos, remaining);
                off += remaining;
                len -= remaining;
                this.pos += remaining;
                this.flush();
            }
            System.arraycopy(b, off, this.writeBuffer, this.pos, len);
            this.pos += len;
        } else {
            this.flush();
            this.outStream.write(b, off, len);
        }
    }

    public synchronized long getPos() throws IOException {
        return (long)this.pos + this.outStream.getPos();
    }

    public synchronized void flush() throws IOException {
        if (!this.closed) {
            if (this.pos > 0) {
                this.outStream.write(this.writeBuffer, 0, this.pos);
                this.pos = 0;
            }
        } else {
            throw new IOException("closed");
        }
    }

    public synchronized void sync() throws IOException {
        this.flush();
        this.outStream.sync();
    }

    public boolean isClosed() {
        return this.closed;
    }

    public synchronized void close() throws IOException {
        if (!this.closed) {
            this.flush();
            this.outStream.close();
            this.closed = true;
        }
    }
}

