/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.gemini.engine.fs;

import java.io.DataOutput;
import java.io.IOException;
import java.io.UTFDataFormatException;
import org.apache.flink.core.fs.FSDataOutputStream;
import org.apache.flink.runtime.state.gemini.engine.fs.GeminiOutputStream;
import org.apache.flink.util.Preconditions;

public class GeminiDataOutputStream
extends FSDataOutputStream
implements DataOutput {
    protected final GeminiOutputStream out;
    protected int written;
    private byte[] bytearr = null;
    private byte[] writeBuffer = new byte[8];

    public GeminiDataOutputStream(GeminiOutputStream out) {
        this.out = (GeminiOutputStream)((Object)Preconditions.checkNotNull((Object)((Object)out)));
    }

    private void incCount(int value) {
        int temp = this.written + value;
        if (temp < 0) {
            temp = Integer.MAX_VALUE;
        }
        this.written = temp;
    }

    @Override
    public void write(int b) throws IOException {
        this.out.write(b);
        this.incCount(1);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.out.write(b, off, len);
        this.incCount(len);
    }

    public void flush() throws IOException {
        this.out.flush();
    }

    public void close() throws IOException {
        this.out.close();
    }

    public long getPos() throws IOException {
        return this.out.getPos();
    }

    public void sync() throws IOException {
        this.out.sync();
    }

    @Override
    public final void writeBoolean(boolean v) throws IOException {
        this.out.write(v ? 1 : 0);
        this.incCount(1);
    }

    @Override
    public final void writeByte(int v) throws IOException {
        this.out.write(v);
        this.incCount(1);
    }

    @Override
    public final void writeShort(int v) throws IOException {
        this.out.write(v >>> 8 & 0xFF);
        this.out.write(v >>> 0 & 0xFF);
        this.incCount(2);
    }

    @Override
    public final void writeChar(int v) throws IOException {
        this.out.write(v >>> 8 & 0xFF);
        this.out.write(v >>> 0 & 0xFF);
        this.incCount(2);
    }

    @Override
    public final void writeInt(int v) throws IOException {
        this.out.write(v >>> 24 & 0xFF);
        this.out.write(v >>> 16 & 0xFF);
        this.out.write(v >>> 8 & 0xFF);
        this.out.write(v >>> 0 & 0xFF);
        this.incCount(4);
    }

    @Override
    public final void writeLong(long v) throws IOException {
        this.writeBuffer[0] = (byte)(v >>> 56);
        this.writeBuffer[1] = (byte)(v >>> 48);
        this.writeBuffer[2] = (byte)(v >>> 40);
        this.writeBuffer[3] = (byte)(v >>> 32);
        this.writeBuffer[4] = (byte)(v >>> 24);
        this.writeBuffer[5] = (byte)(v >>> 16);
        this.writeBuffer[6] = (byte)(v >>> 8);
        this.writeBuffer[7] = (byte)(v >>> 0);
        this.out.write(this.writeBuffer, 0, 8);
        this.incCount(8);
    }

    @Override
    public final void writeFloat(float v) throws IOException {
        this.writeInt(Float.floatToIntBits(v));
    }

    @Override
    public final void writeDouble(double v) throws IOException {
        this.writeLong(Double.doubleToLongBits(v));
    }

    @Override
    public final void writeBytes(String s) throws IOException {
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            this.out.write((byte)s.charAt(i));
        }
        this.incCount(len);
    }

    @Override
    public final void writeChars(String s) throws IOException {
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            char v = s.charAt(i);
            this.out.write(v >>> 8 & 0xFF);
            this.out.write(v >>> 0 & 0xFF);
        }
        this.incCount(len * 2);
    }

    @Override
    public final void writeUTF(String str) throws IOException {
        GeminiDataOutputStream.writeUTF(str, this);
    }

    static int writeUTF(String str, DataOutput out) throws IOException {
        char c;
        int strlen = str.length();
        int utflen = 0;
        int count = 0;
        for (int i = 0; i < strlen; ++i) {
            c = str.charAt(i);
            if (c >= '\u0001' && c <= '\u007f') {
                ++utflen;
                continue;
            }
            if (c > '\u07ff') {
                utflen += 3;
                continue;
            }
            utflen += 2;
        }
        if (utflen > 65535) {
            throw new UTFDataFormatException("encoded string too long: " + utflen + " bytes");
        }
        byte[] bytearr = null;
        if (out instanceof GeminiDataOutputStream) {
            GeminiDataOutputStream dos = (GeminiDataOutputStream)out;
            if (dos.bytearr == null || dos.bytearr.length < utflen + 2) {
                dos.bytearr = new byte[utflen * 2 + 2];
            }
            bytearr = dos.bytearr;
        } else {
            bytearr = new byte[utflen + 2];
        }
        bytearr[count++] = (byte)(utflen >>> 8 & 0xFF);
        bytearr[count++] = (byte)(utflen >>> 0 & 0xFF);
        int i = 0;
        for (i = 0; i < strlen && (c = str.charAt(i)) >= '\u0001' && c <= '\u007f'; ++i) {
            bytearr[count++] = (byte)c;
        }
        while (i < strlen) {
            c = str.charAt(i);
            if (c >= '\u0001' && c <= '\u007f') {
                bytearr[count++] = (byte)c;
            } else if (c > '\u07ff') {
                bytearr[count++] = (byte)(0xE0 | c >> 12 & 0xF);
                bytearr[count++] = (byte)(0x80 | c >> 6 & 0x3F);
                bytearr[count++] = (byte)(0x80 | c >> 0 & 0x3F);
            } else {
                bytearr[count++] = (byte)(0xC0 | c >> 6 & 0x1F);
                bytearr[count++] = (byte)(0x80 | c >> 0 & 0x3F);
            }
            ++i;
        }
        out.write(bytearr, 0, utflen + 2);
        return utflen + 2;
    }

    public final int size() {
        return this.written;
    }
}

