/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.gemini.engine.fs;

import java.io.IOException;
import java.net.URI;
import java.nio.ByteBuffer;
import javax.annotation.Nonnull;
import org.apache.flink.core.fs.FSDataInputStream;
import org.apache.flink.core.fs.FileSystem;
import org.apache.flink.core.fs.Path;
import org.apache.flink.runtime.fs.hdfs.HadoopDataInputStream;
import org.apache.flink.runtime.state.gemini.engine.fs.GeminiLocalByteBufferableInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeminiInputStream
extends FSDataInputStream {
    private static final Logger LOG = LoggerFactory.getLogger(GeminiInputStream.class);
    private static final int DEFAULT_BUFFER_SIZE = 4096;
    private final FileSystem fileSystem;
    private final Path filePath;
    private FSDataInputStream inputStream;

    public GeminiInputStream(Path filePath) throws IOException {
        this(filePath, 4096);
    }

    public GeminiInputStream(Path filePath, int bufferSize) throws IOException {
        this.filePath = filePath;
        this.fileSystem = FileSystem.getUnguardedFileSystem((URI)filePath.toUri());
        this.inputStream = !this.fileSystem.isDistributedFS() ? new GeminiLocalByteBufferableInputStream(this.fileSystem.getWorkingDirectory(), filePath) : this.fileSystem.open(filePath, bufferSize);
    }

    public long getPos() throws IOException {
        return this.inputStream.getPos();
    }

    public int read() throws IOException {
        return this.inputStream.read();
    }

    public int read(@Nonnull byte[] buffer, int offset, int length) throws IOException {
        return this.inputStream.read(buffer, offset, length);
    }

    @Deprecated
    public int read(int position, @Nonnull byte[] buffer, int offset, int length) throws IOException {
        if (this.fileSystem.isDistributedFS()) {
            return ((HadoopDataInputStream)this.inputStream).getHadoopInputStream().read((long)position, buffer, offset, length);
        }
        ByteBuffer bb = ByteBuffer.wrap(buffer, offset, length);
        return ((GeminiLocalByteBufferableInputStream)this.inputStream).read(position, bb);
    }

    public int readByteBuffer(int position, @Nonnull ByteBuffer buffer) throws IOException {
        if (this.fileSystem.isDistributedFS()) {
            throw new IOException("now GeminiInputStream HDFS not support readByteBuffer");
        }
        return ((GeminiLocalByteBufferableInputStream)this.inputStream).read(position, buffer);
    }

    public int available() throws IOException {
        return this.inputStream.available();
    }

    public void seek(long desired) throws IOException {
        this.inputStream.seek(desired);
    }

    public void close() throws IOException {
        this.inputStream.close();
    }
}

