/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.gemini.engine.fs;

import java.io.IOException;
import java.net.URI;
import org.apache.flink.core.fs.FSDataOutputStream;
import org.apache.flink.core.fs.FileSystem;
import org.apache.flink.core.fs.Path;
import org.apache.flink.runtime.fs.hdfs.HadoopFileSystem;
import org.apache.flink.runtime.state.gemini.engine.fs.GeminiBufferedOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeminiOutputStream
extends FSDataOutputStream {
    private static final Logger LOG = LoggerFactory.getLogger(GeminiOutputStream.class);
    private static final int DEFAULT_BUFFER_SIZE = 4096;
    private final FileSystem fileSystem;
    private final Path filePath;
    private FSDataOutputStream outStream;
    private final Object lock = new Object();
    private volatile boolean closed;

    public GeminiOutputStream(Path filePath) throws IOException {
        this(filePath, FileSystem.WriteMode.NO_OVERWRITE);
    }

    public GeminiOutputStream(Path filePath, FileSystem.WriteMode writeMode) throws IOException {
        this(filePath, writeMode, 4096);
    }

    public GeminiOutputStream(Path filePath, FileSystem.WriteMode writeMode, int bufferSize) throws IOException {
        this.filePath = filePath;
        this.fileSystem = FileSystem.getUnguardedFileSystem((URI)filePath.toUri());
        FSDataOutputStream stream = this.fileSystem.create(filePath, writeMode);
        this.outStream = this.fileSystem instanceof HadoopFileSystem ? stream : new GeminiBufferedOutputStream(stream, bufferSize);
        this.closed = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(int b) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.outStream.write(b);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(byte[] b, int off, int len) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.outStream.write(b, off, len);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getPos() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            return this.outStream.getPos();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.closed) {
                return;
            }
            this.outStream.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sync() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.closed) {
                return;
            }
            this.outStream.sync();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.closed) {
                return;
            }
            this.closed = true;
            this.outStream.close();
        }
    }
}

