/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.gemini.engine.fs;

import org.apache.flink.runtime.state.gemini.engine.dbms.GContext;
import org.apache.flink.runtime.state.gemini.engine.exceptions.GeminiRuntimeException;
import org.apache.flink.runtime.state.gemini.engine.fs.NonePersistence;
import org.apache.flink.runtime.state.gemini.engine.fs.PersistHugePageToLocalSync;
import org.apache.flink.runtime.state.gemini.engine.fs.PersistenceGroupPageToDfs;
import org.apache.flink.runtime.state.gemini.engine.fs.PersistenceProxy;
import org.apache.flink.runtime.state.gemini.engine.fs.PersistenceStrategy;

public class PersistenceStrategyFactory {
    public static final PersistenceStrategyFactory INSTANCE = new PersistenceStrategyFactory();

    public PersistenceStrategy create(GContext gContext) {
        PersistenceType persistenceType = gContext.getGConfiguration().getPersistenceType();
        switch (persistenceType) {
            case none: {
                return new NonePersistence();
            }
            case asyncDfs: {
                return new PersistenceGroupPageToDfs(gContext);
            }
            case syncHugeToCache: {
                return new PersistHugePageToLocalSync(gContext);
            }
            case bothDfsAndSyncHugeToCache: {
                PersistenceProxy persistenceStrategy = new PersistenceProxy();
                persistenceStrategy.add(new PersistenceGroupPageToDfs(gContext));
                persistenceStrategy.add(new PersistHugePageToLocalSync(gContext));
                return persistenceStrategy;
            }
        }
        throw new GeminiRuntimeException("error type:" + (Object)((Object)persistenceType));
    }

    public static enum PersistenceLevel {
        flush,
        sync;


        public static PersistenceLevel getPersistenceLevel(String type) {
            if (type == null || "flush".equalsIgnoreCase(type)) {
                return flush;
            }
            if ("sync".equalsIgnoreCase(type)) {
                return sync;
            }
            return flush;
        }
    }

    public static enum PersistenceType {
        none,
        asyncDfs,
        syncHugeToCache,
        bothDfsAndSyncHugeToCache;


        public static PersistenceType getPersistenceType(String type) {
            if (type == null || "off".equalsIgnoreCase(type) || "none".equalsIgnoreCase(type)) {
                return none;
            }
            if ("asyncDfs".equalsIgnoreCase(type)) {
                return asyncDfs;
            }
            if ("syncHugeToCache".equalsIgnoreCase(type)) {
                return syncHugeToCache;
            }
            if ("bothDfsAndSyncHugeToCache".equalsIgnoreCase(type)) {
                return bothDfsAndSyncHugeToCache;
            }
            return none;
        }
    }
}

