/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.gemini.engine.handler;

import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.locks.LockSupport;
import org.apache.flink.runtime.state.gemini.engine.dbms.GContext;
import org.apache.flink.runtime.state.gemini.engine.handler.GeminiEventExecutorGroup;
import org.apache.flink.runtime.state.gemini.engine.handler.GeminiEventExecutorTask;
import org.apache.flink.shaded.netty4.io.netty.util.concurrent.EventExecutorGroup;
import org.apache.flink.shaded.netty4.io.netty.util.concurrent.Future;
import org.apache.flink.shaded.netty4.io.netty.util.concurrent.SingleThreadEventExecutor;

public final class GeminiEventExecutor
extends SingleThreadEventExecutor {
    private ConcurrentLinkedQueue<Runnable> queue;
    private final long sleepTimeNs;
    private final GContext gContext;

    public GeminiEventExecutor(GeminiEventExecutorGroup parent, Executor executor, long sleepTimeNs, GContext gContext) {
        super((EventExecutorGroup)parent, executor, true);
        this.sleepTimeNs = sleepTimeNs;
        this.gContext = gContext;
    }

    protected void run() {
        do {
            Runnable task;
            if ((task = this.queue.poll()) != null) {
                task.run();
                this.updateLastExecutionTime();
                continue;
            }
            LockSupport.parkNanos(this.sleepTimeNs);
        } while (!this.confirmShutdown());
    }

    public void execute(Runnable task) {
        if (task instanceof GeminiEventExecutorTask) {
            super.execute(() -> {
                if (this.gContext.isDBNormal()) {
                    task.run();
                } else {
                    ((GeminiEventExecutorTask)task).cancel();
                }
            });
        } else {
            super.execute(task);
        }
    }

    public Future<?> submit(Runnable task) {
        if (task instanceof GeminiEventExecutorTask) {
            return super.submit(() -> {
                if (this.gContext.isDBNormal()) {
                    task.run();
                } else {
                    ((GeminiEventExecutorTask)task).cancel();
                }
            });
        }
        return super.submit(task);
    }

    protected Queue<Runnable> newTaskQueue(int maxPendingTasks) {
        this.queue = new ConcurrentLinkedQueue();
        return this.queue;
    }

    public String toString() {
        return "GeminiEventExecutor {start = " + this.gContext.getStartRegionId() + "end = " + this.gContext.getEndRegionId() + "size = " + this.queue.size();
    }
}

