/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.gemini.engine.handler;

import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.core.memory.ByteArrayOutputStreamWithPos;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.core.memory.DataOutputViewStreamWrapper;
import org.apache.flink.runtime.state.gemini.engine.exceptions.GeminiRuntimeException;
import org.apache.flink.runtime.state.gemini.engine.handler.AbstractRegionHandler;
import org.apache.flink.runtime.state.gemini.engine.handler.PageHandler;
import org.apache.flink.runtime.state.gemini.engine.hashtable.GRegionKVImpl;
import org.apache.flink.runtime.state.gemini.engine.memstore.GSValue;
import org.apache.flink.runtime.state.gemini.engine.memstore.SegmentImpl;
import org.apache.flink.runtime.state.gemini.engine.page.PageIndex;
import org.apache.flink.runtime.state.gemini.engine.page.PageIndexContext;
import org.apache.flink.runtime.state.gemini.engine.page.PageSerdeFlink;
import org.apache.flink.runtime.state.gemini.engine.page.PageStore;

public class PageKValueHandlerImpl<K, V>
extends AbstractRegionHandler
implements PageHandler {
    private final SegmentImpl<K, V> segment;
    private final GRegionKVImpl<K, V> gRegion;
    private final PageStore<K, V> pageStore;
    private final boolean onlyEstimatedSize;

    public PageKValueHandlerImpl(GRegionKVImpl<K, V> gRegion, SegmentImpl<K, V> segment, boolean onlyEstimatedSize) {
        super(gRegion.getGRegionContext());
        this.gRegion = gRegion;
        this.segment = segment;
        this.pageStore = gRegion.getPageStore();
        this.onlyEstimatedSize = onlyEstimatedSize;
    }

    @Override
    public void handle() {
        if (this.onlyEstimatedSize) {
            int keySize = this.estimateKeySize(this.segment);
            if (keySize > 0) {
                this.gRegion.getGRegionContext().getWriteBufferStats().setAverageKeyLen(keySize);
                this.gRegion.getGRegionContext().getWriteBufferStats().setAverageValueLen(this.estimateValueSize(this.segment));
            } else {
                this.gRegion.getGRegionContext().getWriteBufferStats().setAverageKeyLen(-2);
            }
            return;
        }
        PageIndex pageIndex = this.pageStore.getPageIndex();
        HashMap organizedData = new HashMap();
        this.segment.getDataMap().forEach((k, v) -> organizedData.computeIfAbsent(pageIndex.getPageIndexContext(k, true), nothing -> new ArrayList()).add(Tuple2.of((Object)k, (Object)v)));
        HashSet needSplitPageList = new HashSet();
        Iterator iterator = organizedData.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            if (((PageIndexContext)entry.getKey()).isNeedSplit()) {
                needSplitPageList.add(entry.getKey());
            }
            this.pageStore.addPage((PageIndexContext)entry.getKey(), (List)entry.getValue(), this.segment.getVersion());
            iterator.remove();
        }
        if (needSplitPageList.size() > 0) {
            needSplitPageList.stream().forEach(needSplitPage -> this.pageStore.splitPage((PageIndexContext)needSplitPage));
        }
        this.pageStore.checkResource();
    }

    private int estimateKeySize(SegmentImpl<K, V> segment) {
        if (segment.getDataMap() == null || segment.getDataMap().isEmpty()) {
            return 0;
        }
        try {
            PageSerdeFlink pageSerdeFlink = this.gRegionContext.getPageSerdeFlink();
            ByteArrayOutputStreamWithPos outputStream = new ByteArrayOutputStreamWithPos();
            DataOutputViewStreamWrapper outputView = new DataOutputViewStreamWrapper((OutputStream)outputStream);
            for (K key : segment.getDataMap().keySet()) {
                pageSerdeFlink.getKeySerde().serialize(key, (DataOutputView)outputView);
            }
            return outputStream.getPosition() / segment.getDataMap().size();
        }
        catch (Exception e) {
            throw new GeminiRuntimeException("estimateKeySize has exception=" + e.getMessage(), e);
        }
    }

    private int estimateValueSize(SegmentImpl<K, V> segment) {
        if (segment.getDataMap() == null || segment.getDataMap().isEmpty()) {
            return 0;
        }
        try {
            PageSerdeFlink pageSerdeFlink = this.gRegionContext.getPageSerdeFlink();
            ByteArrayOutputStreamWithPos outputStream = new ByteArrayOutputStreamWithPos();
            DataOutputViewStreamWrapper outputView = new DataOutputViewStreamWrapper((OutputStream)outputStream);
            int totalCount = 0;
            for (GSValue<V> value : segment.getDataMap().values()) {
                if (value.getValue() == null) continue;
                ++totalCount;
                pageSerdeFlink.getValueSerde().serialize(value.getValue(), (DataOutputView)outputView);
            }
            return totalCount == 0 ? 0 : outputStream.getPosition() / totalCount + 9;
        }
        catch (Exception e) {
            throw new GeminiRuntimeException("estimateValueSize has exception=" + e.getMessage(), e);
        }
    }
}

