/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.gemini.engine.hashtable;

import java.util.Map;
import javax.annotation.Nullable;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.runtime.state.gemini.engine.AbstractGeminiKMap;
import org.apache.flink.runtime.state.gemini.engine.GRegionContext;
import org.apache.flink.runtime.state.gemini.engine.GRegionID;
import org.apache.flink.runtime.state.gemini.engine.dbms.GContext;
import org.apache.flink.runtime.state.gemini.engine.hashtable.HashGRegion;
import org.apache.flink.runtime.state.gemini.engine.memstore.GSValue;
import org.apache.flink.runtime.state.gemini.engine.memstore.WriteBufferKMap;
import org.apache.flink.runtime.state.gemini.engine.page.GValueType;
import org.apache.flink.runtime.state.gemini.engine.page.PageIndex;
import org.apache.flink.runtime.state.gemini.engine.page.PageSerdeFlink2Key;
import org.apache.flink.runtime.state.gemini.engine.page.PageStoreKMap;
import org.apache.flink.shaded.netty4.io.netty.util.concurrent.EventExecutor;
import org.apache.flink.util.Preconditions;

public abstract class AbstractGRegionKMapImpl<K, MK, MV, M extends Map<MK, MV>>
implements AbstractGeminiKMap<K, MK, MV, M>,
HashGRegion {
    protected final GContext gContext;
    protected final GRegionContext gRegionContext;
    protected WriteBufferKMap<K, MK, MV> writeBuffer;
    protected PageStoreKMap<K, MK, MV> pageStore;
    protected final EventExecutor regionEventExecutor;
    protected boolean readCopy;
    protected TypeSerializer<K> keySerializer;
    protected TypeSerializer<MK> mkSerializer;
    protected TypeSerializer<MV> mvSerializer;

    public AbstractGRegionKMapImpl(GRegionContext gRegionContext, @Nullable PageIndex pageIndex) {
        this.gRegionContext = (GRegionContext)Preconditions.checkNotNull((Object)gRegionContext);
        this.gContext = gRegionContext.getGContext();
        this.regionEventExecutor = this.gContext.getSupervisor().getRegionExecutorGroup().next();
        gRegionContext.getPageStoreStats().setRegionExecutor(this.regionEventExecutor);
        this.gContext.getSupervisor().getCacheManager().addRegion(this);
        this.readCopy = gRegionContext.getGContext().getGConfiguration().isReadCopy();
        this.keySerializer = gRegionContext.getPageSerdeFlink().getKeySerde();
        this.mkSerializer = ((PageSerdeFlink2Key)gRegionContext.getPageSerdeFlink()).getKey2Serde();
        this.mvSerializer = gRegionContext.getPageSerdeFlink().getValueSerde();
        this.init(pageIndex);
    }

    abstract void init(PageIndex var1);

    @Override
    public void remove(K key) {
        this.gContext.checkDBStatus();
        this.gContext.incAccessNumber();
        this.writeBuffer.removeKey(key);
    }

    @Override
    public void removeAll() {
        this.gContext.checkDBStatus();
        this.gContext.incAccessNumber();
        long lastSeqID = this.gRegionContext.getLastSeqId();
        this.gRegionContext.setRemoveAllSeqId(lastSeqID);
        this.writeBuffer.reset();
    }

    @Override
    public Iterable<K> keys() {
        this.gContext.checkDBStatus();
        return this.getAll().keySet();
    }

    @Override
    public boolean contains(K key) {
        this.gContext.checkDBStatus();
        this.gContext.incAccessNumber();
        M result = this.internalGet(key, false);
        return result != null && !result.isEmpty();
    }

    @Override
    public boolean contains(K key, MK mapKey) {
        this.gContext.checkDBStatus();
        this.gContext.incAccessNumber();
        return this.internalGet(key, mapKey, false) != null;
    }

    @Override
    public MV get(K key, MK mapKey) {
        this.gContext.checkDBStatus();
        this.gContext.incAccessNumber();
        return this.internalGet(key, mapKey, true);
    }

    @Override
    public MV getOrDefault(K key, MK mapKey, MV defaultMapValue) {
        this.gContext.checkDBStatus();
        MV result = this.get(key, mapKey);
        return result == null ? defaultMapValue : result;
    }

    @Override
    public void add(K key, MK mapKey, MV mapValue) {
        this.gContext.checkDBStatus();
        this.gContext.incAccessNumber();
        this.writeBuffer.add(key, mapKey, mapValue);
    }

    @Override
    public void addAll(K key, Map<? extends MK, ? extends MV> mappings) {
        this.gContext.checkDBStatus();
        this.gContext.incAccessNumber();
        this.writeBuffer.add(key, mappings);
    }

    @Override
    public void remove(K key, MK mapKey) {
        this.gContext.checkDBStatus();
        this.gContext.incAccessNumber();
        this.writeBuffer.remove(key, mapKey);
    }

    @Override
    public GRegionContext getGRegionContext() {
        return this.gRegionContext;
    }

    @Override
    public PageStoreKMap<K, MK, MV> getPageStore() {
        return this.pageStore;
    }

    @Override
    public GRegionID getRegionId() {
        return this.gRegionContext.getRegionId();
    }

    @Override
    public WriteBufferKMap<K, MK, MV> getWriteBuffer() {
        return this.writeBuffer;
    }

    @Override
    public EventExecutor getExecutor() {
        return this.regionEventExecutor;
    }

    private MV internalGet(K key, MK mapKey, boolean checkReadCopy) {
        GSValue<MV> value = this.writeBuffer.get(key, mapKey);
        if (value != null) {
            if (value.getValueType() == GValueType.Delete || this.gRegionContext.filterState(value.getSeqID())) {
                return null;
            }
            return checkReadCopy ? this.copyMVIfNeeded(value.getValue()) : value.getValue();
        }
        return this.pageStore.get(key, mapKey);
    }

    protected abstract M internalGet(K var1, boolean var2);

    protected K copyKeyIfNeeded(K key) {
        return (K)(this.readCopy ? this.keySerializer.copy(key) : key);
    }

    protected MK copyMKIfNeeded(MK mk) {
        return (MK)(this.readCopy ? this.mkSerializer.copy(mk) : mk);
    }

    protected MV copyMVIfNeeded(MV mv) {
        return (MV)(this.readCopy ? this.mvSerializer.copy(mv) : mv);
    }
}

