/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.gemini.engine.hashtable;

import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import org.apache.flink.runtime.state.gemini.engine.GRegion;
import org.apache.flink.runtime.state.gemini.engine.GTable;
import org.apache.flink.runtime.state.gemini.engine.GTableDescription;
import org.apache.flink.runtime.state.gemini.engine.dbms.GContext;
import org.apache.flink.runtime.state.gemini.engine.hashtable.AbstractGRegionKMapImpl;

public abstract class AbstractGTableKeyedMapImpl<K, MK, MV>
implements GTable<K> {
    protected AbstractGRegionKMapImpl<K, MK, MV, ? extends Map<MK, MV>>[] regions;
    int startGroup;
    int numberGroups;
    int endGroup;
    int maxParallelism;
    GTableDescription description;
    GContext context;

    public AbstractGTableKeyedMapImpl(GTableDescription description, int startGroup, int numberGroups, int maxParallelism, GContext context) {
        this.startGroup = startGroup;
        this.numberGroups = numberGroups;
        this.endGroup = startGroup + numberGroups;
        this.maxParallelism = maxParallelism;
        this.description = description;
        this.context = context;
        this.regions = new AbstractGRegionKMapImpl[numberGroups];
    }

    @Override
    public GTableDescription getTableDescription() {
        return this.description;
    }

    @Override
    public Iterator<GRegion> dataRegionIterator() {
        return new Iterator<GRegion>(){
            private int currentIndex = 0;

            private void advance() {
                ++this.currentIndex;
                while (this.currentIndex < AbstractGTableKeyedMapImpl.this.regions.length && AbstractGTableKeyedMapImpl.this.regions[this.currentIndex] == null) {
                    ++this.currentIndex;
                }
            }

            @Override
            public boolean hasNext() {
                if (this.currentIndex < AbstractGTableKeyedMapImpl.this.regions.length && AbstractGTableKeyedMapImpl.this.regions[this.currentIndex] != null) {
                    return true;
                }
                this.advance();
                return this.currentIndex < AbstractGTableKeyedMapImpl.this.regions.length;
            }

            @Override
            public GRegion next() {
                return AbstractGTableKeyedMapImpl.this.regions[this.currentIndex++];
            }
        };
    }

    @Override
    public Iterator<GRegion> indexRegionIterator() {
        return Collections.emptyIterator();
    }

    @Override
    public GTableDescription getIndexDescription() {
        throw new UnsupportedOperationException("");
    }
}

