/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.gemini.engine.hashtable;

import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import org.apache.flink.api.common.typeutils.base.ByteSerializer;
import org.apache.flink.runtime.state.KeyGroupRangeAssignment;
import org.apache.flink.runtime.state.gemini.engine.GRegion;
import org.apache.flink.runtime.state.gemini.engine.GRegionIDImpl;
import org.apache.flink.runtime.state.gemini.engine.GTableDescription;
import org.apache.flink.runtime.state.gemini.engine.GeminiPKey2;
import org.apache.flink.runtime.state.gemini.engine.dbms.GContext;
import org.apache.flink.runtime.state.gemini.engine.hashtable.AbstractGRegionKMapImpl;
import org.apache.flink.runtime.state.gemini.engine.hashtable.GRegionKMapImpl;
import org.apache.flink.runtime.state.gemini.engine.hashtable.GTableWithPKey2;
import org.apache.flink.runtime.state.gemini.engine.hashtable.KMapTableDescription;
import org.apache.flink.runtime.state.gemini.engine.page.PKey2Serializer;
import org.apache.flink.runtime.state.gemini.engine.page.PageSerdeFlink2KeyImpl;

public abstract class AbstractGTableSubKeyedMapImpl<K, N, MK, MV>
implements GTableWithPKey2<K, N> {
    protected AbstractGRegionKMapImpl<GeminiPKey2<K, N>, MK, MV, ? extends Map<MK, MV>>[] regions;
    private final KMapTableDescription<K, N, Byte> indexDescription;
    GRegionKMapImpl<K, N, Byte>[] keyIndexRegions;
    int startGroup;
    int numberGroups;
    int endGroup;
    int maxParallelism;
    GTableDescription description;
    GContext context;

    public AbstractGTableSubKeyedMapImpl(GTableDescription description, int startGroup, int numberGroups, int maxParallelism, GContext context) {
        this.startGroup = startGroup;
        this.numberGroups = numberGroups;
        this.endGroup = startGroup + numberGroups;
        this.maxParallelism = maxParallelism;
        this.description = description;
        this.context = context;
        this.regions = new AbstractGRegionKMapImpl[numberGroups];
        this.keyIndexRegions = new GRegionKMapImpl[numberGroups];
        PageSerdeFlink2KeyImpl pageSerde = (PageSerdeFlink2KeyImpl)description.getPageSerde();
        PKey2Serializer pKey2Serializer = (PKey2Serializer)pageSerde.getKeySerde();
        PageSerdeFlink2KeyImpl indexPageSerde = new PageSerdeFlink2KeyImpl(pKey2Serializer.getFirstSerializer(), pKey2Serializer.getSecondSerializer(), ByteSerializer.INSTANCE, null, context.getGConfiguration().isChecksumEnable());
        this.indexDescription = new KMapTableDescription(description.getTableName(), startGroup, numberGroups, maxParallelism, indexPageSerde);
    }

    @Override
    public GTableDescription getTableDescription() {
        return this.description;
    }

    @Override
    public Iterator<N> getSecondaryKeyByFirstKey(K key) {
        int group = KeyGroupRangeAssignment.assignToKeyGroup(key, this.maxParallelism);
        int offset = group - this.startGroup;
        GRegionKMapImpl<K, N, Byte> indexRegion = this.keyIndexRegions[offset];
        if (indexRegion == null) {
            return Collections.emptyIterator();
        }
        AbstractGRegionKMapImpl<GeminiPKey2<K, N>, MK, MV, ? extends Map<MK, MV>> dataRegion = this.regions[offset];
        Object indexMap = indexRegion.get((Object)key);
        return indexMap == null ? Collections.emptyIterator() : indexMap.keySet().stream().filter(x -> dataRegion.contains(this.getGeminiPKey2(key, x))).iterator();
    }

    @Override
    public GeminiPKey2<K, N> getGeminiPKey2(K key1, N key2) {
        return new GeminiPKey2<K, N>(key1, key2);
    }

    public GRegionKMapImpl<K, N, Byte> getIndexRegion(K key) {
        int group = KeyGroupRangeAssignment.assignToKeyGroup(key, this.maxParallelism);
        int offset = group - this.startGroup;
        GRegionKMapImpl region = this.keyIndexRegions[offset];
        if (region == null) {
            this.keyIndexRegions[offset] = region = (GRegionKMapImpl)this.indexDescription.createRegion(this.context, this, new GRegionIDImpl(1, group));
        }
        return region;
    }

    @Override
    public Iterator<GRegion> dataRegionIterator() {
        return new Iterator<GRegion>(){
            private int currentIndex = 0;

            private void advance() {
                ++this.currentIndex;
                while (this.currentIndex < AbstractGTableSubKeyedMapImpl.this.regions.length && AbstractGTableSubKeyedMapImpl.this.regions[this.currentIndex] == null) {
                    ++this.currentIndex;
                }
            }

            @Override
            public boolean hasNext() {
                if (this.currentIndex < AbstractGTableSubKeyedMapImpl.this.regions.length && AbstractGTableSubKeyedMapImpl.this.regions[this.currentIndex] != null) {
                    return true;
                }
                this.advance();
                return this.currentIndex < AbstractGTableSubKeyedMapImpl.this.regions.length;
            }

            @Override
            public GRegion next() {
                return AbstractGTableSubKeyedMapImpl.this.regions[this.currentIndex++];
            }
        };
    }

    @Override
    public Iterator<GRegion> indexRegionIterator() {
        return new Iterator<GRegion>(){
            private int currentIndex = 0;

            private void advance() {
                ++this.currentIndex;
                while (this.currentIndex < AbstractGTableSubKeyedMapImpl.this.keyIndexRegions.length && AbstractGTableSubKeyedMapImpl.this.keyIndexRegions[this.currentIndex] == null) {
                    ++this.currentIndex;
                }
            }

            @Override
            public boolean hasNext() {
                if (this.currentIndex < AbstractGTableSubKeyedMapImpl.this.keyIndexRegions.length && AbstractGTableSubKeyedMapImpl.this.keyIndexRegions[this.currentIndex] != null) {
                    return true;
                }
                this.advance();
                return this.currentIndex < AbstractGTableSubKeyedMapImpl.this.keyIndexRegions.length;
            }

            @Override
            public GRegion next() {
                return AbstractGTableSubKeyedMapImpl.this.keyIndexRegions[this.currentIndex++];
            }
        };
    }

    @Override
    public GTableDescription getIndexDescription() {
        return this.indexDescription;
    }
}

