/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.gemini.engine.hashtable;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.runtime.state.gemini.engine.GRegion;
import org.apache.flink.runtime.state.gemini.engine.GRegionContext;
import org.apache.flink.runtime.state.gemini.engine.GRegionID;
import org.apache.flink.runtime.state.gemini.engine.GeminiKList;
import org.apache.flink.runtime.state.gemini.engine.dbms.GContext;
import org.apache.flink.runtime.state.gemini.engine.exceptions.GeminiRuntimeException;
import org.apache.flink.runtime.state.gemini.engine.hashtable.HashGRegion;
import org.apache.flink.runtime.state.gemini.engine.memstore.GSValue;
import org.apache.flink.runtime.state.gemini.engine.memstore.WriteBufferKList;
import org.apache.flink.runtime.state.gemini.engine.memstore.WriteBufferKListHashImpl;
import org.apache.flink.runtime.state.gemini.engine.page.GValueType;
import org.apache.flink.runtime.state.gemini.engine.page.PageIndex;
import org.apache.flink.runtime.state.gemini.engine.page.PageStoreHashKListImpl;
import org.apache.flink.runtime.state.gemini.engine.page.PageStoreKList;
import org.apache.flink.shaded.netty4.io.netty.util.concurrent.EventExecutor;
import org.apache.flink.util.Preconditions;

public class GRegionKListImpl<K, E>
implements GeminiKList<K, E>,
HashGRegion {
    private final GContext gContext;
    private final GRegionContext gRegionContext;
    private WriteBufferKList<K, E> writeBuffer;
    private PageStoreKList<K, E> pageStore;
    private final EventExecutor regionEventExecutor;
    private boolean readCopy;
    private TypeSerializer<K> keySerializer;
    private TypeSerializer<E> elementSerializer;

    public GRegionKListImpl(GRegionContext gRegionContext, PageIndex pageIndex) {
        this.gRegionContext = (GRegionContext)Preconditions.checkNotNull((Object)gRegionContext);
        this.gContext = gRegionContext.getGContext();
        this.regionEventExecutor = this.gContext.getSupervisor().getRegionExecutorGroup().next();
        gRegionContext.getPageStoreStats().setRegionExecutor(this.regionEventExecutor);
        this.gContext.getSupervisor().getCacheManager().addRegion(this);
        this.pageStore = new PageStoreHashKListImpl(this, pageIndex, this.regionEventExecutor);
        this.writeBuffer = new WriteBufferKListHashImpl((GRegion)this, this.regionEventExecutor, this.pageStore);
        this.readCopy = gRegionContext.getGContext().getGConfiguration().isReadCopy();
        this.keySerializer = gRegionContext.getPageSerdeFlink().getKeySerde();
        this.elementSerializer = gRegionContext.getPageSerdeFlink().getValueSerde();
    }

    public GRegionKListImpl(GRegionContext gRegionContext) {
        this.gRegionContext = (GRegionContext)Preconditions.checkNotNull((Object)gRegionContext);
        this.gContext = gRegionContext.getGContext();
        this.regionEventExecutor = this.gContext.getSupervisor().getRegionExecutorGroup().next();
        gRegionContext.getPageStoreStats().setRegionExecutor(this.regionEventExecutor);
        this.gContext.getSupervisor().getCacheManager().addRegion(this);
        this.pageStore = new PageStoreHashKListImpl(this, this.regionEventExecutor);
        this.writeBuffer = new WriteBufferKListHashImpl((GRegion)this, this.regionEventExecutor, this.pageStore);
        this.readCopy = gRegionContext.getGContext().getGConfiguration().isReadCopy();
        this.keySerializer = gRegionContext.getPageSerdeFlink().getKeySerde();
        this.elementSerializer = gRegionContext.getPageSerdeFlink().getValueSerde();
    }

    @Override
    public GRegionContext getGRegionContext() {
        return this.gRegionContext;
    }

    @Override
    public GRegionID getRegionId() {
        return this.gRegionContext.getRegionId();
    }

    @Override
    public WriteBufferKList<K, E> getWriteBuffer() {
        return this.writeBuffer;
    }

    @Override
    public PageStoreKList<K, E> getPageStore() {
        return this.pageStore;
    }

    @Override
    public EventExecutor getExecutor() {
        return this.regionEventExecutor;
    }

    @Override
    public void put(K key, List<E> value) {
        this.gContext.checkDBStatus();
        this.gContext.incAccessNumber();
        long seqID = this.gRegionContext.getNextSeqId();
        HashSet duplicatedElementChecker = new HashSet();
        this.writeBuffer.put(key, value.stream().map(v -> {
            long elementSeqID = seqID;
            if (!duplicatedElementChecker.add(v)) {
                elementSeqID = this.gRegionContext.getNextSeqId();
            }
            return GSValue.of(v, GValueType.PutValue, elementSeqID);
        }).collect(Collectors.toList()));
    }

    @Override
    public List<E> get(K key) {
        this.gContext.checkDBStatus();
        this.gContext.incAccessNumber();
        return this.internalGet(key, true);
    }

    @Override
    public List<E> getOrDefault(K key, List<E> defaultValue) {
        this.gContext.checkDBStatus();
        Object value = this.get((Object)key);
        return value == null ? defaultValue : value;
    }

    @Override
    public void remove(K key) {
        this.gContext.checkDBStatus();
        this.gContext.incAccessNumber();
        this.writeBuffer.removeKey(key);
    }

    @Override
    public Map<K, List<E>> getAll() {
        this.gContext.checkDBStatus();
        this.gContext.incAccessNumber();
        HashMap results = new HashMap();
        this.getAll(results);
        return results;
    }

    @Override
    public void getAll(Map<K, List<E>> results) {
        this.gContext.checkDBStatus();
        this.gContext.incAccessNumber();
        HashSet allKeysIncludeDelete = new HashSet();
        this.writeBuffer.allKeysIncludeDeleted(allKeysIncludeDelete);
        this.pageStore.allKeysIncludeDeleted(allKeysIncludeDelete);
        for (Object key : allKeysIncludeDelete) {
            Object listResult = this.get(key);
            if (listResult == null) continue;
            results.put(this.copyKeyIfNeeded(key), (List<E>)listResult);
        }
    }

    @Override
    public void removeAll() {
        this.gContext.checkDBStatus();
        this.gContext.incAccessNumber();
        long lastSeqID = this.gRegionContext.getLastSeqId();
        this.gRegionContext.setRemoveAllSeqId(lastSeqID);
        this.writeBuffer.reset();
    }

    @Override
    public Iterable<K> keys() {
        this.gContext.checkDBStatus();
        return this.getAll().keySet();
    }

    @Override
    public boolean contains(K key) {
        this.gContext.checkDBStatus();
        this.gContext.incAccessNumber();
        List<E> result = this.internalGet(key, false);
        return result != null && !result.isEmpty();
    }

    @Override
    public void add(K key, E element) {
        this.gContext.checkDBStatus();
        this.gContext.incAccessNumber();
        this.writeBuffer.add(key, element);
    }

    @Override
    public void addAll(K key, Collection<? extends E> elements) {
        this.gContext.checkDBStatus();
        this.gContext.incAccessNumber();
        this.writeBuffer.addAll(key, elements);
    }

    @Override
    public void remove(K key, E element) {
        this.gContext.checkDBStatus();
        Object result = this.get((Object)key);
        if (result != null) {
            result.remove(element);
            if (result.isEmpty()) {
                this.remove(key);
            } else {
                this.put(key, (List<E>)result);
            }
        }
    }

    @Override
    public void removeAll(K key, Collection<? extends E> elements) {
        this.gContext.checkDBStatus();
        Object result = this.get((Object)key);
        if (result != null) {
            result.removeAll(elements);
            if (result.isEmpty()) {
                this.remove(key);
            } else {
                this.put(key, (List<E>)result);
            }
        }
    }

    @Override
    public E poll(K key) {
        this.gContext.checkDBStatus();
        this.gContext.incAccessNumber();
        List<E> result = this.internalGet(key, false);
        if (result == null) {
            return null;
        }
        E ret = result.remove(0);
        this.remove(key, ret);
        return this.copyElementIfNeeded(ret);
    }

    @Override
    public E peek(K key) {
        this.gContext.checkDBStatus();
        this.gContext.incAccessNumber();
        List<E> result = this.internalGet(key, false);
        if (result == null) {
            return null;
        }
        return this.copyElementIfNeeded(result.get(0));
    }

    @VisibleForTesting
    public List<E> mergeWriteBufferAndPageStore(List<GSValue<E>> writeBuffer, List<GSValue<E>> pageStore) {
        return this.mergeWriteBufferAndPageStore(writeBuffer, pageStore, false);
    }

    @VisibleForTesting
    public List<E> mergeWriteBufferAndPageStore(List<GSValue<E>> writeBuffer, List<GSValue<E>> pageStore, boolean checkReadCopy) {
        LinkedList ret = new LinkedList();
        HashSet<GSValue<GSValue<E>>> removeDuplicated = new HashSet<GSValue<GSValue<E>>>();
        this.updateListFromGSVList(ret, pageStore, null, false);
        if (pageStore != null) {
            removeDuplicated.addAll(pageStore);
        }
        this.updateListFromGSVList(ret, writeBuffer, removeDuplicated, checkReadCopy);
        return ret.isEmpty() ? null : ret;
    }

    private List<E> internalGet(K key, boolean checkReadCopy) {
        GSValue value = this.writeBuffer.get(key);
        if (value != null) {
            if (value.getValueType() == GValueType.Delete) {
                return null;
            }
            if (value.getValueType() == GValueType.PutList) {
                return this.getListFromCompcatedList((List)value.getValue(), checkReadCopy);
            }
        }
        Object pageStoreRes = this.pageStore.get((Object)key);
        List<E> ret = this.mergeWriteBufferAndPageStore(value == null ? null : (List)value.getValue(), (List<GSValue<E>>)pageStoreRes, checkReadCopy);
        return ret == null || ret.isEmpty() ? null : ret;
    }

    private List<E> getListFromCompcatedList(@Nonnull List<GSValue<E>> origin, boolean checkReadCopy) {
        LinkedList ret = new LinkedList();
        this.updateListFromGSVList(ret, origin, null, checkReadCopy);
        return ret.isEmpty() ? null : ret;
    }

    private void updateListFromGSVList(List<E> list, List<GSValue<E>> gsvList, Set<GSValue<E>> removeDuplicated, boolean checkReadCopy) {
        if (gsvList != null) {
            block0: for (GSValue<E> e : gsvList) {
                if (this.gRegionContext.filterState(e.getSeqID()) || removeDuplicated != null && removeDuplicated.contains(e)) continue;
                if (e.getValueType() == GValueType.Delete) {
                    Iterator<E> iterator = list.iterator();
                    while (iterator.hasNext()) {
                        E e1 = iterator.next();
                        if (!e1.equals(e.getValue())) continue;
                        iterator.remove();
                        continue block0;
                    }
                    continue;
                }
                if (e.getValueType() == GValueType.PutValue) {
                    E element = e.getValue();
                    list.add(checkReadCopy ? this.copyElementIfNeeded(element) : element);
                    continue;
                }
                throw new GeminiRuntimeException("Unexpected type for list element: " + (Object)((Object)e.getValueType()));
            }
        }
    }

    private K copyKeyIfNeeded(K key) {
        return (K)(this.readCopy ? this.keySerializer.copy(key) : key);
    }

    private E copyElementIfNeeded(E element) {
        return (E)(this.readCopy ? this.elementSerializer.copy(element) : element);
    }
}

