/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.gemini.engine.hashtable;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.flink.runtime.state.gemini.engine.GRegion;
import org.apache.flink.runtime.state.gemini.engine.GRegionContext;
import org.apache.flink.runtime.state.gemini.engine.hashtable.AbstractGRegionKMapImpl;
import org.apache.flink.runtime.state.gemini.engine.memstore.GSValue;
import org.apache.flink.runtime.state.gemini.engine.memstore.GSValueMap;
import org.apache.flink.runtime.state.gemini.engine.memstore.WriteBufferKMapHashImpl;
import org.apache.flink.runtime.state.gemini.engine.page.GValueType;
import org.apache.flink.runtime.state.gemini.engine.page.PageIndex;
import org.apache.flink.runtime.state.gemini.engine.page.PageStore;
import org.apache.flink.runtime.state.gemini.engine.page.PageStoreHashKMapImpl;
import org.apache.flink.shaded.guava18.com.google.common.collect.Maps;

public class GRegionKMapImpl<K, MK, MV>
extends AbstractGRegionKMapImpl<K, MK, MV, Map<MK, MV>> {
    public GRegionKMapImpl(GRegionContext gRegionContext) {
        super(gRegionContext, null);
    }

    public GRegionKMapImpl(GRegionContext gRegionContext, PageIndex pageIndex) {
        super(gRegionContext, pageIndex);
    }

    @Override
    void init(PageIndex pageIndex) {
        this.pageStore = new PageStoreHashKMapImpl(this, pageIndex, this.regionEventExecutor);
        this.writeBuffer = new WriteBufferKMapHashImpl((GRegion)this, this.regionEventExecutor, (PageStore)this.pageStore);
    }

    @Override
    public void put(K key, Map<MK, MV> value) {
        this.gContext.checkDBStatus();
        this.gContext.incAccessNumber();
        long seqID = this.gRegionContext.getNextSeqId();
        this.writeBuffer.put(key, Maps.transformEntries(value, (mk, mv) -> GSValue.of(mv, GValueType.PutValue, seqID)));
    }

    @Override
    public Map<MK, MV> get(K key) {
        this.gContext.checkDBStatus();
        this.gContext.incAccessNumber();
        return this.internalGet(key, true);
    }

    @Nullable
    private Map<MK, MV> mergeTwoMap(@Nullable Map<MK, GSValue<MV>> newer, Map<MK, GSValue<MV>> older, boolean checkReadCopy) {
        Map<Object, Object> ret = new HashMap();
        if (older != null) {
            ret = older.entrySet().stream().filter(e -> !GValueType.Delete.equals((Object)((GSValue)e.getValue()).getValueType()) && !this.gRegionContext.filterState(((GSValue)e.getValue()).getSeqID())).collect(Collectors.toMap(Map.Entry::getKey, entry -> ((GSValue)entry.getValue()).getValue()));
        }
        if (newer != null) {
            for (Map.Entry<MK, GSValue<MV>> entry2 : newer.entrySet()) {
                if (this.gRegionContext.filterState(entry2.getValue().getSeqID())) continue;
                if (entry2.getValue().getValueType().equals((Object)GValueType.Delete)) {
                    ret.remove(entry2.getKey());
                    continue;
                }
                MK mk = entry2.getKey();
                MV mv = entry2.getValue().getValue();
                ret.put(checkReadCopy ? this.copyMKIfNeeded(mk) : mk, checkReadCopy ? this.copyMVIfNeeded(mv) : mv);
            }
        }
        return ret.isEmpty() ? null : ret;
    }

    private Map<MK, MV> genMapFromGSValueMap(GSValueMap<MK, MV> gsValueMap, boolean checkReadCopy) {
        Object valueMap = gsValueMap.getValue();
        HashMap ret = new HashMap();
        if (valueMap != null) {
            for (Map.Entry entry : valueMap.entrySet()) {
                if (GValueType.Delete.equals((Object)((GSValue)entry.getValue()).getValueType()) || this.gRegionContext.filterState(((GSValue)entry.getValue()).getSeqID())) continue;
                Object mk = entry.getKey();
                Object mv = ((GSValue)entry.getValue()).getValue();
                ret.put(checkReadCopy ? this.copyMKIfNeeded(mk) : mk, checkReadCopy ? this.copyMVIfNeeded(mv) : mv);
            }
        }
        return ret.isEmpty() ? null : ret;
    }

    @Override
    public Map<MK, MV> getOrDefault(K key, Map<MK, MV> defaultValue) {
        this.gContext.checkDBStatus();
        Object result = this.get((Object)key);
        return result == null || result.isEmpty() ? defaultValue : result;
    }

    @Override
    public Map<K, Map<MK, MV>> getAll() {
        this.gContext.checkDBStatus();
        HashMap results = new HashMap();
        this.getAll(results);
        return results;
    }

    @Override
    public void getAll(Map<K, Map<MK, MV>> results) {
        this.gContext.checkDBStatus();
        this.gContext.incAccessNumber();
        HashSet allKeysIncludeDelete = new HashSet();
        this.writeBuffer.allKeysIncludeDeleted(allKeysIncludeDelete);
        this.pageStore.allKeysIncludeDeleted(allKeysIncludeDelete);
        for (Object key : allKeysIncludeDelete) {
            Object mapResult = this.get(key);
            if (mapResult == null) continue;
            results.put(this.copyKeyIfNeeded(key), (Map<MK, MV>)mapResult);
        }
    }

    @Override
    protected Map<MK, MV> internalGet(K key, boolean checkReadCopy) {
        GSValue gsValueMap = this.writeBuffer.get((Object)key);
        if (gsValueMap != null) {
            switch (gsValueMap.getValueType()) {
                case Delete: {
                    return null;
                }
                case PutMap: {
                    return this.genMapFromGSValueMap((GSValueMap<MK, MV>)gsValueMap, checkReadCopy);
                }
            }
        }
        Map mapResult = (Map)this.pageStore.get(key);
        return this.mergeTwoMap((Map<MK, GSValue<MV>>)(gsValueMap == null ? null : ((GSValueMap)gsValueMap).getValue()), mapResult, checkReadCopy);
    }
}

