/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.gemini.engine.hashtable;

import java.util.HashMap;
import java.util.Map;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.runtime.state.gemini.engine.GRegionContext;
import org.apache.flink.runtime.state.gemini.engine.GRegionID;
import org.apache.flink.runtime.state.gemini.engine.GeminiKV;
import org.apache.flink.runtime.state.gemini.engine.dbms.GContext;
import org.apache.flink.runtime.state.gemini.engine.hashtable.HashGRegion;
import org.apache.flink.runtime.state.gemini.engine.memstore.GSValue;
import org.apache.flink.runtime.state.gemini.engine.memstore.WriteBuffer;
import org.apache.flink.runtime.state.gemini.engine.memstore.WriteBufferHashImpl;
import org.apache.flink.runtime.state.gemini.engine.page.GValueType;
import org.apache.flink.runtime.state.gemini.engine.page.PageIndex;
import org.apache.flink.runtime.state.gemini.engine.page.PageStore;
import org.apache.flink.runtime.state.gemini.engine.page.PageStoreHashKVImpl;
import org.apache.flink.shaded.netty4.io.netty.util.concurrent.EventExecutor;
import org.apache.flink.util.Preconditions;

public class GRegionKVImpl<K, V>
implements GeminiKV<K, V>,
HashGRegion {
    protected final GContext gContext;
    protected final GRegionContext gRegionContext;
    protected WriteBuffer<K, V> writeBuffer;
    protected PageStore<K, V> pageStore;
    protected final EventExecutor regionEventExecutor;
    private boolean readCopy;
    private TypeSerializer<K> keySerializer;
    private TypeSerializer<V> valueSerializer;

    public GRegionKVImpl(GRegionContext gRegionContext) {
        this.gRegionContext = (GRegionContext)Preconditions.checkNotNull((Object)gRegionContext);
        this.gContext = gRegionContext.getGContext();
        this.regionEventExecutor = this.gContext.getSupervisor().getRegionExecutorGroup().next();
        gRegionContext.getPageStoreStats().setRegionExecutor(this.regionEventExecutor);
        this.gContext.getSupervisor().getCacheManager().addRegion(this);
        this.pageStore = new PageStoreHashKVImpl(this, this.regionEventExecutor);
        this.writeBuffer = new WriteBufferHashImpl<K, V>(this, this.regionEventExecutor, this.pageStore);
        this.readCopy = gRegionContext.getGContext().getGConfiguration().isReadCopy();
        this.keySerializer = gRegionContext.getPageSerdeFlink().getKeySerde();
        this.valueSerializer = gRegionContext.getPageSerdeFlink().getValueSerde();
    }

    public GRegionKVImpl(GRegionContext gRegionContext, PageIndex pageIndex) {
        this.gRegionContext = (GRegionContext)Preconditions.checkNotNull((Object)gRegionContext);
        this.gContext = gRegionContext.getGContext();
        this.regionEventExecutor = this.gContext.getSupervisor().getRegionExecutorGroup().next();
        gRegionContext.getPageStoreStats().setRegionExecutor(this.regionEventExecutor);
        this.gContext.getSupervisor().getCacheManager().addRegion(this);
        this.pageStore = new PageStoreHashKVImpl(this, pageIndex, this.regionEventExecutor);
        this.writeBuffer = new WriteBufferHashImpl<K, V>(this, this.regionEventExecutor, this.pageStore);
        this.readCopy = gRegionContext.getGContext().getGConfiguration().isReadCopy();
        this.keySerializer = gRegionContext.getPageSerdeFlink().getKeySerde();
        this.valueSerializer = gRegionContext.getPageSerdeFlink().getValueSerde();
    }

    @Override
    public void put(K key, V value) {
        this.gContext.checkDBStatus();
        this.gContext.incAccessNumber();
        this.writeBuffer.put(key, value);
    }

    @Override
    public V get(K key) {
        this.gContext.checkDBStatus();
        this.gContext.incAccessNumber();
        GSValue<V> value = this.writeBuffer.get(key);
        if (value != null) {
            if (value.getValueType() == GValueType.Delete || this.gRegionContext.filterState(value.getSeqID())) {
                return null;
            }
            return this.copyValueIfNeeded(value.getValue());
        }
        return this.pageStore.get(key);
    }

    @Override
    public V getOrDefault(K key, V defaultValue) {
        this.gContext.checkDBStatus();
        V value = this.get(key);
        return value == null ? defaultValue : value;
    }

    @Override
    public void remove(K key) {
        this.gContext.checkDBStatus();
        this.gContext.incAccessNumber();
        this.writeBuffer.removeKey(key);
    }

    @Override
    public Map<K, V> getAll() {
        this.gContext.checkDBStatus();
        HashMap results = new HashMap();
        this.getAll(results);
        return results;
    }

    @Override
    public void getAll(Map<K, V> results) {
        this.gContext.checkDBStatus();
        this.gContext.incAccessNumber();
        HashMap container = new HashMap();
        this.writeBuffer.getAll(container);
        if (this.readCopy) {
            HashMap map = new HashMap();
            for (Map.Entry entry : container.entrySet()) {
                GSValue gsValue = (GSValue)entry.getValue();
                GSValue value = gsValue.getValueType() == GValueType.Delete ? gsValue : new GSValue(this.copyValueIfNeeded(gsValue.getValue()), gsValue.getValueType(), gsValue.getSeqID());
                map.put(this.copyKeyIfNeeded(entry.getKey()), value);
            }
            container = map;
        }
        this.pageStore.getAll(container);
        for (Map.Entry entry : container.entrySet()) {
            GSValue gsValue = (GSValue)entry.getValue();
            if (gsValue.getValueType() == GValueType.Delete || this.gRegionContext.filterState(gsValue.getSeqID())) continue;
            results.put(entry.getKey(), gsValue.getValue());
        }
    }

    @Override
    public void removeAll() {
        this.gContext.checkDBStatus();
        this.gContext.incAccessNumber();
        long lastSeqID = this.gRegionContext.getLastSeqId();
        this.gRegionContext.setRemoveAllSeqId(lastSeqID);
        this.writeBuffer.reset();
    }

    @Override
    public Iterable<K> keys() {
        this.gContext.checkDBStatus();
        return this.getAll().keySet();
    }

    @Override
    public boolean contains(K key) {
        this.gContext.checkDBStatus();
        this.gContext.incAccessNumber();
        GSValue<V> value = this.writeBuffer.get(key);
        if (value != null) {
            return value.getValueType() != GValueType.Delete && !this.gRegionContext.filterState(value.getSeqID());
        }
        return this.pageStore.get(key) != null;
    }

    @Override
    public GRegionContext getGRegionContext() {
        return this.gRegionContext;
    }

    @Override
    public PageStore<K, V> getPageStore() {
        return this.pageStore;
    }

    @Override
    public GRegionID getRegionId() {
        return this.gRegionContext.getRegionId();
    }

    @Override
    public WriteBuffer getWriteBuffer() {
        return this.writeBuffer;
    }

    @Override
    public EventExecutor getExecutor() {
        return this.regionEventExecutor;
    }

    private K copyKeyIfNeeded(K key) {
        return (K)(this.readCopy ? this.keySerializer.copy(key) : key);
    }

    private V copyValueIfNeeded(V value) {
        return (V)(this.readCopy ? this.valueSerializer.copy(value) : value);
    }
}

