/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.gemini.engine.hashtable;

import java.util.Collections;
import java.util.Iterator;
import org.apache.flink.runtime.state.KeyGroupRangeAssignment;
import org.apache.flink.runtime.state.gemini.engine.GRegion;
import org.apache.flink.runtime.state.gemini.engine.GRegionIDImpl;
import org.apache.flink.runtime.state.gemini.engine.GTable;
import org.apache.flink.runtime.state.gemini.engine.GTableDescription;
import org.apache.flink.runtime.state.gemini.engine.dbms.GContext;
import org.apache.flink.runtime.state.gemini.engine.hashtable.GRegionKListImpl;
import org.apache.flink.runtime.state.gemini.engine.page.PageSerdeFlinkListImpl;
import org.apache.flink.util.Preconditions;

public class GTableKeyedListImpl<K, E>
implements GTable<K> {
    private final GRegionKListImpl<K, E>[] regions;
    private final int startGroup;
    private final int numberGroups;
    private final int endGroup;
    private final int maxParallelism;
    private final GTableDescription description;
    private final GContext gContext;

    public GTableKeyedListImpl(GTableDescription description, int startGroup, int numberGroups, int maxParallelism, GContext context) {
        Preconditions.checkArgument((startGroup >= 0 ? 1 : 0) != 0);
        Preconditions.checkArgument((numberGroups > 0 ? 1 : 0) != 0);
        Preconditions.checkArgument((maxParallelism > 0 ? 1 : 0) != 0);
        Preconditions.checkArgument((startGroup < maxParallelism && startGroup + numberGroups <= maxParallelism ? 1 : 0) != 0);
        Preconditions.checkArgument((description != null && description.getPageSerde() instanceof PageSerdeFlinkListImpl ? 1 : 0) != 0);
        Preconditions.checkNotNull((Object)context);
        this.description = description;
        this.startGroup = startGroup;
        this.numberGroups = numberGroups;
        this.endGroup = startGroup + numberGroups;
        this.maxParallelism = maxParallelism;
        this.gContext = context;
        this.regions = new GRegionKListImpl[numberGroups];
    }

    @Override
    public GTableDescription getTableDescription() {
        return this.description;
    }

    @Override
    public GRegion getRegion(K key) {
        int group = KeyGroupRangeAssignment.assignToKeyGroup(key, this.maxParallelism);
        int offset = group - this.startGroup;
        GRegionKListImpl region = this.regions[offset];
        if (region == null) {
            this.regions[offset] = region = (GRegionKListImpl)this.description.createRegion(this.gContext, this, new GRegionIDImpl(0, group));
        }
        return region;
    }

    @Override
    public Iterator<GRegion> dataRegionIterator() {
        return new Iterator<GRegion>(){
            private int currentIndex = 0;

            private void advance() {
                ++this.currentIndex;
                while (this.currentIndex < GTableKeyedListImpl.this.regions.length && GTableKeyedListImpl.this.regions[this.currentIndex] == null) {
                    ++this.currentIndex;
                }
            }

            @Override
            public boolean hasNext() {
                if (this.currentIndex < GTableKeyedListImpl.this.regions.length && GTableKeyedListImpl.this.regions[this.currentIndex] != null) {
                    return true;
                }
                this.advance();
                return this.currentIndex < GTableKeyedListImpl.this.regions.length;
            }

            @Override
            public GRegion next() {
                return GTableKeyedListImpl.this.regions[this.currentIndex++];
            }
        };
    }

    @Override
    public Iterator<GRegion> indexRegionIterator() {
        return Collections.emptyIterator();
    }

    @Override
    public void setRegion(int idx, GRegion region) {
        Preconditions.checkArgument((idx >= this.startGroup && idx < this.endGroup ? 1 : 0) != 0);
        this.regions[idx - this.startGroup] = (GRegionKListImpl)region;
    }

    @Override
    public void setIndexRegion(int idx, GRegion indexRegion) {
        throw new UnsupportedOperationException("");
    }

    @Override
    public GTableDescription getIndexDescription() {
        throw new UnsupportedOperationException();
    }
}

