/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.gemini.engine.hashtable;

import java.util.Collections;
import java.util.Iterator;
import org.apache.flink.api.common.typeutils.base.ByteSerializer;
import org.apache.flink.runtime.state.KeyGroupRangeAssignment;
import org.apache.flink.runtime.state.gemini.engine.GRegion;
import org.apache.flink.runtime.state.gemini.engine.GRegionIDImpl;
import org.apache.flink.runtime.state.gemini.engine.GTableDescription;
import org.apache.flink.runtime.state.gemini.engine.GeminiPKey2;
import org.apache.flink.runtime.state.gemini.engine.dbms.GContext;
import org.apache.flink.runtime.state.gemini.engine.hashtable.GRegionKListImpl;
import org.apache.flink.runtime.state.gemini.engine.hashtable.GRegionKMapImpl;
import org.apache.flink.runtime.state.gemini.engine.hashtable.GTableWithPKey2;
import org.apache.flink.runtime.state.gemini.engine.hashtable.KMapTableDescription;
import org.apache.flink.runtime.state.gemini.engine.page.PKey2Serializer;
import org.apache.flink.runtime.state.gemini.engine.page.PageSerdeFlink2KeyImpl;
import org.apache.flink.runtime.state.gemini.engine.page.PageSerdeFlinkListImpl;
import org.apache.flink.util.Preconditions;

public class GTableSubKeyedListImpl<K, N, E>
implements GTableWithPKey2<K, N> {
    private final GRegionKListImpl<GeminiPKey2<K, N>, E>[] regions;
    private final KMapTableDescription<K, N, Byte> indexDescription;
    private GRegionKMapImpl<K, N, Byte>[] keyIndexRegions;
    private final int startGroup;
    private final int numberGroups;
    private final int endGroup;
    private final int maxParallelism;
    private final GTableDescription description;
    private final GContext gContext;

    public GTableSubKeyedListImpl(GTableDescription description, int startGroup, int numberGroups, int maxParallelism, GContext context) {
        Preconditions.checkArgument((startGroup >= 0 ? 1 : 0) != 0);
        Preconditions.checkArgument((numberGroups > 0 ? 1 : 0) != 0);
        Preconditions.checkArgument((maxParallelism > 0 ? 1 : 0) != 0);
        Preconditions.checkArgument((startGroup < maxParallelism && startGroup + numberGroups <= maxParallelism ? 1 : 0) != 0);
        Preconditions.checkArgument((description != null && description.getPageSerde() instanceof PageSerdeFlinkListImpl ? 1 : 0) != 0);
        Preconditions.checkNotNull((Object)context);
        this.startGroup = startGroup;
        this.numberGroups = numberGroups;
        this.endGroup = startGroup + numberGroups;
        this.maxParallelism = maxParallelism;
        this.description = description;
        this.gContext = context;
        this.regions = new GRegionKListImpl[numberGroups];
        this.keyIndexRegions = new GRegionKMapImpl[numberGroups];
        PageSerdeFlinkListImpl pageSerde = (PageSerdeFlinkListImpl)description.getPageSerde();
        PKey2Serializer pKey2Serializer = (PKey2Serializer)pageSerde.getKeySerde();
        PageSerdeFlink2KeyImpl indexPageSerde = new PageSerdeFlink2KeyImpl(pKey2Serializer.getFirstSerializer(), pKey2Serializer.getSecondSerializer(), ByteSerializer.INSTANCE, null, context.getGConfiguration().isChecksumEnable());
        this.indexDescription = new KMapTableDescription(description.getTableName(), startGroup, numberGroups, maxParallelism, indexPageSerde);
    }

    @Override
    public GTableDescription getTableDescription() {
        return this.description;
    }

    @Override
    public Iterator<N> getSecondaryKeyByFirstKey(K key) {
        int group = KeyGroupRangeAssignment.assignToKeyGroup(key, this.maxParallelism);
        int offset = group - this.startGroup;
        GRegionKMapImpl<K, N, Byte> region = this.keyIndexRegions[offset];
        if (region == null) {
            return Collections.emptyIterator();
        }
        GRegionKListImpl<GeminiPKey2<K, N>, E> dataRegion = this.regions[offset];
        Object index = region.get((Object)key);
        if (index == null) {
            return Collections.emptyIterator();
        }
        return region.get((Object)key).keySet().stream().filter(x -> dataRegion.contains(this.getGeminiPKey2(key, x))).iterator();
    }

    @Override
    public GeminiPKey2<K, N> getGeminiPKey2(K key1, N key2) {
        return new GeminiPKey2<K, N>(key1, key2);
    }

    public GRegionKListImpl<GeminiPKey2<K, N>, E> getRegion(GeminiPKey2<K, N> key) {
        int group = KeyGroupRangeAssignment.assignToKeyGroup(key.getFirstKey(), this.maxParallelism);
        int offset = group - this.startGroup;
        GRegionKListImpl region = this.regions[offset];
        if (region == null) {
            this.regions[offset] = region = (GRegionKListImpl)this.description.createRegion(this.gContext, this, new GRegionIDImpl(0, group));
        }
        return region;
    }

    public GRegionKMapImpl<K, N, Byte> getIndexRegion(GeminiPKey2<K, N> key) {
        int group = KeyGroupRangeAssignment.assignToKeyGroup(key.getFirstKey(), this.maxParallelism);
        int offset = group - this.startGroup;
        GRegionKMapImpl region = this.keyIndexRegions[offset];
        if (region == null) {
            this.keyIndexRegions[offset] = region = (GRegionKMapImpl)this.indexDescription.createRegion(this.gContext, this, new GRegionIDImpl(1, group));
        }
        return region;
    }

    @Override
    public Iterator<GRegion> dataRegionIterator() {
        return new Iterator<GRegion>(){
            private int currentIndex = 0;

            private void advance() {
                ++this.currentIndex;
                while (this.currentIndex < GTableSubKeyedListImpl.this.regions.length && GTableSubKeyedListImpl.this.regions[this.currentIndex] == null) {
                    ++this.currentIndex;
                }
            }

            @Override
            public boolean hasNext() {
                if (this.currentIndex < GTableSubKeyedListImpl.this.regions.length && GTableSubKeyedListImpl.this.regions[this.currentIndex] != null) {
                    return true;
                }
                this.advance();
                return this.currentIndex < GTableSubKeyedListImpl.this.regions.length;
            }

            @Override
            public GRegion next() {
                return GTableSubKeyedListImpl.this.regions[this.currentIndex++];
            }
        };
    }

    @Override
    public Iterator<GRegion> indexRegionIterator() {
        return new Iterator<GRegion>(){
            private int currentIndex = 0;

            private void advance() {
                ++this.currentIndex;
                while (this.currentIndex < GTableSubKeyedListImpl.this.keyIndexRegions.length && GTableSubKeyedListImpl.this.keyIndexRegions[this.currentIndex] == null) {
                    ++this.currentIndex;
                }
            }

            @Override
            public boolean hasNext() {
                if (this.currentIndex < GTableSubKeyedListImpl.this.keyIndexRegions.length && GTableSubKeyedListImpl.this.keyIndexRegions[this.currentIndex] != null) {
                    return true;
                }
                this.advance();
                return this.currentIndex < GTableSubKeyedListImpl.this.keyIndexRegions.length;
            }

            @Override
            public GRegion next() {
                return GTableSubKeyedListImpl.this.keyIndexRegions[this.currentIndex++];
            }
        };
    }

    @Override
    public void setRegion(int idx, GRegion region) {
        Preconditions.checkArgument((idx >= this.startGroup && idx < this.endGroup ? 1 : 0) != 0);
        this.regions[idx - this.startGroup] = (GRegionKListImpl)region;
    }

    @Override
    public void setIndexRegion(int idx, GRegion indexRegion) {
        Preconditions.checkArgument((idx >= this.startGroup && idx < this.endGroup ? 1 : 0) != 0);
        this.keyIndexRegions[idx - this.startGroup] = (GRegionKMapImpl)indexRegion;
    }

    @Override
    public GTableDescription getIndexDescription() {
        return this.indexDescription;
    }
}

