/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.gemini.engine.hashtable;

import org.apache.flink.runtime.state.gemini.engine.GRegion;
import org.apache.flink.runtime.state.gemini.engine.GRegionContext;
import org.apache.flink.runtime.state.gemini.engine.GRegionID;
import org.apache.flink.runtime.state.gemini.engine.GTable;
import org.apache.flink.runtime.state.gemini.engine.GTableDescription;
import org.apache.flink.runtime.state.gemini.engine.dbms.GContext;
import org.apache.flink.runtime.state.gemini.engine.hashtable.GRegionKListImpl;
import org.apache.flink.runtime.state.gemini.engine.hashtable.GTableKeyedListImpl;
import org.apache.flink.runtime.state.gemini.engine.page.PageIndex;
import org.apache.flink.runtime.state.gemini.engine.page.PageSerdeFlink;
import org.apache.flink.util.Preconditions;

public class KListTableDescription<K, E>
implements GTableDescription {
    private final String tableName;
    private final int startGroup;
    private final int numberGroups;
    private final int maxParallelism;
    private final PageSerdeFlink<K, E> pageSerdeFlink;

    public KListTableDescription(String tableName, int startGroup, int numberGroups, int maxParallelism, PageSerdeFlink<K, E> pageSerdeFlink) {
        this.tableName = (String)Preconditions.checkNotNull((Object)tableName);
        this.startGroup = startGroup;
        this.numberGroups = numberGroups;
        this.maxParallelism = maxParallelism;
        this.pageSerdeFlink = pageSerdeFlink;
    }

    @Override
    public String getTableName() {
        return this.tableName;
    }

    @Override
    public GTable createTable(GContext gContext) {
        return new GTableKeyedListImpl(this, this.startGroup, this.numberGroups, this.maxParallelism, gContext);
    }

    @Override
    public GRegion createRegion(GContext gContext, GTable gTable, GRegionID regionId) {
        GRegionContext regionContext = new GRegionContext(gContext, this.tableName, regionId, this.pageSerdeFlink);
        return new GRegionKListImpl(regionContext);
    }

    @Override
    public GRegion createRegion(GContext gContext, GTable gTable, GRegionID regionId, PageIndex pageIndex) {
        GRegionContext regionContext = new GRegionContext(gContext, this.tableName, regionId, this.pageSerdeFlink);
        return new GRegionKListImpl(regionContext, pageIndex);
    }

    @Override
    public GRegion createRegion(GRegionContext regionContext, PageIndex pageIndex) {
        return new GRegionKListImpl(regionContext, pageIndex);
    }

    @Override
    public PageSerdeFlink getPageSerde() {
        return this.pageSerdeFlink;
    }
}

