/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.gemini.engine.memstore;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedDeque;
import org.apache.flink.runtime.state.gemini.engine.GRegion;
import org.apache.flink.runtime.state.gemini.engine.handler.PageHandler;
import org.apache.flink.runtime.state.gemini.engine.handler.PageKMapHandlerImpl;
import org.apache.flink.runtime.state.gemini.engine.memstore.AbstractWriteBuffer;
import org.apache.flink.runtime.state.gemini.engine.memstore.GSValue;
import org.apache.flink.runtime.state.gemini.engine.memstore.GSValueMap;
import org.apache.flink.runtime.state.gemini.engine.memstore.Segment;
import org.apache.flink.runtime.state.gemini.engine.memstore.SegmentKMap;
import org.apache.flink.runtime.state.gemini.engine.memstore.SegmentKMapImpl;
import org.apache.flink.runtime.state.gemini.engine.memstore.WriteBufferKMap;
import org.apache.flink.runtime.state.gemini.engine.page.GValueType;
import org.apache.flink.runtime.state.gemini.engine.page.PageStore;
import org.apache.flink.runtime.state.gemini.engine.page.PageStoreKMap;
import org.apache.flink.shaded.netty4.io.netty.util.concurrent.EventExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractWriteBufferKMapHashImpl<K, MK, MV>
extends AbstractWriteBuffer<K, Map<MK, GSValue<MV>>>
implements WriteBufferKMap<K, MK, MV> {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractWriteBufferKMapHashImpl.class);
    protected SegmentKMap<K, MK, MV> active;
    protected ConcurrentLinkedDeque<SegmentKMap<K, MK, MV>> snapshotQueue = new ConcurrentLinkedDeque();

    public AbstractWriteBufferKMapHashImpl(GRegion gRegion, EventExecutor eventExecutor, PageStore pageStore) {
        super(gRegion, eventExecutor, pageStore);
    }

    abstract void initActive();

    abstract Map<MK, GSValue<MV>> createPOJOMap();

    @Override
    PageHandler createPageHandler(Segment segment, boolean onlyEstimatedSize) {
        return new PageKMapHandlerImpl(this.gRegionContext, (PageStoreKMap)this.gRegion.getPageStore(), (SegmentKMapImpl)segment, onlyEstimatedSize);
    }

    @Override
    public Segment getActiveSegment() {
        return this.active;
    }

    @Override
    Segment pollFlushingSegment() {
        return this.snapshotQueue.poll();
    }

    @Override
    public void add(K key, MK mkey, MV mvalue) {
        this.active.add(key, mkey, mvalue);
        this.checkResource();
    }

    @Override
    public void add(K key, Map<MK, MV> map) {
        this.active.add(key, map);
        this.checkResource();
    }

    @Override
    public void remove(K key, MK mapKey) {
        this.active.remove(key, mapKey);
        this.checkResource();
    }

    @Override
    public GValueType contains(K key, MK mapKey) {
        GSValue mapValue = this.active.get((Object)key);
        if (mapValue != null) {
            ++((GSValueMap)mapValue).requestCount;
            if (((GSValueMap)mapValue).valueType == GValueType.Delete) {
                this.gRegionContext.getGContext().getSupervisor().getCacheManager().getCacheStats().addWriteBufferHitCount();
                return GValueType.Delete;
            }
            GSValue value = (GSValue)((GSValueMap)mapValue).getValue().get(mapKey);
            if (value != null) {
                this.gRegionContext.getGContext().getSupervisor().getCacheManager().getCacheStats().addWriteBufferHitCount();
                return value.valueType;
            }
        }
        Iterator<SegmentKMap<K, MK, MV>> iterator = this.snapshotQueue.descendingIterator();
        while (iterator.hasNext()) {
            SegmentKMap<K, MK, MV> inactive = iterator.next();
            mapValue = inactive.get((Object)key);
            if (mapValue == null) continue;
            ++((GSValueMap)mapValue).requestCount;
            if (((GSValueMap)mapValue).valueType == GValueType.Delete) {
                this.gRegionContext.getGContext().getSupervisor().getCacheManager().getCacheStats().addWriteBufferHitCount();
                return GValueType.Delete;
            }
            GSValue value = (GSValue)((GSValueMap)mapValue).getValue().get(mapKey);
            if (value == null) continue;
            this.gRegionContext.getGContext().getSupervisor().getCacheManager().getCacheStats().addWriteBufferHitCount();
            return value.valueType;
        }
        this.gRegionContext.getGContext().getSupervisor().getCacheManager().getCacheStats().addWriteBufferMissCount();
        return null;
    }

    @Override
    public void put(K key, Map<MK, GSValue<MV>> value) {
        this.active.put(key, value);
        this.checkResource();
    }

    @Override
    public GSValue<MV> get(K key, MK mapKey) {
        GSValue<MV> gsValue = this.active.get(key, mapKey);
        if (gsValue != null) {
            ++gsValue.requestCount;
            this.gRegionContext.getGContext().getSupervisor().getCacheManager().getCacheStats().addWriteBufferHitCount();
            return gsValue;
        }
        Iterator<SegmentKMap<K, MK, MV>> iterator = this.snapshotQueue.descendingIterator();
        while (iterator.hasNext()) {
            SegmentKMap<K, MK, MV> inactive = iterator.next();
            gsValue = inactive.get(key, mapKey);
            if (gsValue == null) continue;
            ++gsValue.requestCount;
            this.gRegionContext.getGContext().getSupervisor().getCacheManager().getCacheStats().addWriteBufferHitCount();
            return gsValue;
        }
        this.gRegionContext.getGContext().getSupervisor().getCacheManager().getCacheStats().addWriteBufferMissCount();
        return null;
    }

    @Override
    public GSValueMap<MK, MV> get(K key) {
        ArrayList<GSValueMap<MK, MV>> reverseOrderList = new ArrayList<GSValueMap<MK, MV>>();
        GSValue mapValue = this.active.get((Object)key);
        if (mapValue != null) {
            ++((GSValueMap)mapValue).requestCount;
            this.gRegionContext.getGContext().getSupervisor().getCacheManager().getCacheStats().addWriteBufferHitCount();
            if (((GSValueMap)mapValue).valueType == GValueType.PutMap) {
                return mapValue;
            }
            if (((GSValueMap)mapValue).valueType == GValueType.Delete) {
                return mapValue;
            }
            reverseOrderList.add((GSValueMap<MK, MV>)mapValue);
        }
        Iterator<SegmentKMap<K, MK, MV>> iterator = this.snapshotQueue.descendingIterator();
        while (iterator.hasNext()) {
            SegmentKMap<K, MK, MV> inactive = iterator.next();
            mapValue = inactive.get((Object)key);
            if (mapValue == null) continue;
            ++((GSValueMap)mapValue).requestCount;
            this.gRegionContext.getGContext().getSupervisor().getCacheManager().getCacheStats().addWriteBufferHitCount();
            reverseOrderList.add((GSValueMap<MK, MV>)mapValue);
            if (((GSValueMap)mapValue).valueType != GValueType.PutMap && ((GSValueMap)mapValue).valueType != GValueType.Delete) continue;
            break;
        }
        return reverseOrderList.size() == 0 ? null : this.mergeGSValueMap(reverseOrderList);
    }

    @Override
    public void getAll(Map<K, GSValue<Map<MK, GSValue<MV>>>> container) {
    }

    @Override
    public void allKeysIncludeDeleted(Set<K> container) {
        Segment activeMap = this.getActiveSegment();
        container.addAll(activeMap.getData().keySet());
        Iterator<SegmentKMap<K, MK, MV>> iterator = this.snapshotQueue.descendingIterator();
        while (iterator.hasNext()) {
            SegmentKMap<K, MK, MV> inactive = iterator.next();
            container.addAll(inactive.getData().keySet());
        }
    }

    @Override
    public void removeKey(K key) {
        this.active.removeKey(key);
        this.checkResource();
    }

    @Override
    public void reset() {
        this.initActive();
    }

    @Override
    public GValueType contains(K key) {
        GSValue mapValue = this.active.get((Object)key);
        if (mapValue != null) {
            ++((GSValueMap)mapValue).requestCount;
            this.gRegionContext.getGContext().getSupervisor().getCacheManager().getCacheStats().addWriteBufferHitCount();
            return ((GSValueMap)mapValue).valueType;
        }
        Iterator<SegmentKMap<K, MK, MV>> iterator = this.snapshotQueue.descendingIterator();
        while (iterator.hasNext()) {
            SegmentKMap<K, MK, MV> inactive = iterator.next();
            mapValue = inactive.get((Object)key);
            if (mapValue == null) continue;
            ++((GSValueMap)mapValue).requestCount;
            this.gRegionContext.getGContext().getSupervisor().getCacheManager().getCacheStats().addWriteBufferHitCount();
            return ((GSValueMap)mapValue).valueType;
        }
        this.gRegionContext.getGContext().getSupervisor().getCacheManager().getCacheStats().addWriteBufferMissCount();
        return null;
    }

    private GSValueMap<MK, MV> mergeGSValueMap(List<GSValueMap<MK, MV>> reverseOrderList) {
        if (reverseOrderList == null || reverseOrderList.size() == 0) {
            return null;
        }
        Map<MK, GSValue<MV>> newMap = this.createPOJOMap();
        GValueType finalGValueType = GValueType.AddMap;
        long seqID = reverseOrderList.get(0).getSeqID();
        for (int index = reverseOrderList.size() - 1; index >= 0; --index) {
            GSValueMap<MK, MV> currentMap = reverseOrderList.get(index);
            if (currentMap.getValueType() == GValueType.Delete) {
                newMap.clear();
                finalGValueType = GValueType.PutMap;
                continue;
            }
            if (currentMap.getValueType() == GValueType.PutMap) {
                newMap.clear();
                newMap.putAll((Map)currentMap.value);
                finalGValueType = GValueType.PutMap;
                continue;
            }
            newMap.putAll((Map)currentMap.value);
        }
        return new GSValueMap<MK, MV>(newMap, finalGValueType, seqID);
    }
}

