/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.gemini.engine.memstore;

import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.flink.runtime.state.gemini.engine.page.GValueType;
import org.apache.flink.shaded.guava18.com.google.common.base.MoreObjects;

public class GSValue<V> {
    protected final GValueType valueType;
    protected V value;
    protected int requestCount;
    protected long seqID;

    public GSValue(V value, GValueType gValueType, long seqID) {
        this.valueType = gValueType;
        this.value = value;
        this.seqID = seqID;
    }

    public GValueType getValueType() {
        return this.valueType;
    }

    @Nullable
    public V getValue() {
        return this.value;
    }

    public V setValue(V newValue) {
        V oldValue = this.value;
        this.value = newValue;
        return oldValue;
    }

    public int getRequestCount() {
        return this.requestCount;
    }

    public long getSeqID() {
        return this.seqID;
    }

    public boolean equals(Object o) {
        boolean result;
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GSValue gsValue = (GSValue)o;
        boolean bl = result = this.valueType == gsValue.valueType;
        if (!result) {
            return false;
        }
        boolean bl2 = result = this.seqID == gsValue.seqID;
        if (!result) {
            return false;
        }
        return this.valueType == GValueType.Delete || this.value == gsValue.value || this.value.equals(gsValue.value);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.valueType, this.value, this.seqID});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("valueType", (Object)this.valueType).add("value", this.value).add("requestCount", this.requestCount).add("seqID", this.seqID).toString();
    }

    public static <V> GSValue<V> of(V value, GValueType valueType, long seqID) {
        return new GSValue<V>(value, valueType, seqID);
    }

    public static <V> GSValue<V> of(V value, GValueType valueType, long seqID, int requestCount) {
        GSValue<V> gsValue = new GSValue<V>(value, valueType, seqID);
        gsValue.requestCount = requestCount;
        return gsValue;
    }
}

