/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.gemini.engine.memstore;

import java.util.HashMap;
import java.util.Map;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.runtime.state.gemini.engine.GRegionContext;
import org.apache.flink.runtime.state.gemini.engine.memstore.GSValue;
import org.apache.flink.runtime.state.gemini.engine.memstore.Segment;
import org.apache.flink.runtime.state.gemini.engine.page.GValueType;

public class SegmentImpl<K, V>
implements Segment<K, V> {
    private final long segmentID;
    private final GRegionContext gRegionContext;
    private final Map<K, GSValue<V>> dataMap;
    private final long version;
    private int recordCount = 0;
    private boolean writeCopy;
    private TypeSerializer<K> keySerializer;
    private TypeSerializer<V> valueSerializer;

    public SegmentImpl(long segmentID, GRegionContext gRegionContext) {
        this.segmentID = segmentID;
        this.gRegionContext = gRegionContext;
        this.dataMap = new HashMap<K, GSValue<V>>();
        this.version = gRegionContext.getGContext().getCurVersion();
        this.writeCopy = gRegionContext.getGContext().getGConfiguration().isWriteCopy();
        this.keySerializer = gRegionContext.getPageSerdeFlink().getKeySerde();
        this.valueSerializer = gRegionContext.getPageSerdeFlink().getValueSerde();
    }

    public SegmentImpl(long segmentID, GRegionContext gRegionContext, Map<K, GSValue<V>> dataMap) {
        this.segmentID = segmentID;
        this.gRegionContext = gRegionContext;
        this.dataMap = dataMap;
        this.version = gRegionContext.getGContext().getCurVersion();
        this.writeCopy = gRegionContext.getGContext().getGConfiguration().isWriteCopy();
        this.keySerializer = gRegionContext.getPageSerdeFlink().getKeySerde();
        this.valueSerializer = gRegionContext.getPageSerdeFlink().getValueSerde();
    }

    @Override
    public void put(K key, V value) {
        if (this.dataMap.put(this.copyKeyIfNeeded(key), GSValue.of(this.copyValueIfNeeded(value), GValueType.PutValue, this.gRegionContext.getNextSeqId())) == null) {
            ++this.recordCount;
            this.gRegionContext.getWriteBufferStats().addTotalRecordCount(1);
        }
    }

    @Override
    public GSValue<V> get(K key) {
        return this.dataMap.get(key);
    }

    @Override
    public void removeKey(K key) {
        this.dataMap.put(this.copyKeyIfNeeded(key), GSValue.of(null, GValueType.Delete, this.gRegionContext.getNextSeqId()));
    }

    @Override
    public long getSegmentID() {
        return this.segmentID;
    }

    @Override
    public int getRecordCount() {
        return this.recordCount;
    }

    @Override
    public long getVersion() {
        return this.version;
    }

    public Map<K, GSValue<V>> getDataMap() {
        return this.dataMap;
    }

    @Override
    public SegmentImpl<K, V> copySegment() {
        return new SegmentImpl<K, V>(-1L, this.gRegionContext, new HashMap<K, GSValue<V>>(this.dataMap));
    }

    @Override
    public Map getData() {
        return this.dataMap;
    }

    private K copyKeyIfNeeded(K key) {
        return (K)(this.writeCopy ? this.keySerializer.copy(key) : key);
    }

    private V copyValueIfNeeded(V value) {
        return (V)(this.writeCopy ? this.valueSerializer.copy(value) : value);
    }
}

