/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.gemini.engine.memstore;

import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.runtime.state.gemini.engine.GRegionContext;
import org.apache.flink.runtime.state.gemini.engine.memstore.GSValue;
import org.apache.flink.runtime.state.gemini.engine.memstore.GSValueMap;
import org.apache.flink.runtime.state.gemini.engine.memstore.Segment;
import org.apache.flink.runtime.state.gemini.engine.memstore.SegmentKMap;
import org.apache.flink.runtime.state.gemini.engine.page.GValueType;
import org.apache.flink.runtime.state.gemini.engine.page.PageSerdeFlink2Key;
import org.apache.flink.runtime.state.gemini.engine.page.bmap.GComparator;

public class SegmentKMapImpl<K, MK, MV>
implements SegmentKMap<K, MK, MV> {
    private final long segmentID;
    private final GRegionContext gRegionContext;
    private final long version;
    private final Map<K, GSValueMap<MK, MV>> dataMap;
    private int recordCount = 0;
    private final GComparator<MK> comparator;
    private boolean writeCopy;
    private TypeSerializer<K> keySerializer;
    private TypeSerializer<MK> mkSerializer;
    private TypeSerializer<MV> mvSerializer;

    public SegmentKMapImpl(long segmentID, GRegionContext gRegionContext, GComparator<MK> comparator) {
        this.segmentID = segmentID;
        this.gRegionContext = gRegionContext;
        this.dataMap = new HashMap<K, GSValueMap<MK, MV>>();
        this.version = gRegionContext.getGContext().getCurVersion();
        this.comparator = comparator;
        this.writeCopy = gRegionContext.getGContext().getGConfiguration().isWriteCopy();
        this.keySerializer = gRegionContext.getPageSerdeFlink().getKeySerde();
        this.mkSerializer = ((PageSerdeFlink2Key)gRegionContext.getPageSerdeFlink()).getKey2Serde();
        this.mvSerializer = gRegionContext.getPageSerdeFlink().getValueSerde();
    }

    public SegmentKMapImpl(long segmentID, GRegionContext gRegionContext, Map<K, GSValueMap<MK, MV>> dataMap, GComparator<MK> comparator) {
        this.segmentID = segmentID;
        this.gRegionContext = gRegionContext;
        this.dataMap = dataMap;
        this.version = gRegionContext.getGContext().getCurVersion();
        this.comparator = comparator;
        this.writeCopy = gRegionContext.getGContext().getGConfiguration().isWriteCopy();
        this.keySerializer = gRegionContext.getPageSerdeFlink().getKeySerde();
        this.mkSerializer = ((PageSerdeFlink2Key)gRegionContext.getPageSerdeFlink()).getKey2Serde();
        this.mvSerializer = gRegionContext.getPageSerdeFlink().getValueSerde();
    }

    @Override
    public void add(K key, MK mkey, MV mvalue) {
        GSValueMap<MK, MV> gmap = this.getOrCreateMap(key);
        long seqID = this.gRegionContext.getNextSeqId();
        this.internalAdd(mkey, mvalue, gmap, seqID);
        this.updateMapSeqID(gmap, seqID);
    }

    private void internalAdd(MK mkey, MV mvalue, GSValueMap<MK, MV> gmap, long seqID) {
        if (gmap.getValue().put(this.copyMKIfNeeded(mkey), GSValue.of(this.copyMVIfNeeded(mvalue), GValueType.PutValue, seqID)) == null) {
            ++this.recordCount;
            this.gRegionContext.getWriteBufferStats().addTotalRecordCount(1);
        }
    }

    @Override
    public void add(K key, Map<MK, MV> map) {
        GSValueMap<MK, MV> gmap = this.getOrCreateMap(key);
        long seqID = this.gRegionContext.getNextSeqId();
        map.forEach((mk, mv) -> this.internalAdd(this.copyMKIfNeeded(mk), this.copyMVIfNeeded(mv), gmap, seqID));
        this.updateMapSeqID(gmap, seqID);
    }

    @Override
    public void remove(K key, MK mapKey) {
        GSValueMap gmap = this.dataMap.computeIfAbsent(this.copyKeyIfNeeded(key), nothing -> this.createAddMap());
        long seqID = this.gRegionContext.getNextSeqId();
        if (gmap.getValue() == null) {
            return;
        }
        gmap.getValue().put(this.copyMKIfNeeded(mapKey), GSValue.of(null, GValueType.Delete, seqID));
        this.updateMapSeqID(gmap, seqID);
    }

    @Override
    public void put(K key, Map<MK, GSValue<MV>> value) {
        GSValueMap<MK, MV> gmap = this.createPutMap();
        long seqID = 0L;
        for (Map.Entry<MK, GSValue<MV>> entry : value.entrySet()) {
            GSValue<MV> gsValue = entry.getValue();
            seqID = Math.max(seqID, gsValue.getSeqID());
            gsValue.setValue(this.copyMVIfNeeded(gsValue.getValue()));
            gmap.getValue().put(this.copyMKIfNeeded(entry.getKey()), gsValue);
        }
        GSValueMap<MK, MV> old = this.dataMap.put(this.copyKeyIfNeeded(key), gmap);
        this.updateMapSeqID(gmap, seqID);
        int oldSize = old == null || old.getValue() == null ? 0 : old.getValue().size();
        int delta = value.size() - oldSize;
        this.recordCount += delta;
        this.gRegionContext.getWriteBufferStats().addTotalRecordCount(delta);
    }

    @Override
    public GSValueMap<MK, MV> get(K key) {
        return this.dataMap.get(key);
    }

    @Override
    public GSValue<MV> get(K key, MK mapKey) {
        GSValue gsValueMap = this.get((Object)key);
        if (gsValueMap == null) {
            return null;
        }
        if (gsValueMap.getValueType() == GValueType.Delete) {
            return new GSValue<Object>(null, GValueType.Delete, gsValueMap.getSeqID());
        }
        GSValue result = (GSValue)((GSValueMap)gsValueMap).getValue().get(mapKey);
        if (result == null && gsValueMap.getValueType() == GValueType.PutMap) {
            return new GSValue<Object>(null, GValueType.Delete, gsValueMap.getSeqID());
        }
        return result;
    }

    @Override
    public void removeKey(K key) {
        GSValueMap<MK, MV> gmap = this.createDeleteMap();
        long seqID = this.gRegionContext.getNextSeqId();
        this.updateMapSeqID(gmap, seqID);
        this.dataMap.put(this.copyKeyIfNeeded(key), gmap);
    }

    @Override
    public long getSegmentID() {
        return this.segmentID;
    }

    @Override
    public int getRecordCount() {
        return this.recordCount;
    }

    @Override
    public long getVersion() {
        return this.version;
    }

    @Override
    public Segment<K, Map<MK, GSValue<MV>>> copySegment() {
        HashMap<K, GSValueMap<MK, MV>> copyMap = new HashMap<K, GSValueMap<MK, MV>>();
        for (Map.Entry<K, GSValueMap<MK, MV>> entry : this.dataMap.entrySet()) {
            copyMap.put(entry.getKey(), entry.getValue().copyGSValueMap());
        }
        return new SegmentKMapImpl(-1L, this.gRegionContext, copyMap, this.comparator);
    }

    @Override
    public Map getData() {
        return this.dataMap;
    }

    private GSValueMap<MK, MV> getOrCreateMap(K key) {
        GSValueMap<MK, MV> gmap = this.dataMap.get(key);
        if (gmap == null || gmap.getSeqID() < this.gRegionContext.getRemoveAllSeqId()) {
            gmap = this.createAddMap();
            this.dataMap.put(this.copyKeyIfNeeded(key), gmap);
        } else if (gmap.getValueType() == GValueType.Delete) {
            gmap = this.createPutMap();
            this.dataMap.put(this.copyKeyIfNeeded(key), gmap);
        }
        return gmap;
    }

    private GSValueMap<MK, MV> createAddMap() {
        return GSValueMap.of(this.comparator != null ? new TreeMap(this.comparator.getJDKCompactor()) : new HashMap(), GValueType.AddMap, 0L);
    }

    private GSValueMap<MK, MV> createPutMap() {
        return GSValueMap.of(this.comparator != null ? new TreeMap(this.comparator.getJDKCompactor()) : new HashMap(), GValueType.PutMap, 0L);
    }

    private GSValueMap<MK, MV> createDeleteMap() {
        return GSValueMap.of(null, GValueType.Delete, 0L);
    }

    private void updateMapSeqID(GSValueMap<MK, MV> gsValueMap, long seqID) {
        gsValueMap.setSeqID(seqID);
    }

    public Map<K, GSValueMap<MK, MV>> getDataMap() {
        return this.dataMap;
    }

    private K copyKeyIfNeeded(K key) {
        return (K)(this.writeCopy ? this.keySerializer.copy(key) : key);
    }

    private MK copyMKIfNeeded(MK mk) {
        return (MK)(this.writeCopy ? this.mkSerializer.copy(mk) : mk);
    }

    private MV copyMVIfNeeded(MV mv) {
        return (MV)(this.writeCopy ? this.mvSerializer.copy(mv) : mv);
    }
}

