/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.gemini.engine.memstore;

import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedDeque;
import org.apache.flink.runtime.state.gemini.engine.GRegion;
import org.apache.flink.runtime.state.gemini.engine.handler.PageHandler;
import org.apache.flink.runtime.state.gemini.engine.handler.PageKValueHandlerImpl;
import org.apache.flink.runtime.state.gemini.engine.hashtable.GRegionKVImpl;
import org.apache.flink.runtime.state.gemini.engine.memstore.AbstractWriteBuffer;
import org.apache.flink.runtime.state.gemini.engine.memstore.GSValue;
import org.apache.flink.runtime.state.gemini.engine.memstore.Segment;
import org.apache.flink.runtime.state.gemini.engine.memstore.SegmentImpl;
import org.apache.flink.runtime.state.gemini.engine.page.GValueType;
import org.apache.flink.runtime.state.gemini.engine.page.PageStore;
import org.apache.flink.shaded.netty4.io.netty.util.concurrent.EventExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WriteBufferHashImpl<K, V>
extends AbstractWriteBuffer<K, V> {
    private static final Logger LOG = LoggerFactory.getLogger(WriteBufferHashImpl.class);
    private SegmentImpl<K, V> active;
    private ConcurrentLinkedDeque<Segment<K, V>> snapshotQueue = new ConcurrentLinkedDeque();

    public WriteBufferHashImpl(GRegion gRegion, EventExecutor eventExecutor, PageStore<K, V> pageStore) {
        super(gRegion, eventExecutor, pageStore);
        this.active = new SegmentImpl(this.segmentID++, this.gRegionContext);
    }

    @Override
    public Segment getActiveSegment() {
        return this.active;
    }

    @Override
    Segment addFlushingSegment() {
        SegmentImpl<K, V> result = this.active;
        this.snapshotQueue.add(this.active);
        this.gRegionContext.getWriteBufferStats().addFlushingSegmentCount(1);
        this.active = new SegmentImpl(this.segmentID++, this.gRegionContext);
        return result;
    }

    @Override
    Segment pollFlushingSegment() {
        return this.snapshotQueue.poll();
    }

    @Override
    PageHandler createPageHandler(Segment segment, boolean onlyEstimatedSize) {
        return new PageKValueHandlerImpl((GRegionKVImpl)this.gRegion, (SegmentImpl)segment, onlyEstimatedSize);
    }

    @Override
    public void put(K key, V value) {
        this.active.put(key, value);
        this.checkResource();
    }

    @Override
    public GSValue<V> get(K key) {
        GSValue<V> gsValue = this.active.get(key);
        if (gsValue != null) {
            ++gsValue.requestCount;
            this.gRegionContext.getGContext().getSupervisor().getCacheManager().getCacheStats().addWriteBufferHitCount();
            return gsValue;
        }
        Iterator<Segment<K, V>> iterator = this.snapshotQueue.descendingIterator();
        while (iterator.hasNext()) {
            Segment<K, V> inactive = iterator.next();
            gsValue = inactive.get(key);
            if (gsValue == null) continue;
            ++gsValue.requestCount;
            this.gRegionContext.getGContext().getSupervisor().getCacheManager().getCacheStats().addWriteBufferHitCount();
            return gsValue;
        }
        this.gRegionContext.getGContext().getSupervisor().getCacheManager().getCacheStats().addWriteBufferMissCount();
        return null;
    }

    @Override
    public void getAll(Map<K, GSValue<V>> container) {
        Map<K, GSValue<V>> activeMap = this.active.getDataMap();
        for (Map.Entry<K, GSValue<V>> entry : activeMap.entrySet()) {
            container.putIfAbsent(entry.getKey(), entry.getValue());
        }
        Iterator<Segment<K, V>> iterator = this.snapshotQueue.descendingIterator();
        while (iterator.hasNext()) {
            Segment<K, V> inactive = iterator.next();
            Map inactiveMap = ((SegmentImpl)inactive).getDataMap();
            for (Map.Entry entry : inactiveMap.entrySet()) {
                container.putIfAbsent(entry.getKey(), entry.getValue());
            }
        }
    }

    @Override
    public void allKeysIncludeDeleted(Set<K> container) {
        Segment activeMap = this.getActiveSegment();
        container.addAll(activeMap.getData().keySet());
        Iterator<Segment<K, V>> iterator = this.snapshotQueue.descendingIterator();
        while (iterator.hasNext()) {
            Segment<K, V> inactive = iterator.next();
            container.addAll(inactive.getData().keySet());
        }
    }

    @Override
    public void removeKey(K key) {
        this.active.removeKey(key);
        this.checkResource();
    }

    @Override
    public void reset() {
        this.active = new SegmentImpl(this.segmentID++, this.gRegionContext);
    }

    @Override
    public GValueType contains(K key) {
        GSValue<V> getResult = this.get(key);
        if (getResult != null) {
            return getResult.valueType;
        }
        return null;
    }
}

