/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.gemini.engine.memstore;

import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.flink.metrics.MetricGroup;
import org.apache.flink.runtime.state.gemini.engine.GRegion;
import org.apache.flink.runtime.state.gemini.engine.GTable;
import org.apache.flink.runtime.state.gemini.engine.dbms.GContext;
import org.apache.flink.runtime.state.gemini.engine.memstore.WriteBuffer;
import org.apache.flink.runtime.state.gemini.engine.memstore.WriteBufferManager;
import org.apache.flink.runtime.state.gemini.engine.snapshot.SnapshotCompletableFuture;
import org.apache.flink.runtime.state.gemini.engine.snapshot.SnapshotManager;
import org.apache.flink.runtime.state.gemini.engine.snapshot.SnapshotOperation;
import org.apache.flink.shaded.guava18.com.google.common.base.MoreObjects;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WriteBufferManagerImpl
implements WriteBufferManager {
    private static final Logger LOG = LoggerFactory.getLogger(WriteBufferManagerImpl.class);
    private static final long MIN_WRITE_BUFFER_TOTAL_SIZE = 0x4000000L;
    private final GContext gContext;
    private final AtomicLong totalWriteBufferFlushBlock = new AtomicLong(0L);
    private final AtomicLong totalWriteBufferRecordCount = new AtomicLong(0L);
    private final AtomicLong totalWriteBufferFlushingRecordCount = new AtomicLong(0L);
    private final AtomicLong totalWriteBufferFlushingSegmentCount = new AtomicLong(0L);
    private final long maxTotalWriteBufferSize;
    private final AtomicInteger tableCount = new AtomicInteger(0);
    private final int regionCount;
    private final int totalFlushingLimitPerTable;

    public WriteBufferManagerImpl(GContext gContext) {
        this.gContext = (GContext)Preconditions.checkNotNull((Object)gContext);
        long totalHeapMemSize = gContext.getMemoryInfo().getTotalHeapSize();
        long configTotalWriteBufferSize = (long)((float)totalHeapMemSize * gContext.getGConfiguration().getTotalWriteBufferRate());
        if (configTotalWriteBufferSize < 0x4000000L) {
            configTotalWriteBufferSize = 0x4000000L;
        }
        this.maxTotalWriteBufferSize = configTotalWriteBufferSize;
        this.regionCount = gContext.getEndRegionId() - gContext.getStartRegionId() + 1;
        this.totalFlushingLimitPerTable = (int)((float)(gContext.getGConfiguration().getNumFlushingSegment() * this.regionCount) * gContext.getGConfiguration().getTotalNumFlushingSegmentRatio());
        LOG.info("WriteBufferManager maxTotalWriteBufferSize={}, regionCount={}, totalFlushingLimitPerTable={}", new Object[]{this.maxTotalWriteBufferSize, this.regionCount, this.totalFlushingLimitPerTable});
    }

    @Override
    public void increaseWriteBufferFlushBlock() {
        this.totalWriteBufferFlushBlock.addAndGet(1L);
    }

    @Override
    public void addTotalRecordCount(int totalRecordCount) {
        this.totalWriteBufferRecordCount.addAndGet(totalRecordCount);
    }

    @Override
    public long getTotalRecordCount() {
        return this.totalWriteBufferRecordCount.get();
    }

    @Override
    public void addTotalFlushingRecordCount(int totalRecordCount) {
        this.totalWriteBufferFlushingRecordCount.addAndGet(totalRecordCount);
    }

    @Override
    public void addTotalFlushingSegmentCount(int flushingSegmentCount) {
        this.totalWriteBufferFlushingSegmentCount.addAndGet(flushingSegmentCount);
    }

    @Override
    public long getTotalMemSize() {
        return this.maxTotalWriteBufferSize;
    }

    @Override
    public boolean isBestChoiceWriteBufferFlushing(WriteBuffer writeBuffer) {
        return true;
    }

    @Override
    public boolean canFlushWriteBuffer(WriteBuffer writeBuffer) {
        int tableNum = this.tableCount.get();
        return (long)(this.totalFlushingLimitPerTable * (tableNum == 0 ? 1 : tableNum)) > this.totalWriteBufferFlushingSegmentCount.get();
    }

    @Override
    public void addTableNum(String tableName) {
        this.tableCount.addAndGet(1);
        LOG.info("WriteBufferManager add tableName={}, now totalTables={}", (Object)tableName, (Object)this.tableCount.get());
    }

    @Override
    public void doSnapshot(SnapshotOperation snapshotOperation) {
        SnapshotManager.PendingSnapshot pendingSnapshot = snapshotOperation.getPendingSnapshot();
        long checkpointId = pendingSnapshot.getCheckpointId();
        SnapshotCompletableFuture snapshotCompletableFuture = pendingSnapshot.getResultFuture();
        snapshotCompletableFuture.incRunningTask();
        LOG.info("WriteBufferManagerImpl start to snapshot for {}.", (Object)checkpointId);
        Map<String, GTable> tables = this.gContext.getGeminiDB().getGeminiTableMap();
        for (GTable table : tables.values()) {
            Iterator<GRegion> dataRegionIterator = table.dataRegionIterator();
            while (dataRegionIterator.hasNext()) {
                GRegion region = dataRegionIterator.next();
                region.getWriteBuffer().doSnapshot(snapshotOperation);
            }
            Iterator<GRegion> indexRegionIterator = table.indexRegionIterator();
            while (indexRegionIterator.hasNext()) {
                GRegion region = indexRegionIterator.next();
                region.getWriteBuffer().doSnapshot(snapshotOperation);
            }
        }
        snapshotCompletableFuture.decRunningTask();
        LOG.info("WriteBufferManagerImpl end snapshot for {}", (Object)checkpointId);
    }

    @Override
    public void registerMetrics(MetricGroup metricGroup) {
        metricGroup.gauge("totalWriteBufferFlushBlockCount", () -> this.totalWriteBufferFlushBlock.get());
        metricGroup.gauge("totalWriteBufferRecordCount", () -> this.totalWriteBufferRecordCount.get());
        metricGroup.gauge("totalWriteBufferFlushingRecordCount", () -> this.totalWriteBufferFlushingRecordCount.get());
        metricGroup.gauge("totalWriteBufferFlushingSegmentCount", () -> this.totalWriteBufferFlushingSegmentCount.get());
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("totalWriteBufferFlushBlock", (Object)this.totalWriteBufferFlushBlock).add("totalWriteBufferRecordCount", (Object)this.totalWriteBufferRecordCount).add("totalWriteBufferFlushingRecordCount", (Object)this.totalWriteBufferFlushingRecordCount).add("totalWriteBufferFlushingSegmentCount", (Object)this.totalWriteBufferFlushingSegmentCount).add("maxTotalWriteBufferSize", this.maxTotalWriteBufferSize).add("tableCount", (Object)this.tableCount).add("regionCount", this.regionCount).toString();
    }
}

