/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.gemini.engine.metrics;

import org.apache.flink.metrics.MetricGroup;
import org.apache.flink.runtime.state.gemini.engine.filecompaction.FileCompactionStat;
import org.apache.flink.runtime.state.gemini.engine.metrics.MetricsBase;

public class FileCompactionMetrics
extends MetricsBase {
    private static final String AMPLIFICATION_RATIO = "ratio";
    private static final String COMPACTION_COUNT = "count";
    private static final String TRANSFER_RATIO = "size";
    private static final String COMPACTION_DURATION = "duration";

    public FileCompactionMetrics(MetricGroup metricGroup, int sampleCountInterval, int histogramWindowSize) {
        super(metricGroup, sampleCountInterval, histogramWindowSize);
    }

    public void register(FileCompactionStat fileCompactionStatStat) {
        this.getGaugeMetric(AMPLIFICATION_RATIO, fileCompactionStatStat::getAmplificationRatio);
        this.getGaugeMetric(COMPACTION_COUNT, () -> fileCompactionStatStat.addAndGetNumberCompaction(0));
        this.getGaugeMetric(TRANSFER_RATIO, fileCompactionStatStat::getTransferSize);
        this.getGaugeMetric(COMPACTION_DURATION, fileCompactionStatStat::getCompactionDuration);
    }
}

