/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.gemini.engine.metrics;

import org.apache.flink.metrics.MetricGroup;
import org.apache.flink.runtime.state.gemini.engine.metrics.MetricsBase;
import org.apache.flink.runtime.state.gemini.engine.snapshot.SnapshotCompactionStat;

public class SnapshotCompactionMetrics
extends MetricsBase {
    private static final String AMPLIFICATION_RATIO = "ratio";
    private static final String COMPACTION_COUNT = "count";
    private static final String COMPACTION_SIZE = "size";
    private static final String COMPACTION_DURATION = "duration";

    public SnapshotCompactionMetrics(MetricGroup metricGroup, int sampleCountInterval, int histogramWindowSize) {
        super(metricGroup, sampleCountInterval, histogramWindowSize);
    }

    public void register(SnapshotCompactionStat snapshotCompactionStat) {
        this.getGaugeMetric(AMPLIFICATION_RATIO, snapshotCompactionStat::getActualAmplificationRatio);
        this.getGaugeMetric(COMPACTION_COUNT, () -> snapshotCompactionStat.addAndGetNumberCompaction(0));
        this.getGaugeMetric(COMPACTION_SIZE, snapshotCompactionStat::getCompactionSize);
        this.getGaugeMetric(COMPACTION_DURATION, snapshotCompactionStat::getCompactionDuration);
    }
}

