/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.gemini.engine.page;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.zip.CRC32;
import org.apache.flink.runtime.state.gemini.engine.exceptions.GeminiRuntimeException;
import org.apache.flink.runtime.state.gemini.engine.fs.FileWriter;
import org.apache.flink.runtime.state.gemini.engine.page.DataPageUtil;
import org.apache.flink.runtime.state.gemini.engine.page.PageAddress;
import org.apache.flink.runtime.state.gemini.engine.page.bmap.ByteBufferUtils;
import org.apache.flink.runtime.state.gemini.engine.page.compress.CompressorCodec;
import org.apache.flink.runtime.state.gemini.engine.page.compress.GCompressAlgorithm;
import org.apache.flink.runtime.state.gemini.engine.page.compress.GCompressHeaderHelper;
import org.apache.flink.runtime.state.gemini.engine.rm.GByteBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDataPageUtil
implements DataPageUtil {
    protected static final Logger LOG = LoggerFactory.getLogger(DataPageUtil.class);
    protected final boolean enableChecksum;

    public AbstractDataPageUtil(boolean enableChecksum) {
        this.enableChecksum = enableChecksum;
    }

    @Override
    public int write(FileWriter writer, GByteBuffer gByteBuffer, PageAddress pageAddress, GCompressAlgorithm gCompressAlgorithm, int compressThreshold, boolean checksumEnable) throws IOException {
        int diskLength;
        boolean needCompress;
        byte[] data = this.getBytes(gByteBuffer, pageAddress, checksumEnable);
        boolean bl = needCompress = gCompressAlgorithm.enableCompress() && pageAddress.getDataLen() > compressThreshold;
        if (needCompress) {
            CompressorCodec compressorCodec = gCompressAlgorithm.getCompressorCodec();
            int compressLength = data.length - 64;
            byte[] compressedData = compressorCodec.getCompressedBytePool(compressLength);
            int compressedDataLength = compressorCodec.compress(data, 64, compressLength, compressedData, 0);
            diskLength = 80 + compressedDataLength;
            ByteBuffer compressHeader = ByteBuffer.allocate(16);
            GCompressHeaderHelper.writeCompressedDataPageType(compressHeader);
            GCompressHeaderHelper.writeCompressVersion(compressHeader, (short)1);
            GCompressHeaderHelper.writeMagicNumber(compressHeader, (short)4726);
            GCompressHeaderHelper.writeAlgorithmCode(compressHeader, gCompressAlgorithm.getCode());
            GCompressHeaderHelper.writeDiskLength(compressHeader, compressedDataLength);
            writer.write(compressHeader.array(), 0, 16);
            writer.write(data, 0, 64);
            writer.write(compressedData, 0, compressedDataLength);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Compress page mem {}/disk {} ratio {}", new Object[]{pageAddress.getDataLen(), diskLength, (double)pageAddress.getDataLen() * 1.0 / (double)diskLength});
            }
        } else {
            diskLength = data.length;
            writer.write(data, 0, data.length);
        }
        return diskLength;
    }

    public byte[] getBytes(GByteBuffer gByteBuffer, PageAddress page, boolean checkSum) {
        byte[] bytes;
        if (gByteBuffer.getByteBuffer().hasArray()) {
            bytes = gByteBuffer.getByteBuffer().array();
        } else {
            bytes = new byte[gByteBuffer.capacity()];
            ByteBufferUtils.copyFromBufferToArray(gByteBuffer.getByteBuffer(), bytes, 0, 0, gByteBuffer.capacity());
        }
        if (checkSum) {
            CRC32 crc32 = new CRC32();
            crc32.update(bytes);
            int crc = (int)crc32.getValue();
            if (crc != page.getChecksum()) {
                throw new GeminiRuntimeException("checkSum changed! originCheckSum=" + page.getChecksum() + " ,now=" + crc);
            }
        }
        return bytes;
    }
}

