/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.gemini.engine.page;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.runtime.state.gemini.engine.GConfiguration;
import org.apache.flink.runtime.state.gemini.engine.GRegion;
import org.apache.flink.runtime.state.gemini.engine.GRegionContext;
import org.apache.flink.runtime.state.gemini.engine.GRegionID;
import org.apache.flink.runtime.state.gemini.engine.dbms.GContext;
import org.apache.flink.runtime.state.gemini.engine.exceptions.GeminiRuntimeException;
import org.apache.flink.runtime.state.gemini.engine.exceptions.GeminiShutDownException;
import org.apache.flink.runtime.state.gemini.engine.filter.StateFilter;
import org.apache.flink.runtime.state.gemini.engine.handler.GeminiEventExecutorTask;
import org.apache.flink.runtime.state.gemini.engine.handler.PageCompactHandler;
import org.apache.flink.runtime.state.gemini.engine.memstore.GSValue;
import org.apache.flink.runtime.state.gemini.engine.page.DataPage;
import org.apache.flink.runtime.state.gemini.engine.page.DataPageHashSubPageImpl;
import org.apache.flink.runtime.state.gemini.engine.page.GValueType;
import org.apache.flink.runtime.state.gemini.engine.page.LogicalPageChain;
import org.apache.flink.runtime.state.gemini.engine.page.PageAddress;
import org.apache.flink.runtime.state.gemini.engine.page.PageAddressCompositeImpl;
import org.apache.flink.runtime.state.gemini.engine.page.PageAddressSingleImpl;
import org.apache.flink.runtime.state.gemini.engine.page.PageContext;
import org.apache.flink.runtime.state.gemini.engine.page.PageIndex;
import org.apache.flink.runtime.state.gemini.engine.page.PageIndexContext;
import org.apache.flink.runtime.state.gemini.engine.page.PageIndexContextHashImpl;
import org.apache.flink.runtime.state.gemini.engine.page.PageIndexHashImpl;
import org.apache.flink.runtime.state.gemini.engine.page.PageSerdeFlink;
import org.apache.flink.runtime.state.gemini.engine.page.PageSerdeFlink2Key;
import org.apache.flink.runtime.state.gemini.engine.page.PageStatus;
import org.apache.flink.runtime.state.gemini.engine.page.PageStore;
import org.apache.flink.runtime.state.gemini.engine.page.bmap.BinaryKey;
import org.apache.flink.runtime.state.gemini.engine.page.bmap.BinaryValue;
import org.apache.flink.runtime.state.gemini.engine.page.bmap.GBinaryHashMap;
import org.apache.flink.runtime.state.gemini.engine.page.bmap.GBufferAddressMapping;
import org.apache.flink.runtime.state.gemini.engine.rm.GByteBuffer;
import org.apache.flink.runtime.state.gemini.engine.vm.CacheManager;
import org.apache.flink.runtime.state.gemini.engine.vm.DataPageLRU;
import org.apache.flink.shaded.guava18.com.google.common.collect.Lists;
import org.apache.flink.shaded.netty4.io.netty.util.concurrent.EventExecutor;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractHashPageStore<K, V>
implements PageStore<K, V> {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractHashPageStore.class);
    private static final int MIN_NEW_PAGE_SIZE_TO_PERSIST = 2048;
    protected final PageIndexHashImpl<K> pageIndex;
    protected final GRegionContext gRegionContext;
    protected final EventExecutor eventExecutor;
    protected final CacheManager cacheManager;
    protected final GContext gContext;
    protected final DataPage.DataPageType dataPageType;
    private final int splitPageSizeThreshold;
    private final int maxChainLenThreshold;
    protected final GRegion gRegion;
    private final PageCompactHandler pageCompactHandler;
    private final int inMemoryCompactionThreshold;
    private final int maxRunningMajorCompaction;
    private final int maxRunningMinorCompaction;
    protected final PageSerdeFlink<K, V> pageSerdeFlink;
    private final EventExecutor lruIntoMainEventExecutor;
    private long lastLruIntoMainCacheTimeMs = -1L;
    private final int lruIntoMainCacheSleepMs;
    private final boolean enableAddIntoMainWhenSplitting;
    private final boolean enableLoadPageFromLRUIntoMainCache;
    protected final long curRegionMemHighMark;

    public AbstractHashPageStore(DataPage.DataPageType dataPageType, GRegion gRegion, EventExecutor eventExecutor) {
        this(dataPageType, gRegion, null, eventExecutor);
    }

    public AbstractHashPageStore(DataPage.DataPageType dataPageType, GRegion gRegion, @Nullable PageIndex pageIndex, EventExecutor eventExecutor) {
        this.dataPageType = dataPageType;
        this.gRegion = gRegion;
        this.gRegionContext = gRegion.getGRegionContext();
        this.eventExecutor = eventExecutor;
        GConfiguration configuration = this.gRegionContext.getGContext().getGConfiguration();
        this.pageIndex = pageIndex != null ? (PageIndexHashImpl)pageIndex : new PageIndexHashImpl(configuration, this, this.gRegionContext.getPageStoreStats());
        this.gContext = this.gRegionContext.getGContext();
        this.cacheManager = this.gContext.getSupervisor().getCacheManager();
        this.gRegionContext.getPageStoreStats().setPageSizeRate(configuration.getPageSizeRateBetweenPOJOAndHeap());
        this.splitPageSizeThreshold = configuration.getSplitPageSizeThreshold();
        this.maxChainLenThreshold = configuration.getMaxCompactionThreshold();
        this.inMemoryCompactionThreshold = configuration.getInMemoryCompactionThreshold();
        this.maxRunningMajorCompaction = configuration.getMaxRunningMajorCompaction();
        this.maxRunningMinorCompaction = configuration.getMaxRunningMinorCompaction();
        this.pageSerdeFlink = this.gRegionContext.getPageSerdeFlink();
        this.lruIntoMainCacheSleepMs = configuration.getLruIntoMainCacheSleepMs();
        this.enableAddIntoMainWhenSplitting = configuration.isEnableAddIntoMainWhenSplitting();
        this.enableLoadPageFromLRUIntoMainCache = configuration.isEnableLoadPageFromLRUIntoMain();
        this.curRegionMemHighMark = this.cacheManager.getMemHighMark() / (long)configuration.getRegionThreadNum();
        this.lruIntoMainEventExecutor = this.gContext.getSupervisor().getLruIntoMainCacheExecutorGroup().next();
        this.pageCompactHandler = new PageCompactHandler(){

            @Override
            public void doAsyncMajorCompaction(PageIndexContext pageIndexContext, LogicalPageChain logicalPageChain, int curPageIndex, int curChainIndex, long version) {
                AbstractHashPageStore.this.doMajorCompaction(pageIndexContext, logicalPageChain, curPageIndex, curChainIndex, version);
            }

            @Override
            public void doAsyncMinorCompaction(PageIndexContext pageIndexContext, LogicalPageChain logicalPageChain, int curChainIndex, long version, boolean force) {
                AbstractHashPageStore.this.doMinorCompaction(pageIndexContext, logicalPageChain, curChainIndex, version, force);
            }

            @Override
            public void doSyncReplace(LogicalPageChain logicalPageChain, int curPageIndex, int oldCompactedPageSize, int oldCompactedSubPageNum, int oldCompactedSubPageSize, long oldRequestCount, int inclusiveCompactionStartChainIndex, int inclusiveCompactionEndChainIndex, DataPage compactedDataPage, List<PageAddress> invalidPageAddressList, int relatedIndex) {
                AbstractHashPageStore.this.doSyncReplaceLogicalPage(logicalPageChain, curPageIndex, oldCompactedPageSize, oldCompactedSubPageNum, oldCompactedSubPageSize, oldRequestCount, inclusiveCompactionStartChainIndex, inclusiveCompactionEndChainIndex, compactedDataPage, invalidPageAddressList, false, relatedIndex);
            }

            @Override
            public void doAsyncMinorCompactionByRead(PageIndexContext pageIndexContext, LogicalPageChain logicalPageChain, int curPageIndex, int curChainIndex, Map<Integer, DataPage> fetchedDataPageMap) {
                AbstractHashPageStore.this.doMinorCompactionByRead(pageIndexContext, logicalPageChain, curPageIndex, curChainIndex, fetchedDataPageMap);
            }
        };
    }

    @Override
    public EventExecutor getExecutor() {
        return this.eventExecutor;
    }

    @Override
    public boolean contains(K key) {
        return this.get(key) != null;
    }

    @Override
    public PageIndex<K> getPageIndex() {
        return this.pageIndex;
    }

    public DataPage.DataPageType getDataPageType() {
        return this.dataPageType;
    }

    @Override
    public void addPage(PageIndexContext pageIndexContext, List<Tuple2<K, GSValue<V>>> dataSet, long version) {
        LogicalPageChain currentLogicalPageChain = pageIndexContext.getLogicalPageChain();
        if (currentLogicalPageChain == PageIndexHashImpl.NO_PAGE) {
            String msg = "BUG! addOrMergePage receive NO_PAGE request.";
            LOG.error(msg);
            throw new GeminiRuntimeException(msg);
        }
        if (dataSet == null || dataSet.isEmpty()) {
            if (!pageIndexContext.isNeedSplit()) {
                this.compactPage(pageIndexContext, version);
            }
        } else {
            this.doWriteDataToPage(pageIndexContext, dataSet, version);
        }
    }

    @Override
    public void compactPage(final PageIndexContext pageIndexContext, final long version) {
        try {
            LogicalPageChain logicalPageChain = pageIndexContext.getLogicalPageChain();
            final int curPageIndex = pageIndexContext.getPageIndexID();
            if (logicalPageChain != this.pageIndex.getLogicPage(curPageIndex)) {
                return;
            }
            if (logicalPageChain.getCurrentPageChainIndex() <= 0) {
                return;
            }
            if (!logicalPageChain.getPageStatus().canCompaction()) {
                return;
            }
            final int curChainIndex = logicalPageChain.getCurrentPageChainIndex();
            final LogicalPageChain compactionLogicalPageChain = logicalPageChain;
            if (logicalPageChain.getCurrentPageChainIndex() >= this.maxChainLenThreshold) {
                if (logicalPageChain.getPageStatus().canCompaction()) {
                    this.gRegionContext.getPageStoreStats().addRunningMajorCompactedPages(1);
                    if (this.cacheManager.getCacheStats().getRunningMajorCompactedPages() > this.maxRunningMajorCompaction) {
                        this.gRegionContext.getPageStoreStats().addRunningMajorCompactedPages(-1);
                        this.tryLaunchMinorCompaction(pageIndexContext, version, logicalPageChain, curChainIndex, compactionLogicalPageChain, true);
                        return;
                    }
                    if (!logicalPageChain.compareAndSetStatus(PageStatus.Normal, PageStatus.Compacting)) {
                        this.gRegionContext.getPageStoreStats().addRunningMajorCompactedPages(-1);
                        return;
                    }
                    EventExecutor eventExecutor = this.gContext.getSupervisor().getCompactionExecutorGroup().next();
                    final Set<DataPage> dataPages = compactionLogicalPageChain.getAllDataPageReferenced();
                    if (this.gContext.isDBNormal() && !eventExecutor.isShuttingDown()) {
                        eventExecutor.execute((Runnable)new GeminiEventExecutorTask(){

                            @Override
                            public void cancel() {
                                dataPages.forEach(dataPage -> dataPage.release());
                            }

                            @Override
                            public void run() {
                                try {
                                    AbstractHashPageStore.this.pageCompactHandler.doAsyncMajorCompaction(pageIndexContext, compactionLogicalPageChain, curPageIndex, curChainIndex, version);
                                }
                                catch (GeminiShutDownException ignore) {
                                    LOG.debug("GeminiDB has shutdown!", (Throwable)ignore);
                                }
                                catch (Exception e) {
                                    LOG.error("async major compaction failed", (Throwable)e);
                                }
                                finally {
                                    dataPages.forEach(dataPage -> dataPage.release());
                                }
                            }
                        });
                    } else {
                        dataPages.forEach(dataPage -> dataPage.release());
                    }
                }
            } else if (logicalPageChain.getCurrentPageChainIndex() > this.inMemoryCompactionThreshold) {
                this.tryLaunchMinorCompaction(pageIndexContext, version, logicalPageChain, curChainIndex, compactionLogicalPageChain, false);
            }
        }
        catch (Exception e) {
            LOG.error("Bug " + e.getMessage(), (Throwable)e);
            throw new GeminiRuntimeException(e);
        }
    }

    private void tryLaunchMinorCompaction(PageIndexContext pageIndexContext, long version, LogicalPageChain logicalPageChain, int curChainIndex, LogicalPageChain compactionLogicalPageChain, boolean force) {
        if (logicalPageChain.getPageStatus().canCompaction()) {
            PageAddress pageAddress;
            DataPage dataPage;
            this.gRegionContext.getPageStoreStats().addRunningMinorCompactedPages(1);
            if (!force && this.cacheManager.getCacheStats().getRunningMinorCompactedPages() > this.maxRunningMinorCompaction) {
                this.gRegionContext.getPageStoreStats().addRunningMinorCompactedPages(-1);
                return;
            }
            int memCandidatePage = 0;
            long lastSumCompactedThreshold = -1L;
            for (int startCompactionIndex = curChainIndex; startCompactionIndex >= 0 && (dataPage = (pageAddress = logicalPageChain.getPageAddress(startCompactionIndex)).getDataPageNoReference()) != null; --startCompactionIndex) {
                if (!force) {
                    long compactedCount = dataPage.getCompactionCount();
                    if (lastSumCompactedThreshold == -1L) {
                        lastSumCompactedThreshold = compactedCount;
                    } else {
                        if (lastSumCompactedThreshold < compactedCount) break;
                        lastSumCompactedThreshold += compactedCount;
                    }
                }
                ++memCandidatePage;
            }
            if (memCandidatePage <= this.inMemoryCompactionThreshold) {
                this.gRegionContext.getPageStoreStats().addRunningMinorCompactedPages(-1);
                return;
            }
            if (!logicalPageChain.compareAndSetStatus(PageStatus.Normal, PageStatus.Compacting)) {
                this.gRegionContext.getPageStoreStats().addRunningMinorCompactedPages(-1);
                return;
            }
            EventExecutor eventExecutor = this.gContext.getSupervisor().getCompactionExecutorGroup().next();
            eventExecutor.execute(() -> {
                try {
                    this.pageCompactHandler.doAsyncMinorCompaction(pageIndexContext, compactionLogicalPageChain, curChainIndex, version, force);
                }
                catch (GeminiShutDownException ignore) {
                    LOG.debug("GeminiDB has shutdown!", (Throwable)ignore);
                }
                catch (Exception e) {
                    LOG.error("async minor compaction failed", (Throwable)e);
                }
            });
        }
    }

    private LogicalPageChain doSyncReplaceLogicalPage(LogicalPageChain logicalPageChain, int curPageIndex, int oldCompactedPageSize, int oldCompactedSubPageNum, int oldCompactedSubPageSize, long oldRequestCount, int inclusiveCompactionStartChainIndex, int inclusiveCompactionEndChainIndex, DataPage compactedDataPage, List<PageAddress> invalidPageAddressList, boolean isSplit, int relatedIndex) {
        int i;
        if (isSplit) {
            if (this.pageIndex.getLogicPage(curPageIndex) != PageIndexHashImpl.WAIT_SPLITTING_PAGE) {
                if (compactedDataPage != null) {
                    compactedDataPage.release();
                }
                return null;
            }
        } else if (logicalPageChain != this.pageIndex.getLogicPage(curPageIndex)) {
            if (compactedDataPage != null) {
                compactedDataPage.release();
            }
            return null;
        }
        int compactedPageSize = 0;
        int compactedMemSize = 0;
        int compactedSubPageNum = 0;
        int compactedSubPageSize = 0;
        PageAddress compactedPageAddress = null;
        LogicalPageChain compactedLogicalPageChain = this.pageIndex.createLogicalPageChain();
        for (i = 0; i < inclusiveCompactionStartChainIndex; ++i) {
            compactedLogicalPageChain.insertPage(logicalPageChain.getPageAddress(i));
        }
        if (compactedDataPage != null) {
            compactedPageAddress = compactedLogicalPageChain.createPage(compactedDataPage);
            compactedPageSize = compactedPageAddress.getDataLen();
            compactedMemSize = compactedPageAddress.getMemorySize();
            compactedSubPageNum = compactedPageAddress.getSubPageNum();
            compactedSubPageSize = compactedPageAddress.getSubPageDataLen();
            compactedPageAddress.addRequestCountForNewPage(this.cacheManager.getCurrentTickTime(), (int)(oldRequestCount & Integer.MAX_VALUE));
        }
        for (i = inclusiveCompactionEndChainIndex + 1; i <= logicalPageChain.getCurrentPageChainIndex(); ++i) {
            compactedLogicalPageChain.insertPage(logicalPageChain.getPageAddress(i));
        }
        compactedLogicalPageChain.addPageSize(logicalPageChain.getPageSize() - oldCompactedPageSize + compactedPageSize);
        this.pageIndex.updateLogicPage(curPageIndex, compactedLogicalPageChain);
        int oldMemPageSize = this.syncGetMemPageSizeFromInvalidPageAddressList(invalidPageAddressList);
        List<PageAddress> findRealNeedDiscardPage = this.findNeededDiscardPage(invalidPageAddressList, compactedPageAddress);
        this.gContext.getSupervisor().discardPage(this.gRegionContext, findRealNeedDiscardPage);
        this.removeInvalidPage(this.gRegion, invalidPageAddressList);
        if (compactedPageAddress != null) {
            this.gContext.getSupervisor().getPersistencyStrategy().persistPage(this.gRegion, compactedPageAddress, compactedMemSize);
            compactedMemSize = compactedPageAddress.getMemorySize();
            if (compactedMemSize > 0) {
                this.cacheManager.getEvictPolicy().addPage(this.gRegion, compactedPageAddress);
            }
        }
        this.cacheManager.getEvictPolicy().tryPrepareFlush(this.gRegion, compactedMemSize - oldMemPageSize);
        this.gRegionContext.getPageStoreStats().addPageUsedMemory(this.gRegion, compactedMemSize - oldMemPageSize);
        this.gRegionContext.getPageStoreStats().addLogicPageSize(compactedLogicalPageChain.getPageSize() - logicalPageChain.getPageSize());
        this.gRegionContext.getPageStoreStats().addLogicPageChainLen(compactedLogicalPageChain.getCurrentPageChainIndex() - logicalPageChain.getCurrentPageChainIndex());
        this.gRegionContext.getPageStoreStats().addLogicSubPageCount(compactedSubPageNum - oldCompactedSubPageNum);
        this.gRegionContext.getPageStoreStats().addLogicSubPageSize(compactedSubPageSize - oldCompactedSubPageSize);
        this.gRegionContext.getPageStoreStats().addLogicPageChainCapacity(compactedLogicalPageChain.getPageChainCapacity() - logicalPageChain.getPageChainCapacity());
        return compactedLogicalPageChain;
    }

    private void removeInvalidPage(GRegion gRegion, List<PageAddress> invalidPageAddressList) {
        for (PageAddress pageAddress : invalidPageAddressList) {
            this.cacheManager.getEvictPolicy().removeInvalidPage(gRegion, pageAddress);
        }
    }

    private int syncGetMemPageSizeFromInvalidPageAddressList(List<PageAddress> invalidPageAddressList) {
        return invalidPageAddressList.stream().map(PageAddress::getMemorySize).reduce(0, Integer::sum);
    }

    private void doMinorCompaction(PageIndexContext pageIndexContext, final LogicalPageChain logicalPageChain, final int curChainIndex, long version, boolean force) {
        int startCompactionIndex;
        final int curPageIndex = pageIndexContext.getPageIndexID();
        if (logicalPageChain != this.pageIndex.getLogicPage(curPageIndex)) {
            this.gRegionContext.getPageStoreStats().addRunningMinorCompactedPages(-1);
            return;
        }
        ArrayList<DataPage> canCompactPageListReversedOrder = new ArrayList<DataPage>();
        final ArrayList<PageAddress> invalidPageAddressList = new ArrayList<PageAddress>();
        int oldPageSize = 0;
        int oldSubPageNum = 0;
        int oldSubPageSize = 0;
        long oldRequestCount = 0L;
        long lastSumCompactedThreshold = -1L;
        for (startCompactionIndex = curChainIndex; startCompactionIndex >= 0; --startCompactionIndex) {
            PageAddress pageAddress = logicalPageChain.getPageAddress(startCompactionIndex);
            DataPage dataPage2 = pageAddress.getDataPage();
            if (dataPage2 != null && dataPage2.refCnt() > 1) {
                if (!force) {
                    long compactedCount = dataPage2.getCompactionCount();
                    if (lastSumCompactedThreshold == -1L) {
                        lastSumCompactedThreshold = compactedCount;
                    } else if (lastSumCompactedThreshold >= compactedCount) {
                        lastSumCompactedThreshold += compactedCount;
                    } else {
                        dataPage2.release();
                        break;
                    }
                }
                oldPageSize += pageAddress.getDataLen();
                oldSubPageNum += pageAddress.getSubPageNum();
                oldSubPageSize += pageAddress.getSubPageDataLen();
                canCompactPageListReversedOrder.add(dataPage2);
                invalidPageAddressList.add(pageAddress);
                oldRequestCount += dataPage2.getRequestCount(this.cacheManager.getCurrentTickTime());
                continue;
            }
            if (dataPage2 == null) break;
            dataPage2.release();
            break;
        }
        if (!this.gContext.isDBNormal()) {
            canCompactPageListReversedOrder.forEach(dataPage -> dataPage.release());
            throw new GeminiShutDownException("DB is in abnormal status " + this.gContext.getDBStatus().name());
        }
        if (canCompactPageListReversedOrder.size() <= this.inMemoryCompactionThreshold) {
            logicalPageChain.compareAndSetStatus(PageStatus.Compacting, PageStatus.Normal);
            this.gRegionContext.getPageStoreStats().addRunningMinorCompactedPages(-1);
            canCompactPageListReversedOrder.forEach(dataPage -> dataPage.release());
            return;
        }
        final int inclusiveCompactionStartChainIndex = startCompactionIndex + 1;
        this.gRegionContext.getPageStoreStats().addMinorCompactedPages(canCompactPageListReversedOrder.size());
        final DataPage compactedDataPage = this.doCompactPage(pageIndexContext, inclusiveCompactionStartChainIndex == 0, canCompactPageListReversedOrder, this.gContext.getCurVersion(), pageIndexContext.getPageIndexID());
        canCompactPageListReversedOrder.forEach(dataPage -> dataPage.release());
        final long finalOldRequstCount = oldRequestCount;
        final int finalOldPageSize = oldPageSize;
        final int finalOldSubPageNum = oldSubPageNum;
        final int finalOldSubPageSize = oldSubPageSize;
        if (!this.gContext.isDBNormal() || this.getExecutor().isShuttingDown()) {
            compactedDataPage.release();
        } else {
            this.gRegionContext.getPageStoreStats().addRunningCompactingPageSize(compactedDataPage == null ? 0 : compactedDataPage.getSize());
            this.getExecutor().execute((Runnable)new GeminiEventExecutorTask(){

                @Override
                public void cancel() {
                    compactedDataPage.release();
                }

                /*
                 * Loose catch block
                 */
                @Override
                public void run() {
                    try {
                        AbstractHashPageStore.this.pageCompactHandler.doSyncReplace(logicalPageChain, curPageIndex, finalOldPageSize, finalOldSubPageNum, finalOldSubPageSize, finalOldRequstCount, inclusiveCompactionStartChainIndex, curChainIndex, compactedDataPage, invalidPageAddressList, curPageIndex);
                    }
                    catch (GeminiShutDownException e) {
                        if (compactedDataPage.refCnt() == 1) {
                            compactedDataPage.release();
                        }
                        LOG.warn("GeminiDB has shutdown!");
                        AbstractHashPageStore.this.gRegionContext.getPageStoreStats().addRunningMinorCompactedPages(-1);
                        AbstractHashPageStore.this.gRegionContext.getPageStoreStats().addRunningCompactingPageSize(-(compactedDataPage == null ? 0 : compactedDataPage.getSize()));
                    }
                    catch (Exception e2) {
                        LOG.info("Internal Bug", (Throwable)e2);
                        if (compactedDataPage.refCnt() == 1) {
                            compactedDataPage.release();
                        }
                        AbstractHashPageStore.this.gContext.setDBInternalError(e2);
                        AbstractHashPageStore.this.gRegionContext.getPageStoreStats().addRunningMinorCompactedPages(-1);
                        AbstractHashPageStore.this.gRegionContext.getPageStoreStats().addRunningCompactingPageSize(-(compactedDataPage == null ? 0 : compactedDataPage.getSize()));
                        {
                            catch (Throwable throwable) {
                                AbstractHashPageStore.this.gRegionContext.getPageStoreStats().addRunningMinorCompactedPages(-1);
                                AbstractHashPageStore.this.gRegionContext.getPageStoreStats().addRunningCompactingPageSize(-(compactedDataPage == null ? 0 : compactedDataPage.getSize()));
                                throw throwable;
                            }
                        }
                    }
                    AbstractHashPageStore.this.gRegionContext.getPageStoreStats().addRunningMinorCompactedPages(-1);
                    AbstractHashPageStore.this.gRegionContext.getPageStoreStats().addRunningCompactingPageSize(-(compactedDataPage == null ? 0 : compactedDataPage.getSize()));
                }
            });
        }
    }

    private void doMajorCompaction(PageIndexContext pageIndexContext, final LogicalPageChain logicalPageChain, final int curPageIndex, final int curChainIndex, long version) {
        if (logicalPageChain != this.pageIndex.getLogicPage(curPageIndex)) {
            this.gRegionContext.getPageStoreStats().addRunningMajorCompactedPages(-1);
            return;
        }
        ArrayList<DataPage> dataPageListReversedOrder = new ArrayList<DataPage>();
        final ArrayList<PageAddress> invalidPageAddressList = new ArrayList<PageAddress>();
        long oldRequestCount = 0L;
        int oldCompactedPageSize = 0;
        int oldCompactedSubPageNum = 0;
        int oldCompactedSubPageSize = 0;
        for (int cix = curChainIndex; cix >= 0 && this.gContext.isDBNormal(); --cix) {
            PageAddress pageAddress = logicalPageChain.getPageAddress(cix);
            DataPage<K, V> dataPage2 = pageAddress.getDataPage();
            if (dataPage2 == null) {
                this.cacheManager.getCacheStats().addPageForceFetchByCompactionCount();
                GByteBuffer gByteBuffer = this.gContext.getSupervisor().getFetchPolicy().fetch(pageAddress, logicalPageChain, pageIndexContext.getPageIndexID(), cix, this.gRegionContext, false, false);
                dataPage2 = this.boxDataPage(pageAddress, gByteBuffer, pageIndexContext.getPageIndexID(), pageIndexContext.getLogicalPageChain().hashCode());
            }
            oldCompactedPageSize += pageAddress.getDataLen();
            oldCompactedSubPageNum += pageAddress.getSubPageNum();
            oldCompactedSubPageSize += pageAddress.getSubPageDataLen();
            dataPageListReversedOrder.add(dataPage2);
            invalidPageAddressList.add(pageAddress);
            oldRequestCount += dataPage2.getRequestCount(this.cacheManager.getCurrentTickTime());
        }
        if (!this.gContext.isDBNormal()) {
            dataPageListReversedOrder.forEach(dataPage -> dataPage.release());
            throw new GeminiShutDownException("DB is in abnormal status " + this.gContext.getDBStatus().name());
        }
        if (dataPageListReversedOrder.isEmpty()) {
            throw new GeminiRuntimeException("BUG");
        }
        this.gRegionContext.getPageStoreStats().addMajorCompactedPages(dataPageListReversedOrder.size());
        final DataPage compactedDataPage = this.doCompactPage(pageIndexContext, true, dataPageListReversedOrder, this.gContext.getCurVersion(), curPageIndex);
        dataPageListReversedOrder.forEach(dataPage -> dataPage.release());
        final long finalOldRequestCount = oldRequestCount;
        final int finalOldCompactedPageSize = oldCompactedPageSize;
        final int finalOldCompactedSubPageNum = oldCompactedSubPageNum;
        final int finalOldCompactedSubPageSize = oldCompactedSubPageSize;
        if (!this.gContext.isDBNormal() || this.getExecutor().isShuttingDown()) {
            compactedDataPage.release();
        } else {
            this.gRegionContext.getPageStoreStats().addRunningCompactingPageSize(compactedDataPage == null ? 0 : compactedDataPage.getSize());
            this.getExecutor().execute((Runnable)new GeminiEventExecutorTask(){

                @Override
                public void cancel() {
                    compactedDataPage.release();
                }

                /*
                 * Loose catch block
                 */
                @Override
                public void run() {
                    try {
                        AbstractHashPageStore.this.pageCompactHandler.doSyncReplace(logicalPageChain, curPageIndex, finalOldCompactedPageSize, finalOldCompactedSubPageNum, finalOldCompactedSubPageSize, finalOldRequestCount, 0, curChainIndex, compactedDataPage, invalidPageAddressList, curPageIndex);
                    }
                    catch (GeminiShutDownException e) {
                        if (compactedDataPage.refCnt() == 1) {
                            compactedDataPage.release();
                        }
                        LOG.warn("GeminiDB has shutdown!");
                        AbstractHashPageStore.this.gRegionContext.getPageStoreStats().addRunningMajorCompactedPages(-1);
                        AbstractHashPageStore.this.gRegionContext.getPageStoreStats().addRunningCompactingPageSize(-(compactedDataPage == null ? 0 : compactedDataPage.getSize()));
                    }
                    catch (Exception e2) {
                        LOG.error("Internal Bug.", (Throwable)e2);
                        if (compactedDataPage.refCnt() == 1) {
                            compactedDataPage.release();
                        }
                        AbstractHashPageStore.this.gContext.setDBInternalError(e2);
                        AbstractHashPageStore.this.gRegionContext.getPageStoreStats().addRunningMajorCompactedPages(-1);
                        AbstractHashPageStore.this.gRegionContext.getPageStoreStats().addRunningCompactingPageSize(-(compactedDataPage == null ? 0 : compactedDataPage.getSize()));
                        {
                            catch (Throwable throwable) {
                                AbstractHashPageStore.this.gRegionContext.getPageStoreStats().addRunningMajorCompactedPages(-1);
                                AbstractHashPageStore.this.gRegionContext.getPageStoreStats().addRunningCompactingPageSize(-(compactedDataPage == null ? 0 : compactedDataPage.getSize()));
                                throw throwable;
                            }
                        }
                    }
                    AbstractHashPageStore.this.gRegionContext.getPageStoreStats().addRunningMajorCompactedPages(-1);
                    AbstractHashPageStore.this.gRegionContext.getPageStoreStats().addRunningCompactingPageSize(-(compactedDataPage == null ? 0 : compactedDataPage.getSize()));
                }
            });
        }
    }

    private void doMinorCompactionByRead(PageIndexContext pageIndexContext, final LogicalPageChain logicalPageChain, final int curPageIndex, final int curChainIndex, Map<Integer, DataPage> fetchedDataPageMap) {
        int startCompactionIndex;
        if (logicalPageChain != this.pageIndex.getLogicPage(curPageIndex)) {
            this.gRegionContext.getPageStoreStats().addRunningMinorCompactionByRead(-1);
            return;
        }
        ArrayList<DataPage> canCompactPageListReversedOrder = new ArrayList<DataPage>();
        final ArrayList<PageAddress> invalidPageAddressList = new ArrayList<PageAddress>();
        int oldCompactedPageSize = 0;
        int oldCompactedSubPageNum = 0;
        int oldCompactedSubPageSize = 0;
        long oldRequestCount = 0L;
        for (startCompactionIndex = curChainIndex; startCompactionIndex >= 0; --startCompactionIndex) {
            PageAddress pageAddress = logicalPageChain.getPageAddress(startCompactionIndex);
            DataPage dataPage2 = pageAddress.getDataPage();
            if (dataPage2 == null || dataPage2.refCnt() <= 1) {
                dataPage2 = fetchedDataPageMap.get(startCompactionIndex);
                if (dataPage2 == null || dataPage2.refCnt() <= 0) break;
                dataPage2.retain();
            }
            oldCompactedPageSize += pageAddress.getDataLen();
            oldCompactedSubPageNum += pageAddress.getSubPageNum();
            oldCompactedSubPageSize += pageAddress.getSubPageDataLen();
            canCompactPageListReversedOrder.add(dataPage2);
            invalidPageAddressList.add(pageAddress);
            oldRequestCount += dataPage2.getRequestCount(this.cacheManager.getCurrentTickTime());
        }
        if (!this.gContext.isDBNormal()) {
            canCompactPageListReversedOrder.forEach(dataPage -> dataPage.release());
            throw new GeminiShutDownException("DB is in abnormal status " + this.gContext.getDBStatus().name());
        }
        if (canCompactPageListReversedOrder.size() < 2) {
            logicalPageChain.compareAndSetStatus(PageStatus.Compacting, PageStatus.Normal);
            this.gRegionContext.getPageStoreStats().addRunningMinorCompactionByRead(-1);
            canCompactPageListReversedOrder.forEach(dataPage -> dataPage.release());
            return;
        }
        final int inclusiveCompactionStartChainIndex = startCompactionIndex + 1;
        this.gRegionContext.getPageStoreStats().addMinorCompactedPages(canCompactPageListReversedOrder.size());
        final DataPage compactedDataPage = this.doCompactPage(pageIndexContext, inclusiveCompactionStartChainIndex == 0, canCompactPageListReversedOrder, this.gContext.getCurVersion(), curPageIndex);
        canCompactPageListReversedOrder.forEach(dataPage -> dataPage.release());
        final long finalOldRequstCount = oldRequestCount;
        final int finalOldCompactedPageSize = oldCompactedPageSize;
        final int finalOldCompactedSubPageNum = oldCompactedSubPageNum;
        final int finalOldCompactedSubPageSize = oldCompactedSubPageSize;
        final Set<DataPage> dataPages = logicalPageChain.getAllDataPageReferenced();
        if (this.gContext.isDBNormal() && !this.getExecutor().isShuttingDown()) {
            this.gRegionContext.getPageStoreStats().addRunningCompactingPageSize(compactedDataPage == null ? 0 : compactedDataPage.getSize());
            this.getExecutor().execute((Runnable)new GeminiEventExecutorTask(){

                @Override
                public void cancel() {
                    dataPages.forEach(dataPage -> dataPage.release());
                    compactedDataPage.release();
                }

                /*
                 * Loose catch block
                 */
                @Override
                public void run() {
                    try {
                        AbstractHashPageStore.this.pageCompactHandler.doSyncReplace(logicalPageChain, curPageIndex, finalOldCompactedPageSize, finalOldCompactedSubPageNum, finalOldCompactedSubPageSize, finalOldRequstCount, inclusiveCompactionStartChainIndex, curChainIndex, compactedDataPage, invalidPageAddressList, curPageIndex);
                    }
                    catch (GeminiShutDownException e) {
                        LOG.warn("GeminiDB has shutdown!");
                        AbstractHashPageStore.this.gRegionContext.getPageStoreStats().addRunningMinorCompactionByRead(-1);
                        AbstractHashPageStore.this.gRegionContext.getPageStoreStats().addRunningCompactingPageSize(-(compactedDataPage == null ? 0 : compactedDataPage.getSize()));
                        dataPages.forEach(dataPage -> dataPage.release());
                    }
                    catch (Exception e2) {
                        LOG.error("Internal Bug", (Throwable)e2);
                        AbstractHashPageStore.this.gContext.setDBInternalError(e2);
                        AbstractHashPageStore.this.gRegionContext.getPageStoreStats().addRunningMinorCompactionByRead(-1);
                        AbstractHashPageStore.this.gRegionContext.getPageStoreStats().addRunningCompactingPageSize(-(compactedDataPage == null ? 0 : compactedDataPage.getSize()));
                        {
                            catch (Throwable throwable) {
                                AbstractHashPageStore.this.gRegionContext.getPageStoreStats().addRunningMinorCompactionByRead(-1);
                                AbstractHashPageStore.this.gRegionContext.getPageStoreStats().addRunningCompactingPageSize(-(compactedDataPage == null ? 0 : compactedDataPage.getSize()));
                                dataPages.forEach(dataPage -> dataPage.release());
                                throw throwable;
                            }
                        }
                        dataPages.forEach(dataPage -> dataPage.release());
                    }
                    AbstractHashPageStore.this.gRegionContext.getPageStoreStats().addRunningMinorCompactionByRead(-1);
                    AbstractHashPageStore.this.gRegionContext.getPageStoreStats().addRunningCompactingPageSize(-(compactedDataPage == null ? 0 : compactedDataPage.getSize()));
                    dataPages.forEach(dataPage -> dataPage.release());
                }
            });
        } else {
            dataPages.forEach(dataPage -> dataPage.release());
        }
    }

    @Override
    public void splitPage(PageIndexContext pageIndexContext) {
        Tuple2<DataPage, DataPage> splitDataPages;
        LogicalPageChain currentLogicPage = pageIndexContext.getLogicalPageChain();
        PageIndexContextHashImpl uPageIndexContext = (PageIndexContextHashImpl)pageIndexContext;
        int curBucketNum = uPageIndexContext.getCurBucketNum();
        int curIndex = uPageIndexContext.getCurIndex();
        int destIndex = (curBucketNum = this.pageIndex.getBucketNumASPageFinishSplit(curBucketNum, curIndex)) + curIndex;
        if (this.pageIndex.getLogicPage(destIndex) != PageIndexHashImpl.WAIT_SPLITTING_PAGE || this.pageIndex.getLogicPage(curIndex) != currentLogicPage) {
            return;
        }
        ArrayList<DataPage> dataPageListReversedOrder = new ArrayList<DataPage>();
        ArrayList<PageAddress> invalidPageAddressList = new ArrayList<PageAddress>();
        long oldRequestNum = 0L;
        int oldCompactedPageSize = 0;
        int oldCompactedSubPageNum = 0;
        int oldCompactedSubPageSize = 0;
        int oldMemPageSize = 0;
        for (int cix = currentLogicPage.getCurrentPageChainIndex(); cix >= 0 && this.gContext.isDBNormal(); --cix) {
            PageAddress pageAddress = currentLogicPage.getPageAddress(cix);
            DataPage<K, V> dataPage2 = pageAddress.getDataPage();
            if (dataPage2 == null) {
                this.cacheManager.getCacheStats().addPageForceFetchByCompactionCount();
                GByteBuffer gByteBuffer = this.gContext.getSupervisor().getFetchPolicy().fetch(pageAddress, currentLogicPage, pageIndexContext.getPageIndexID(), cix, this.gRegionContext, false, false);
                dataPage2 = this.boxDataPage(pageAddress, gByteBuffer, pageIndexContext.getPageIndexID(), pageIndexContext.getLogicalPageChain().hashCode());
            }
            oldMemPageSize += pageAddress.getMemorySize();
            oldCompactedPageSize += pageAddress.getDataLen();
            oldCompactedSubPageNum += pageAddress.getSubPageNum();
            oldCompactedSubPageSize += pageAddress.getSubPageDataLen();
            dataPageListReversedOrder.add(dataPage2);
            invalidPageAddressList.add(pageAddress);
            oldRequestNum += dataPage2.getRequestCount(this.cacheManager.getCurrentTickTime());
        }
        if (!this.gContext.isDBNormal()) {
            dataPageListReversedOrder.forEach(dataPage -> dataPage.release());
            throw new GeminiShutDownException("DB is in abnormal status " + this.gContext.getDBStatus().name());
        }
        if (dataPageListReversedOrder.isEmpty()) {
            return;
        }
        DataPage mergeDataPage = this.doCompactPage(pageIndexContext, true, dataPageListReversedOrder, this.gContext.getCurVersion(), pageIndexContext.getPageIndexID());
        dataPageListReversedOrder.forEach(dataPage -> dataPage.release());
        Tuple2<DataPage, DataPage> tuple2 = splitDataPages = mergeDataPage == null ? new Tuple2<DataPage, DataPage>(null, null) : mergeDataPage.split(pageIndexContext, curBucketNum, curIndex, this.gContext.getSupervisor().getAllocator(), this.gContext.getInPageGCompressAlgorithm(), this.gRegionContext);
        if (mergeDataPage != null) {
            mergeDataPage.release();
        }
        if (splitDataPages.f1 == null && splitDataPages.f0 != null) {
            this.doSyncReplaceLogicalPage(currentLogicPage, curIndex, oldCompactedPageSize, oldCompactedSubPageNum, oldCompactedSubPageSize, oldRequestNum, 0, currentLogicPage.getCurrentPageChainIndex(), (DataPage)splitDataPages.f0, invalidPageAddressList, false, destIndex);
            this.pageIndex.updateLogicPage(destIndex, PageIndexHashImpl.NO_PAGE);
            return;
        }
        if (splitDataPages.f0 == null && splitDataPages.f1 != null) {
            this.doSyncReplaceLogicalPage(currentLogicPage, destIndex, oldCompactedPageSize, oldCompactedSubPageNum, oldCompactedSubPageSize, oldRequestNum, 0, currentLogicPage.getCurrentPageChainIndex(), (DataPage)splitDataPages.f1, invalidPageAddressList, true, curIndex);
            this.pageIndex.updateLogicPage(curIndex, PageIndexHashImpl.NO_PAGE);
            return;
        }
        if (splitDataPages.f0 == null && splitDataPages.f1 == null) {
            this.pageIndex.updateLogicPage(destIndex, PageIndexHashImpl.NO_PAGE);
            this.pageIndex.updateLogicPage(curIndex, PageIndexHashImpl.NO_PAGE);
            this.gContext.getSupervisor().discardPage(this.gRegionContext, invalidPageAddressList);
            this.removeInvalidPage(this.gRegion, invalidPageAddressList);
            this.cacheManager.getEvictPolicy().tryPrepareFlush(this.gRegion, 0);
            this.gRegionContext.getPageStoreStats().addLogicPageCount(-1);
            this.gRegionContext.getPageStoreStats().addLogicPageChainLen(0 - currentLogicPage.getCurrentPageChainIndex() - 1);
            this.gRegionContext.getPageStoreStats().addLogicPageChainCapacity(0 - currentLogicPage.getPageChainCapacity());
            this.gRegionContext.getPageStoreStats().addLogicPageSize(0 - currentLogicPage.getPageSize());
            this.gRegionContext.getPageStoreStats().addLogicSubPageCount(0 - currentLogicPage.getSubPageNum());
            this.gRegionContext.getPageStoreStats().addLogicSubPageSize(0 - currentLogicPage.getSubPageSize());
            this.gRegionContext.getPageStoreStats().addPageUsedMemory(this.gRegion, 0 - oldMemPageSize);
            return;
        }
        LogicalPageChain pageSpit1 = this.pageIndex.createLogicalPageChain();
        LogicalPageChain pageSpit2 = this.pageIndex.createLogicalPageChain();
        PageAddress pageAddressSplit1 = pageSpit1.createPage((DataPage)splitDataPages.f0);
        PageAddress pageAddressSplit2 = pageSpit2.createPage((DataPage)splitDataPages.f1);
        pageAddressSplit1.addRequestCountForNewPage(this.cacheManager.getCurrentTickTime(), (int)(oldRequestNum / 2L & Integer.MAX_VALUE));
        pageAddressSplit2.addRequestCountForNewPage(this.cacheManager.getCurrentTickTime(), (int)(oldRequestNum - oldRequestNum / 2L & Integer.MAX_VALUE));
        pageSpit1.addPageSize(pageAddressSplit1.getDataLen());
        pageSpit2.addPageSize(pageAddressSplit2.getDataLen());
        this.pageIndex.updateLogicPage(destIndex, pageSpit2);
        this.pageIndex.updateLogicPage(curIndex, pageSpit1);
        List<PageAddress> findRealNeedDiscardPage = this.findNeededDiscardPage(invalidPageAddressList, pageAddressSplit1, pageAddressSplit2);
        this.gContext.getSupervisor().discardPage(this.gRegionContext, findRealNeedDiscardPage);
        this.removeInvalidPage(this.gRegion, invalidPageAddressList);
        this.gContext.getSupervisor().getPersistencyStrategy().persistPage(this.gRegion, pageAddressSplit1, pageAddressSplit1.getMemorySize());
        this.gContext.getSupervisor().getPersistencyStrategy().persistPage(this.gRegion, pageAddressSplit2, pageAddressSplit2.getMemorySize());
        this.cacheManager.getEvictPolicy().addPage(this.gRegion, pageAddressSplit1);
        this.cacheManager.getEvictPolicy().addPage(this.gRegion, pageAddressSplit2);
        this.cacheManager.getEvictPolicy().tryPrepareFlush(this.gRegion, pageAddressSplit1.getMemorySize() + pageAddressSplit2.getMemorySize() - oldMemPageSize);
        this.gRegionContext.getPageStoreStats().addPageUsedMemory(this.gRegion, pageAddressSplit1.getMemorySize() + pageAddressSplit2.getMemorySize() - oldMemPageSize);
        this.gRegionContext.getPageStoreStats().addLogicPageCount(1);
        this.gRegionContext.getPageStoreStats().addLogicPageChainLen(2 - currentLogicPage.getCurrentPageChainIndex() - 1);
        this.gRegionContext.getPageStoreStats().addLogicPageChainCapacity(pageSpit1.getPageChainCapacity() + pageSpit2.getPageChainCapacity() - currentLogicPage.getPageChainCapacity());
        this.gRegionContext.getPageStoreStats().addLogicPageSize(pageSpit2.getPageSize() + pageSpit1.getPageSize() - currentLogicPage.getPageSize());
        this.gRegionContext.getPageStoreStats().addLogicSubPageCount(pageSpit2.getSubPageNum() + pageSpit1.getSubPageNum() - currentLogicPage.getSubPageNum());
        this.gRegionContext.getPageStoreStats().addLogicSubPageSize(pageSpit2.getSubPageSize() + pageSpit1.getSubPageSize() - currentLogicPage.getSubPageSize());
    }

    private List<PageAddress> findNeededDiscardPage(List<PageAddress> invalidPageAddressList, PageAddress ... newPageAddress) {
        if (newPageAddress == null || newPageAddress.length == 0) {
            return invalidPageAddressList;
        }
        if (newPageAddress.length == 1 && newPageAddress[0] instanceof PageAddressSingleImpl) {
            return invalidPageAddressList;
        }
        HashMap<PageAddressSingleImpl, PageAddress> newSubPageMap = new HashMap<PageAddressSingleImpl, PageAddress>();
        for (PageAddress pageAddress : newPageAddress) {
            PageAddress[] subPages;
            if (!(pageAddress instanceof PageAddressCompositeImpl)) continue;
            PageAddress[] pageAddressArray = subPages = ((PageAddressCompositeImpl)pageAddress).getSubPageAddress();
            int n = pageAddressArray.length;
            for (int i = 0; i < n; ++i) {
                PageAddress pageAddressSub = pageAddressArray[i];
                newSubPageMap.put((PageAddressSingleImpl)pageAddressSub, pageAddress);
            }
        }
        if (newSubPageMap.size() == 0) {
            return invalidPageAddressList;
        }
        ArrayList<PageAddress> realNeedInvalidPageList = new ArrayList<PageAddress>();
        for (PageAddress invalidPageAddress : invalidPageAddressList) {
            if (invalidPageAddress instanceof PageAddressCompositeImpl) {
                PageAddressCompositeImpl invalidPageComposite = (PageAddressCompositeImpl)invalidPageAddress;
                realNeedInvalidPageList.add(invalidPageComposite.getMainPageAddress());
                for (PageAddress singlePage : invalidPageComposite.getSubPageAddress()) {
                    if (newSubPageMap.containsKey(singlePage)) continue;
                    realNeedInvalidPageList.add(singlePage);
                }
                continue;
            }
            realNeedInvalidPageList.add(invalidPageAddress);
        }
        return realNeedInvalidPageList;
    }

    @Override
    public void mergePage(PageIndexContext pageIndexContextFirst, PageIndexContext pageIndexContextSecond) {
        PageIndexContextHashImpl uPageIndexContextFirst = (PageIndexContextHashImpl)pageIndexContextFirst;
        int curIndexFirst = uPageIndexContextFirst.getCurIndex();
        if (pageIndexContextFirst != this.pageIndex.getLogicPage(curIndexFirst)) {
            return;
        }
    }

    private void doWriteDataToPage(PageIndexContext pageIndexContext, List<Tuple2<K, GSValue<V>>> dataSet, long version) {
        LogicalPageChain currentLogicPageID = pageIndexContext.getLogicalPageChain();
        long newRequestCount = this.getRequestCount(dataSet);
        DataPage<K, V> newDataPage = this.createDataPage(version, dataSet, pageIndexContext.getPageIndexID());
        if (newDataPage == null) {
            LOG.warn("doWriteDataToPage write empty value");
        } else {
            int dataSize;
            PageAddress pageAddress = this.helpAddDataPage(currentLogicPageID, newRequestCount, newDataPage);
            int memSize = dataSize = pageAddress.getDataLen();
            if (dataSize > 2048) {
                this.gContext.getSupervisor().getPersistencyStrategy().persistPage(this.gRegion, pageAddress, dataSize);
                memSize = pageAddress.getMemorySize();
            }
            currentLogicPageID.addPageSize(dataSize);
            this.cacheManager.getEvictPolicy().tryPrepareFlush(this.gRegion, memSize);
            this.gRegionContext.getPageStoreStats().addPageUsedMemory(this.gRegion, memSize);
            this.gRegionContext.getPageStoreStats().addLogicPageSize(dataSize);
            this.gRegionContext.getPageStoreStats().addLogicSubPageCount(pageAddress.getSubPageNum());
            this.gRegionContext.getPageStoreStats().addLogicSubPageSize(pageAddress.getSubPageNum());
            this.gRegionContext.getPageStoreStats().addPageRequestCount(newRequestCount);
            this.gRegionContext.getPageStoreStats().addPage();
        }
        if (!pageIndexContext.isNeedSplit()) {
            this.compactPage(pageIndexContext, version);
        }
    }

    private PageAddress helpAddDataPage(LogicalPageChain currentLogicPageID, long newRequestCount, DataPage dataPage) {
        int oldChainCapacity = currentLogicPageID.getPageChainCapacity();
        PageAddress result = currentLogicPageID.createPage(dataPage);
        int changeCapacity = currentLogicPageID.getPageChainCapacity() - oldChainCapacity;
        result.addRequestCountForNewPage(this.cacheManager.getCurrentTickTime(), (int)(newRequestCount & Integer.MAX_VALUE));
        this.gRegionContext.getPageStoreStats().addLogicPageChainLen(1);
        this.gRegionContext.getPageStoreStats().addLogicPageChainCapacity(changeCapacity);
        return result;
    }

    @Override
    public void checkResource() {
        if (this.cacheManager.forbidIndexExpand()) {
            LOG.debug("cacheManager forbid index to expand.");
            return;
        }
        if (this.gRegionContext.getPageStoreStats().getLogicPageCount() == 0) {
            LOG.debug("no page here");
            return;
        }
        int indexCap = this.gRegionContext.getPageStoreStats().getIndexCapacity();
        if ((indexCap - this.gRegionContext.getPageStoreStats().getLogicPageCount()) * 4 > indexCap) {
            LOG.debug("page count {}, so at least 25% index capacity {} not to expand index", (Object)this.gRegionContext.getPageStoreStats().getLogicPageCount(), (Object)this.gRegionContext.getPageStoreStats().getIndexCapacity());
            return;
        }
        long validPageSize = this.gRegionContext.getPageStoreStats().getLogicPageSize() - (long)this.gRegionContext.getHugePageTotalSize() - this.gRegionContext.getPageStoreStats().getLogicSubPageSize();
        int validPageNum = this.gRegionContext.getPageStoreStats().getLogicPageCount() - this.gRegionContext.getHugePageMapCount();
        int averagePageSize = validPageSize <= 0L || validPageNum <= 0 || this.gRegionContext.getHugePageMapCount() * 2 >= this.gRegionContext.getPageStoreStats().getLogicPageCount() ? (int)((this.gRegionContext.getPageStoreStats().getLogicPageSize() - this.gRegionContext.getPageStoreStats().getLogicSubPageSize()) / (long)this.gRegionContext.getPageStoreStats().getLogicPageCount()) : (int)(validPageSize / (long)validPageNum);
        if (averagePageSize >= this.splitPageSizeThreshold) {
            this.pageIndex.expand();
            LOG.info("averagePageSize {}, splitPageSizeThreshold {}, logicPageSize {}, hugePageTotalSize {}, logicSubPageSize {}, logicPageCount {}, hugePageMapCount {}, to expand index up to {}", new Object[]{averagePageSize, this.splitPageSizeThreshold, this.gRegionContext.getPageStoreStats().getLogicPageSize(), this.gRegionContext.getHugePageTotalSize(), this.gRegionContext.getPageStoreStats().getLogicSubPageSize(), this.gRegionContext.getPageStoreStats().getLogicPageCount(), this.gRegionContext.getHugePageMapCount(), this.gRegionContext.getPageStoreStats().getIndexCapacity()});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void tryLaunchCompactionByRead(final PageIndexContext pageIndexContext, final LogicalPageChain logicalPageChain, final Map<Integer, DataPage> fetchedDataPageMap) {
        boolean releaseFetchMap = true;
        try {
            if (logicalPageChain.getCurrentPageChainIndex() > this.inMemoryCompactionThreshold) {
                if (logicalPageChain.getPageStatus().canCompaction()) {
                    this.gRegionContext.getPageStoreStats().addRunningMinorCompactionByRead(1);
                    if (this.cacheManager.getCacheStats().getRunningMinorCompactionByRead() > this.maxRunningMinorCompaction) {
                        this.gRegionContext.getPageStoreStats().addRunningMinorCompactionByRead(-1);
                    } else {
                        if (!logicalPageChain.compareAndSetStatus(PageStatus.Normal, PageStatus.Compacting)) {
                            this.gRegionContext.getPageStoreStats().addRunningMinorCompactionByRead(-1);
                            return;
                        }
                        final int curChainIndex = logicalPageChain.getCurrentPageChainIndex();
                        final int curPageIndex = pageIndexContext.getPageIndexID();
                        EventExecutor eventExecutor = this.gContext.getSupervisor().getCompactionExecutorGroup().next();
                        releaseFetchMap = false;
                        eventExecutor.execute((Runnable)new GeminiEventExecutorTask(){

                            @Override
                            public void cancel() {
                                fetchedDataPageMap.values().forEach(dataPage -> dataPage.release());
                            }

                            @Override
                            public void run() {
                                try {
                                    AbstractHashPageStore.this.pageCompactHandler.doAsyncMinorCompactionByRead(pageIndexContext, logicalPageChain, curPageIndex, curChainIndex, fetchedDataPageMap);
                                }
                                catch (GeminiShutDownException e) {
                                    LOG.debug("GeminiDB has shutdown!", (Throwable)e);
                                }
                                catch (Exception e) {
                                    LOG.error("async minor compaction by read failed", (Throwable)e);
                                }
                                finally {
                                    fetchedDataPageMap.values().forEach(dataPage -> dataPage.release());
                                }
                            }
                        });
                    }
                }
            } else if (fetchedDataPageMap.size() > 0) {
                if (!this.enableLoadPageFromLRUIntoMainCache) {
                    return;
                }
                if (this.lruIntoMainCacheSleepMs != -1 && System.currentTimeMillis() - this.lastLruIntoMainCacheTimeMs < (long)this.lruIntoMainCacheSleepMs) {
                    return;
                }
                this.lastLruIntoMainCacheTimeMs = System.currentTimeMillis();
                if (this.cacheTooFull(0)) {
                    LOG.warn("Can not add page into main cache because of cache is full.");
                    return;
                }
                this.lruIntoMainEventExecutor.execute(() -> this.fetchPageFromLRUCacheToPageStore());
            }
        }
        finally {
            if (releaseFetchMap) {
                fetchedDataPageMap.values().forEach(dataPage -> dataPage.release());
            }
        }
    }

    protected DataPage doCompactPageForStructureValue(PageIndexContext pageIndexContext, boolean isMajor, List<DataPage> canCompactPageListReversedOrder, long version, int logicPageId) {
        int index;
        ArrayList compactionListReversedOrder = new ArrayList();
        for (DataPage dataPage : canCompactPageListReversedOrder) {
            compactionListReversedOrder.add(dataPage.getGBinaryHashMap());
        }
        HashMap<BinaryKey, ArrayList> newMap = new HashMap<BinaryKey, ArrayList>(((GBinaryHashMap)compactionListReversedOrder.get(index)).keyCount());
        long compactionCount = 0L;
        StateFilter stateFilter = this.gRegionContext.getGContext().getStateFilter();
        for (index = compactionListReversedOrder.size() - 1; index >= 0; --index) {
            GBinaryHashMap gBinaryHashMap = (GBinaryHashMap)compactionListReversedOrder.get(index);
            for (Map.Entry<BinaryKey, BinaryValue> entry : gBinaryHashMap.getBinaryMap().entrySet()) {
                if (isMajor && stateFilter != null && stateFilter.filter(this.gRegionContext, entry.getValue().getSeqID())) continue;
                if (entry.getValue().getGValueType() == GValueType.Delete) {
                    if (isMajor) {
                        newMap.remove(entry.getKey());
                        continue;
                    }
                    newMap.put(entry.getKey(), Lists.newArrayList((Object[])new BinaryValue[]{entry.getValue()}));
                    continue;
                }
                if (entry.getValue().getGValueType() == GValueType.PutMap || entry.getValue().getGValueType() == GValueType.PutList) {
                    newMap.put(entry.getKey(), Lists.newArrayList((Object[])new BinaryValue[]{entry.getValue()}));
                    continue;
                }
                if (newMap.containsKey(entry.getKey())) {
                    ((List)newMap.get(entry.getKey())).add(entry.getValue());
                    continue;
                }
                newMap.put(entry.getKey(), Lists.newArrayList((Object[])new BinaryValue[]{entry.getValue()}));
            }
            compactionCount += ((GBinaryHashMap)compactionListReversedOrder.get(index)).getCompactionCount();
        }
        HashMap<BinaryKey, BinaryValue> finalCompactedMap = new HashMap<BinaryKey, BinaryValue>(newMap.size());
        GBufferAddressMapping pageMapping = new GBufferAddressMapping(this.gRegionContext, pageIndexContext.getPageIndexID(), pageIndexContext.getLogicalPageChain().hashCode());
        for (Map.Entry entry : newMap.entrySet()) {
            if (((List)entry.getValue()).size() == 0) {
                GeminiRuntimeException e = new GeminiRuntimeException("Internal Bug!");
                this.gContext.setDBInternalError(e);
                throw e;
            }
            BinaryValue compactedBinaryValue = ((List)entry.getValue()).size() == 1 && !isMajor && !this.isAllowSubPage() ? (BinaryValue)((List)entry.getValue()).get(0) : this.doCompactValue((List)entry.getValue(), isMajor, version, logicPageId, pageMapping);
            finalCompactedMap.put((BinaryKey)entry.getKey(), compactedBinaryValue);
        }
        return this.doBuildDataPageFromGBinaryMap(isMajor, version, logicPageId, this.pageSerdeFlink.getKeySerde(), finalCompactedMap, compactionCount, pageMapping);
    }

    protected boolean isAllowSubPage() {
        return false;
    }

    protected DataPage getDataPageAutoLoadIfNeed(K key, LogicalPageChain logicalPageChain, int logicalPageChainIndex, int curIndex, Map<Integer, DataPage> fetchedDataPageMap) {
        PageAddress pageAddress = logicalPageChain.getPageAddress(curIndex);
        DataPage<K, V> dataPage = pageAddress.getDataPage();
        if (dataPage == null) {
            this.cacheManager.getCacheStats().addPageCacheMissCount();
            if (!this.gContext.getSupervisor().getBloomFilterManager().mightContain(pageAddress, key.hashCode())) {
                this.cacheManager.getCacheStats().addBloomFilterHitCount();
                return null;
            }
            GByteBuffer gByteBuffer = this.gContext.getSupervisor().getFetchPolicy().fetch(pageAddress, logicalPageChain, logicalPageChainIndex, curIndex, this.gRegionContext, this.gRegionContext.getGContext().getGConfiguration().getEnablePrefetch(), true);
            dataPage = this.boxDataPage(pageAddress, gByteBuffer, logicalPageChainIndex, logicalPageChain.hashCode());
            fetchedDataPageMap.put(curIndex, dataPage);
            dataPage.retain();
        } else {
            this.cacheManager.getCacheStats().addPageCacheHitCount();
        }
        return dataPage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void allKeysIncludeDeleted(Set<K> allKeysIncludeDelete) {
        LogicalPageChain[] chains = this.pageIndex.getPageIndex();
        for (int logicalPageChainIndex = 0; logicalPageChainIndex < chains.length; ++logicalPageChainIndex) {
            int numPages;
            LogicalPageChain logicalPageChain = chains[logicalPageChainIndex];
            if (this.isNullPage(logicalPageChain)) continue;
            for (int i = numPages = logicalPageChain.getCurrentPageChainIndex(); i >= 0; --i) {
                PageAddress pageAddress = logicalPageChain.getPageAddress(i);
                DataPage<K, V> dataPage = pageAddress.getDataPage();
                try {
                    if (dataPage == null) {
                        this.cacheManager.getCacheStats().addPageCacheMissCount();
                        GByteBuffer gByteBuffer = this.gContext.getSupervisor().getFetchPolicy().fetch(pageAddress, logicalPageChain, logicalPageChainIndex, i, this.gRegionContext, this.gRegionContext.getGContext().getGConfiguration().getEnablePrefetch(), false);
                        dataPage = this.boxDataPage(pageAddress, gByteBuffer, logicalPageChainIndex, logicalPageChain.hashCode());
                    } else {
                        this.cacheManager.getCacheStats().addPageCacheHitCount();
                    }
                    allKeysIncludeDelete.addAll(dataPage.getPOJOSet());
                    continue;
                }
                finally {
                    if (dataPage != null) {
                        dataPage.release();
                    }
                }
            }
        }
    }

    protected void checkDataPageTypeToBox(GByteBuffer byteBuffer) {
        Preconditions.checkNotNull((Object)byteBuffer.getByteBuffer(), (String)"Not supported to box null byte buffer.");
        DataPage.DataPageType toBoxDataPageType = DataPage.DataPageType.valueOf(byteBuffer.getByteBuffer().get(0));
        Preconditions.checkArgument((toBoxDataPageType == this.dataPageType ? 1 : 0) != 0, (Object)"Internal Bug!");
    }

    abstract long getRequestCount(List<Tuple2<K, GSValue<V>>> var1);

    abstract DataPage<K, V> createDataPage(long var1, List<Tuple2<K, GSValue<V>>> var3, int var4);

    abstract DataPage<K, V> boxDataPage(PageAddress var1, GByteBuffer var2, int var3, int var4);

    @VisibleForTesting
    public abstract DataPage doCompactPage(PageIndexContext var1, boolean var2, List<DataPage> var3, long var4, int var6);

    abstract BinaryValue doCompactValue(List<BinaryValue> var1, boolean var2, long var3, int var5, GBufferAddressMapping var6);

    protected abstract DataPage doBuildDataPageFromGBinaryMap(boolean var1, long var2, int var4, TypeSerializer<K> var5, Map<BinaryKey, BinaryValue> var6, long var7, GBufferAddressMapping var9);

    protected boolean isNullPage(LogicalPageChain logicPageID) {
        return logicPageID == null || logicPageID.getCurrentPageChainIndex() == -1;
    }

    public void fetchPageFromLRUCacheToPageStore() {
        try {
            Tuple2<PageAddress, DataPageLRU.PageWithContext> hottestPage = this.getHottestDataPageFromLRU();
            if (hottestPage != null) {
                LogicalPageChain pageChain;
                this.cacheManager.getCacheStats().addLRUPagePreIntoMainCache();
                PageContext hottestPageContext = ((DataPageLRU.PageWithContext)hottestPage.f1).getPageContext();
                if (hottestPageContext == null) {
                    hottestPage = null;
                    return;
                }
                int chainIndex = hottestPageContext.getLogicPageIndex();
                if (!this.canSubmitHottestPageToRegionExecutor(chainIndex, hottestPage, pageChain = this.pageIndex.getLogicPage(chainIndex))) {
                    hottestPage = null;
                    return;
                }
                PageAddress hottestPageAddress = (PageAddress)hottestPage.f0;
                GByteBuffer buffer = ((DataPageLRU.PageWithContext)hottestPage.f1).getFutureDataPage().get();
                buffer.retain();
                hottestPage = null;
                hottestPageContext.setCacheStatus(PageContext.CacheStatus.CACHING_TO_MAIN);
                this.eventExecutor.submit(() -> {
                    try {
                        LogicalPageChain currentPageChain = this.pageIndex.getLogicPage(chainIndex);
                        if (currentPageChain == null) {
                            hottestPageContext.setCacheStatus(PageContext.CacheStatus.IN_LRU);
                            return;
                        }
                        if (!this.canAddHottestPageToPageStore(chainIndex, hottestPageContext, currentPageChain)) {
                            hottestPageContext.setCacheStatus(PageContext.CacheStatus.IN_LRU);
                            return;
                        }
                        this.tryLoadPageIntoPageAddress(hottestPageAddress, buffer, chainIndex, currentPageChain);
                        this.gRegionContext.getGContext().getSupervisor().getFetchPolicy().getDataPageLRU().remove(hottestPageAddress);
                    }
                    catch (Exception e) {
                        this.gContext.getNoCriticalEvent().pushEvent(e, System.currentTimeMillis());
                    }
                    finally {
                        buffer.release();
                    }
                });
            }
        }
        catch (Exception e) {
            this.gContext.getNoCriticalEvent().pushEvent(e, System.currentTimeMillis());
        }
    }

    protected boolean cacheTooFull(int tryAddNewPageSize) {
        return this.gRegionContext.getPageStoreStats().getPageUsedMemory() + (long)tryAddNewPageSize > this.curRegionMemHighMark && this.gRegionContext.getGContext().getSupervisor().getCacheManager().getEvictPolicy().getEvictHandlerSepImpl(this.gRegion).getReadyToEvictDataPageMap().isEmpty();
    }

    public boolean tryLoadPageIntoPageAddress(PageAddress hottestPageAddress, GByteBuffer buffer, int pageChainIndex, LogicalPageChain logicalPageChain) {
        for (int i = 0; i <= logicalPageChain.getCurrentPageChainIndex(); ++i) {
            Iterator<PageAddress> pageIter = logicalPageChain.getPageAddress(i).pageIteratorOrdered();
            int idx = -1;
            while (pageIter.hasNext()) {
                PageAddress pageAddress = pageIter.next();
                Preconditions.checkState((boolean)(pageAddress instanceof PageAddressSingleImpl));
                if (hottestPageAddress.equals(pageAddress)) {
                    if (!pageAddress.hasDataPage()) {
                        DataPage newDataPage = this.createDataPageFromGByteBuffer(idx, idx == -1 ? logicalPageChain.getPageAddress(i) : pageAddress, buffer, pageChainIndex, logicalPageChain.hashCode());
                        newDataPage.retain();
                        pageAddress.setDataPage(newDataPage);
                        this.cacheManager.getEvictPolicy().tryPrepareFlush(this.gRegion, newDataPage.getSize());
                        this.gRegionContext.getPageStoreStats().addPageUsedMemory(this.gRegion, newDataPage.getSize());
                        this.cacheManager.getCacheStats().addLRUPageIntoMainCache();
                    }
                    return true;
                }
                ++idx;
            }
        }
        return false;
    }

    private DataPage createDataPageFromGByteBuffer(int subPageIndex, PageAddress pageAddress, GByteBuffer byteBuffer, int logicPageChainIndex, int logicPageChainHashCode) {
        if (subPageIndex < 0) {
            return this.boxDataPage(pageAddress, byteBuffer, logicPageChainIndex, logicPageChainHashCode);
        }
        Preconditions.checkState((boolean)this.getDataPageType().isKMapType(), (Object)"currently split type only support map type.");
        PageSerdeFlink2Key pageSerdeFlink2Key = (PageSerdeFlink2Key)this.pageSerdeFlink;
        return new DataPageHashSubPageImpl(new GBinaryHashMap(byteBuffer, pageSerdeFlink2Key.getKey2Serde()));
    }

    protected boolean canSubmitHottestPageToRegionExecutor(int chainIndex, Tuple2<PageAddress, DataPageLRU.PageWithContext> hottestPage, LogicalPageChain pageChain) {
        if (((DataPageLRU.PageWithContext)hottestPage.f1).getPageContext() == null) {
            return false;
        }
        if (pageChain == null) {
            return false;
        }
        if (this.invalidRegion(this.gRegionContext.getRegionId(), ((DataPageLRU.PageWithContext)hottestPage.f1).getPageContext().getGRegionID())) {
            return false;
        }
        if (this.isPageChainChanged(chainIndex, ((DataPageLRU.PageWithContext)hottestPage.f1).getPageContext(), pageChain)) {
            return false;
        }
        if (!this.enableAddIntoMainWhenSplitting && this.pageChainInSplitting(chainIndex)) {
            return false;
        }
        if (this.pageChainInCompacting(pageChain)) {
            return false;
        }
        if (this.cacheTooFull(((DataPageLRU.PageWithContext)hottestPage.f1).getFutureDataPage().getSize())) {
            LOG.warn("Can not add page into main cache because of cache is full.");
            return false;
        }
        if (((PageAddress)hottestPage.f0).hasDataPage()) {
            return false;
        }
        if (!this.pageInTheChain((PageAddress)hottestPage.f0, pageChain)) {
            this.gRegionContext.getGContext().getSupervisor().getFetchPolicy().getDataPageLRU().remove((PageAddress)hottestPage.f0);
            return false;
        }
        return true;
    }

    protected boolean pageChainInCompacting(LogicalPageChain pageChain) {
        return pageChain.getPageStatus().equals((Object)PageStatus.Compacting);
    }

    protected boolean pageChainInSplitting(int chainIndex) {
        int halfCapacity = this.pageIndex.getIndexCapacity() >> 1;
        if (chainIndex >= halfCapacity) {
            return false;
        }
        LogicalPageChain buddyPageChain = this.pageIndex.getLogicPage(chainIndex + halfCapacity);
        if (buddyPageChain == null) {
            return false;
        }
        return buddyPageChain.getPageStatus().equals((Object)PageStatus.Init);
    }

    protected boolean invalidRegion(GRegionID expectedRegionID, GRegionID actualRegionID) {
        return !expectedRegionID.equals(actualRegionID);
    }

    private boolean canAddHottestPageToPageStore(int chainIndex, PageContext hottestPageContext, LogicalPageChain logicalPageChain) {
        return !this.isPageChainChanged(chainIndex, hottestPageContext, logicalPageChain);
    }

    protected boolean isPageChainChanged(int chainIndex, PageContext hottestPageContext, LogicalPageChain logicalPageChain) {
        if (chainIndex >= this.pageIndex.getIndexCapacity()) {
            LOG.error("Received wrong chainIndex {}, current pageIndex capacity {}, hottest page region {}, current region {}.", new Object[]{chainIndex, this.pageIndex.getIndexCapacity(), hottestPageContext.getGRegionID(), this.gRegionContext.getRegionId()});
            return true;
        }
        return logicalPageChain.hashCode() != hottestPageContext.getLogicPageChainHashCode();
    }

    private boolean pageInTheChain(PageAddress expectedPageAddress, LogicalPageChain pageChain) {
        boolean founded = false;
        block0: for (int i = 0; !founded && i < pageChain.getCurrentPageChainIndex(); ++i) {
            Iterator<PageAddress> iter = pageChain.getPageAddress(i).pageIterator();
            while (iter.hasNext()) {
                PageAddress pageAddress = iter.next();
                Preconditions.checkState((boolean)(pageAddress instanceof PageAddressSingleImpl));
                if (!expectedPageAddress.equals(pageAddress)) continue;
                founded = true;
                continue block0;
            }
        }
        return founded;
    }

    protected Tuple2<PageAddress, DataPageLRU.PageWithContext> getHottestDataPageFromLRU() {
        return this.gContext.getSupervisor().getFetchPolicy().getDataPageLRU().getHottestPage(this.gRegionContext.getRegionId(), this.pageIndex);
    }

    @VisibleForTesting
    public CacheManager getCacheManager() {
        return this.cacheManager;
    }
}

