/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.gemini.engine.page;

import java.util.Map;
import java.util.Set;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.runtime.state.gemini.engine.GRegionContext;
import org.apache.flink.runtime.state.gemini.engine.memstore.GSValue;
import org.apache.flink.runtime.state.gemini.engine.page.PageIndexContext;
import org.apache.flink.runtime.state.gemini.engine.page.bmap.BinaryValue;
import org.apache.flink.runtime.state.gemini.engine.page.bmap.GBinaryHashMap;
import org.apache.flink.runtime.state.gemini.engine.page.compress.GCompressAlgorithm;
import org.apache.flink.runtime.state.gemini.engine.rm.Allocator;
import org.apache.flink.runtime.state.gemini.engine.rm.ReferenceCountable;
import org.apache.flink.runtime.state.gemini.engine.vm.EvictablePage;

public interface DataPage<K, V>
extends EvictablePage,
ReferenceCountable,
AutoCloseable {
    public int getCheckSum();

    public BinaryValue getBinaryValue(K var1);

    public GSValue<V> get(K var1);

    public boolean contains(K var1);

    public long getVersion();

    public DataPageType getDataPageType();

    public int getSize();

    public int getCount();

    public Map<K, GSValue<V>> getPOJOMap();

    public Set<K> getPOJOSet();

    public Tuple2<DataPage, DataPage> split(PageIndexContext var1, int var2, int var3, Allocator var4, GCompressAlgorithm var5, GRegionContext var6);

    public long getCompactionCount();

    public GBinaryHashMap<K> getGBinaryHashMap();

    public void setChainIndex(int var1);

    public int getChainIndex();

    @Override
    public void close();

    public static enum DataPageType {
        KV(1),
        KHashMap(2),
        KSortedMap(3),
        KList(4),
        KSplitHashRouting(5),
        KSplitSortedRouting(6),
        COMPRESS_HEADER(127);

        private final byte code;

        private DataPageType(byte c) {
            this.code = c;
        }

        public byte getCode() {
            return this.code;
        }

        public boolean isKMapType() {
            return this.code == DataPageType.KHashMap.code || this.code == DataPageType.KSortedMap.code;
        }

        public static DataPageType valueOf(byte pageType) {
            switch (pageType) {
                case 1: {
                    return KV;
                }
                case 2: {
                    return KHashMap;
                }
                case 3: {
                    return KSortedMap;
                }
                case 4: {
                    return KList;
                }
                case 5: {
                    return KSplitHashRouting;
                }
                case 6: {
                    return KSplitSortedRouting;
                }
            }
            throw new IllegalArgumentException("Unknown PageType: " + pageType);
        }
    }
}

