/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.gemini.engine.page;

import java.util.Map;
import java.util.Set;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.runtime.state.gemini.engine.GRegionContext;
import org.apache.flink.runtime.state.gemini.engine.exceptions.GeminiRuntimeException;
import org.apache.flink.runtime.state.gemini.engine.memstore.GSValue;
import org.apache.flink.runtime.state.gemini.engine.page.DataPage;
import org.apache.flink.runtime.state.gemini.engine.page.PageIndexContext;
import org.apache.flink.runtime.state.gemini.engine.page.bmap.BinaryValue;
import org.apache.flink.runtime.state.gemini.engine.page.bmap.GBinaryHashMap;
import org.apache.flink.runtime.state.gemini.engine.page.compress.GCompressAlgorithm;
import org.apache.flink.runtime.state.gemini.engine.rm.Allocator;
import org.apache.flink.runtime.state.gemini.engine.vm.HitRecord;

public abstract class DataPageAbstractSubPage<K, V>
implements DataPage<K, V> {
    protected final HitRecord hitRecord = new HitRecord();
    protected volatile short chainIndex = 0;

    @Override
    public abstract int getSize();

    @Override
    public abstract int getCheckSum();

    @Override
    public abstract GBinaryHashMap<K> getGBinaryHashMap();

    @Override
    public abstract void retain();

    @Override
    public abstract void release();

    @Override
    public abstract void close();

    @Override
    public BinaryValue getBinaryValue(K key) {
        throw new GeminiRuntimeException("Sub Page doesn't support this method");
    }

    @Override
    public GSValue<V> get(K key) {
        throw new GeminiRuntimeException("Sub Page doesn't support this method");
    }

    @Override
    public boolean contains(K key) {
        throw new GeminiRuntimeException("Sub Page doesn't support this method");
    }

    @Override
    public long getVersion() {
        throw new GeminiRuntimeException("Sub Page doesn't support this method");
    }

    @Override
    public DataPage.DataPageType getDataPageType() {
        throw new GeminiRuntimeException("Sub Page doesn't support this method");
    }

    @Override
    public int getCount() {
        throw new GeminiRuntimeException("Sub Page doesn't support this method");
    }

    @Override
    public Map<K, GSValue<V>> getPOJOMap() {
        throw new GeminiRuntimeException("Sub Page doesn't support this method");
    }

    @Override
    public Set<K> getPOJOSet() {
        throw new GeminiRuntimeException("Sub Page doesn't support this method");
    }

    @Override
    public Tuple2<DataPage, DataPage> split(PageIndexContext indexContext, int curBucketNum, int curIndex, Allocator allocator, GCompressAlgorithm gCompressAlgorithm, GRegionContext gRegionContext) {
        throw new GeminiRuntimeException("Sub Page doesn't support this method");
    }

    @Override
    public long getCompactionCount() {
        throw new GeminiRuntimeException("Sub Page doesn't support this method");
    }

    @Override
    public void setChainIndex(int index) {
        this.chainIndex = (short)index;
    }

    @Override
    public int getChainIndex() {
        return this.chainIndex;
    }

    @Override
    public void addRequestCount(long tickTime, int requestCount) {
        this.hitRecord.addRequestCount(tickTime, requestCount);
    }

    @Override
    public double score(long tickTime) {
        return this.hitRecord.score(tickTime, this.getSize(), this.getChainIndex());
    }

    @Override
    public long getRequestCount(long tickTime) {
        return this.hitRecord.getRequestCount(tickTime);
    }
}

