/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.gemini.engine.page;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.runtime.state.gemini.engine.GRegionContext;
import org.apache.flink.runtime.state.gemini.engine.exceptions.GeminiRuntimeException;
import org.apache.flink.runtime.state.gemini.engine.filter.StateFilter;
import org.apache.flink.runtime.state.gemini.engine.memstore.GSValue;
import org.apache.flink.runtime.state.gemini.engine.page.DataPage;
import org.apache.flink.runtime.state.gemini.engine.page.DataPageHashSubPageImpl;
import org.apache.flink.runtime.state.gemini.engine.page.DataPageKMap;
import org.apache.flink.runtime.state.gemini.engine.page.DataPageKVImpl;
import org.apache.flink.runtime.state.gemini.engine.page.GValueType;
import org.apache.flink.runtime.state.gemini.engine.page.PageAddress;
import org.apache.flink.runtime.state.gemini.engine.page.PageSerdeFlink2Key;
import org.apache.flink.runtime.state.gemini.engine.page.bmap.BinaryKey;
import org.apache.flink.runtime.state.gemini.engine.page.bmap.BinaryValue;
import org.apache.flink.runtime.state.gemini.engine.page.bmap.BinaryValueForSplit;
import org.apache.flink.runtime.state.gemini.engine.page.bmap.BinaryValueImpl;
import org.apache.flink.runtime.state.gemini.engine.page.bmap.ByteBufferDataInputView;
import org.apache.flink.runtime.state.gemini.engine.page.bmap.GBinaryHashMap;
import org.apache.flink.runtime.state.gemini.engine.page.bmap.GBinarySplitHashMap;
import org.apache.flink.runtime.state.gemini.engine.page.bmap.GBufferAddressMapping;
import org.apache.flink.runtime.state.gemini.engine.page.bmap.GHashRoutingValue;
import org.apache.flink.runtime.state.gemini.engine.page.bmap.SplitHashMapValueHelper;
import org.apache.flink.runtime.state.gemini.engine.rm.Allocator;
import org.apache.flink.runtime.state.gemini.engine.rm.GByteBuffer;
import org.apache.flink.runtime.state.gemini.engine.rm.GUnPooledByteBuffer;
import org.apache.flink.util.MathUtils;
import org.apache.flink.util.Preconditions;

public class DataPageKMapImpl<K, MK, MV>
extends DataPageKVImpl<K, Map<MK, GSValue<MV>>>
implements DataPageKMap<K, MK, MV> {
    protected final TypeSerializer<MK> mkTypeSerializer;
    protected final TypeSerializer<MV> mvTypeSerializer;

    public DataPageKMapImpl(GBinaryHashMap<K> gBinaryHashMap, TypeSerializer<MK> mkTypeSerializer, TypeSerializer<MV> mvTypeSerializer, TypeSerializer<Map<MK, GSValue<MV>>> gMapTypeSerializer) {
        super(gBinaryHashMap, gMapTypeSerializer);
        this.mkTypeSerializer = mkTypeSerializer;
        this.mvTypeSerializer = mvTypeSerializer;
    }

    @Override
    public GSValue<MV> get(K key, MK mapKey) {
        try {
            BinaryValue binaryValue = this.gBinaryHashMap.get(key);
            if (binaryValue == null) {
                return null;
            }
            if (binaryValue.getGValueType() == GValueType.Delete) {
                return new GSValue<Object>(null, binaryValue.getGValueType(), binaryValue.getSeqID());
            }
            GSValue<MV> result = this.getForMapBinaryValue(this.getBinaryMapByBinaryValue(binaryValue, mapKey), mapKey);
            if (result == null && binaryValue.getGValueType() == GValueType.PutMap) {
                return new GSValue<Object>(null, binaryValue.getGValueType(), binaryValue.getSeqID());
            }
            return result;
        }
        catch (Exception e) {
            throw new GeminiRuntimeException("get exception: " + e.getMessage(), e);
        }
    }

    protected Map<MK, BinaryValue> getBinaryMapByBinaryValue(BinaryValue binaryValue, MK mapKey) {
        Map<MK, BinaryValue> binaryMap;
        if (GHashRoutingValue.isGHashRoutingValue(binaryValue)) {
            Preconditions.checkState((boolean)(this.gBinaryHashMap instanceof GBinarySplitHashMap), (Object)"Internal bug.");
            binaryMap = GHashRoutingValue.getSubGBinaryHashMap(binaryValue, mapKey, this.mkTypeSerializer);
        } else {
            binaryMap = this.getBinaryMap(DataPageKMapImpl.getDuplicateBB(binaryValue));
        }
        return binaryMap;
    }

    @Override
    public GSValue<Map<MK, GSValue<MV>>> get(K key) {
        try {
            BinaryValue binaryValue = this.gBinaryHashMap.get(key);
            if (binaryValue == null) {
                return null;
            }
            if (binaryValue.getGValueType() == GValueType.Delete) {
                return new GSValue<Object>(null, GValueType.Delete, binaryValue.getSeqID());
            }
            Map<MK, GSValue<MV>> value = this.getMap(binaryValue);
            return new GSValue<Map<MK, GSValue<MV>>>(value, binaryValue.getGValueType(), binaryValue.getSeqID());
        }
        catch (Exception e) {
            throw new GeminiRuntimeException("get exception: " + e.getMessage(), e);
        }
    }

    protected Map<MK, GSValue<MV>> getMap(BinaryValue binaryValue) throws IOException {
        Map value = new HashMap();
        if (GHashRoutingValue.isGHashRoutingValue(binaryValue)) {
            List<GBinaryHashMap<MK>> subMapList = GHashRoutingValue.getAllSubGBinaryHashMap(binaryValue, this.mkTypeSerializer);
            for (GBinaryHashMap<MK> subMap : subMapList) {
                ByteBufferDataInputView byteBufferDataInputView = new ByteBufferDataInputView(subMap.getData(), 0, subMap.bytesSize());
                value.putAll((Map)this.valueTypeSerializer.deserialize((DataInputView)byteBufferDataInputView));
            }
        } else {
            ByteBufferDataInputView byteBufferDataInputView = new ByteBufferDataInputView(binaryValue.getBb(), binaryValue.getValueOffset(), binaryValue.getValueLen());
            value = (Map)this.valueTypeSerializer.deserialize((DataInputView)byteBufferDataInputView);
        }
        return value;
    }

    protected GSValue<MV> getForMapBinaryValue(Map<MK, BinaryValue> mapValueMap, MK mapKey) {
        if (mapValueMap == null) {
            return null;
        }
        return this.getForBinaryValue(mapValueMap.get(mapKey));
    }

    protected GSValue<MV> getForBinaryValue(BinaryValue mvBinary) {
        try {
            if (mvBinary == null) {
                return null;
            }
            if (mvBinary.getGValueType() == GValueType.Delete) {
                return new GSValue<Object>(null, mvBinary.getGValueType(), mvBinary.getSeqID());
            }
            ByteBufferDataInputView byteBufferDataInputView = new ByteBufferDataInputView(mvBinary.getBb(), mvBinary.getValueOffset(), mvBinary.getValueLen());
            Object value = this.mvTypeSerializer.deserialize((DataInputView)byteBufferDataInputView);
            return new GSValue<Object>(value, mvBinary.getGValueType(), mvBinary.getSeqID());
        }
        catch (Exception e) {
            throw new GeminiRuntimeException("getForBinaryValue has Exception:" + e.getMessage(), e);
        }
    }

    protected static GByteBuffer getDuplicateBB(BinaryValue binaryValue) {
        if (binaryValue.getValueLen() == 0) {
            return null;
        }
        ByteBuffer duplicateByteBuffer = binaryValue.getBb().duplicate();
        duplicateByteBuffer.limit(binaryValue.getValueLen() + binaryValue.getValueOffset());
        duplicateByteBuffer.position(binaryValue.getValueOffset());
        return new GUnPooledByteBuffer(duplicateByteBuffer.slice());
    }

    protected Map<MK, BinaryValue> getBinaryMap(GByteBuffer valueBB) {
        return new GBinaryHashMap<MK>(valueBB, this.mkTypeSerializer);
    }

    @Override
    public boolean contains(K key, MK mapKey) {
        GSValue<MV> mvResult = this.get(key, mapKey);
        return mvResult != null && mvResult.getValue() != null;
    }

    @Override
    public DataPage.DataPageType getDataPageType() {
        return DataPage.DataPageType.KHashMap;
    }

    public static <MK, MV> BinaryValue doCompactionMapValue(List<BinaryValue> valueByOrder, TypeSerializer<MK> mkTypeSerializer, TypeSerializer<MV> mvTypeSerializer, boolean isMajor, long version, int logicPageId, Allocator allocator, @Nullable StateFilter stateFilter, @Nullable GRegionContext gRegionContext, GBufferAddressMapping pageMapping, boolean allowMapSplit, int mapSplitSizeThreshold, int mapSplitSubMapSize) {
        if (allowMapSplit) {
            int maxSplitPartNum = 1;
            for (BinaryValue binaryValue : valueByOrder) {
                if (binaryValue.getGValueType() == GValueType.Delete) continue;
                if (GHashRoutingValue.isGHashRoutingValue(binaryValue)) {
                    int subMapCount = GHashRoutingValue.getSubMapCount(binaryValue);
                    int subMapMaxSize = GHashRoutingValue.getSubMapMaxSize(binaryValue);
                    if (subMapMaxSize > mapSplitSizeThreshold) {
                        subMapCount <<= 1;
                    }
                    maxSplitPartNum = Math.max(subMapCount, maxSplitPartNum);
                    continue;
                }
                if (binaryValue.getValueLen() <= mapSplitSizeThreshold) continue;
                int splitNum = binaryValue.getValueLen() / mapSplitSubMapSize + (binaryValue.getValueLen() % mapSplitSubMapSize == 0 ? 0 : 1);
                maxSplitPartNum = Math.max(MathUtils.roundUpToPowerOfTwo((int)splitNum), maxSplitPartNum);
            }
            if (maxSplitPartNum > 1) {
                return DataPageKMapImpl.doCompactionMapValueForSplit(valueByOrder, mkTypeSerializer, mvTypeSerializer, isMajor, version, logicPageId, allocator, stateFilter, gRegionContext, pageMapping, maxSplitPartNum);
            }
        }
        return DataPageKMapImpl.doCompactionMapValueNormal(valueByOrder, mkTypeSerializer, mvTypeSerializer, isMajor, version, logicPageId, allocator, stateFilter, gRegionContext);
    }

    private static <MK, MV> BinaryValue doCompactionMapValueNormal(List<BinaryValue> valueByOrder, TypeSerializer<MK> mkTypeSerializer, TypeSerializer<MV> mvTypeSerializer, boolean isMajor, long version, int logicPageId, Allocator allocator, @Nullable StateFilter stateFilter, @Nullable GRegionContext gRegionContext) {
        try {
            GBinaryHashMap<MK> gBinaryHashMap;
            if (valueByOrder.size() == 1 && !isMajor) {
                return valueByOrder.get(0);
            }
            ArrayList<GBinaryHashMap<MK>> listByOrder = new ArrayList<GBinaryHashMap<MK>>();
            long seqID = 0L;
            GValueType firstValueType = null;
            for (BinaryValue binaryValue : valueByOrder) {
                if (binaryValue.getGValueType() == GValueType.Delete) {
                    firstValueType = GValueType.Delete;
                    continue;
                }
                GBinaryHashMap<MK> mapValue = new GBinaryHashMap<MK>(DataPageKMapImpl.getDuplicateBB(binaryValue), mkTypeSerializer);
                seqID = Math.max(seqID, binaryValue.getSeqID());
                listByOrder.add(mapValue);
                if (firstValueType != null) continue;
                firstValueType = binaryValue.getGValueType();
            }
            if (listByOrder.size() == 0) {
                gBinaryHashMap = GBinaryHashMap.EMPTY_G_BINARY_HASHMAP;
            } else {
                int index = 0;
                Map<BinaryKey, BinaryValue> newMap = ((GBinaryHashMap)listByOrder.get(index)).getBinaryMap();
                long compactionCount = ((GBinaryHashMap)listByOrder.get(index)).getCompactionCount();
                ++index;
                while (index < listByOrder.size()) {
                    newMap.putAll(((GBinaryHashMap)listByOrder.get(index)).getBinaryMap());
                    compactionCount += ((GBinaryHashMap)listByOrder.get(index)).getCompactionCount();
                    ++index;
                }
                gBinaryHashMap = GBinaryHashMap.ofBinaryMap(DataPage.DataPageType.KV, isMajor, version, logicPageId, mkTypeSerializer, allocator, newMap, compactionCount, stateFilter, gRegionContext);
            }
            ByteBuffer bb = gBinaryHashMap == GBinaryHashMap.EMPTY_G_BINARY_HASHMAP ? null : gBinaryHashMap.getData();
            GValueType gValueType = DataPageKMapImpl.judgeFinalValueType(bb, firstValueType, isMajor);
            return new BinaryValueImpl(bb, gValueType, seqID, 0, gBinaryHashMap.bytesSize());
        }
        catch (Exception e) {
            throw new GeminiRuntimeException("Internal BUG " + e.getMessage(), e);
        }
    }

    @VisibleForTesting
    public static <MK, MV> BinaryValue doCompactionMapValueForSplit(List<BinaryValue> valueByOrder, TypeSerializer<MK> mkTypeSerializer, TypeSerializer<MV> mvTypeSerializer, boolean isMajor, long version, int logicPageId, Allocator allocator, @Nullable StateFilter stateFilter, @Nullable GRegionContext gRegionContext, GBufferAddressMapping pageMapping, int maxSplitPartNum) {
        GByteBuffer finalByteBuffer;
        Preconditions.checkState((maxSplitPartNum > 1 ? 1 : 0) != 0);
        Preconditions.checkArgument((MathUtils.roundDownToPowerOf2((int)maxSplitPartNum) == maxSplitPartNum ? 1 : 0) != 0);
        if (valueByOrder.size() == 1 && !isMajor) {
            BinaryValue binaryValue = valueByOrder.get(0);
            if (GHashRoutingValue.isGHashRoutingValue(binaryValue)) {
                GByteBuffer gByteBuffer = SplitHashMapValueHelper.replaceBinaryValueIdList((BinaryValueForSplit)binaryValue, pageMapping);
                return new BinaryValueImpl(gByteBuffer.getByteBuffer(), binaryValue.getGValueType(), binaryValue.getSeqID(), 0, gByteBuffer.capacity());
            }
            return valueByOrder.get(0);
        }
        ArrayList<BinaryValue> listByOrder = new ArrayList<BinaryValue>();
        long seqID = 0L;
        GValueType firstValueType = null;
        for (BinaryValue binaryValue : valueByOrder) {
            if (binaryValue.getGValueType() == GValueType.Delete) {
                firstValueType = GValueType.Delete;
                continue;
            }
            if (binaryValue.getBb() == null) continue;
            seqID = Math.max(seqID, binaryValue.getSeqID());
            listByOrder.add(binaryValue);
            if (firstValueType != null) continue;
            firstValueType = binaryValue.getGValueType();
        }
        if (listByOrder.size() == 0) {
            finalByteBuffer = null;
        } else {
            Map[][] buckets = new Map[listByOrder.size()][maxSplitPartNum];
            int[] subMapIdList = new int[maxSplitPartNum];
            int subMapMaxSize = 0;
            LinkedList<Integer> indexList = new LinkedList<Integer>();
            indexList.add(0);
            int firstSubMapSize = DataPageKMapImpl.mergeSubList(0, listByOrder, buckets, mkTypeSerializer, mvTypeSerializer, isMajor, version, logicPageId, allocator, stateFilter, gRegionContext, pageMapping, subMapIdList);
            subMapMaxSize = Math.max(firstSubMapSize, subMapMaxSize);
            for (int stepSize = maxSplitPartNum >> 1; stepSize > 0 && indexList.size() < maxSplitPartNum; stepSize >>= 1) {
                LinkedList<Integer> newIndex = new LinkedList<Integer>();
                for (Integer index : indexList) {
                    int subMapSize = DataPageKMapImpl.mergeSubList(index + stepSize, listByOrder, buckets, mkTypeSerializer, mvTypeSerializer, isMajor, version, logicPageId, allocator, stateFilter, gRegionContext, pageMapping, subMapIdList);
                    subMapMaxSize = Math.max(subMapSize, subMapMaxSize);
                    newIndex.add(index + stepSize);
                }
                indexList.addAll(newIndex);
            }
            finalByteBuffer = SplitHashMapValueHelper.genRoutingValueForSplitHashMap(subMapIdList, logicPageId, allocator, subMapMaxSize);
        }
        ByteBuffer bb = finalByteBuffer == null ? null : finalByteBuffer.getByteBuffer();
        GValueType gValueType = DataPageKMapImpl.judgeFinalValueType(bb, firstValueType, isMajor);
        return new BinaryValueImpl(bb, gValueType, seqID, 0, bb == null ? 0 : bb.capacity());
    }

    private static <MK, MV> int mergeSubList(int partIndex, List<BinaryValue> listByOrder, Map<BinaryKey, BinaryValue>[][] buckets, TypeSerializer<MK> mkTypeSerializer, TypeSerializer<MV> mvTypeSerializer, boolean isMajor, long version, int logicPageId, Allocator allocator, @Nullable StateFilter stateFilter, @Nullable GRegionContext gRegionContext, GBufferAddressMapping mapping, int[] subMapIdList) {
        int subMapSize;
        int subMapId;
        int compactionCount = 0;
        HashMap<BinaryKey, BinaryValue> subCompactionMap = new HashMap<BinaryKey, BinaryValue>();
        PageAddress tmpPageAddress = null;
        GBufferAddressMapping tmpMapping = null;
        for (int i = 0; i < listByOrder.size(); ++i) {
            BinaryValue binaryValue = listByOrder.get(i);
            if (GHashRoutingValue.isGHashRoutingValue(binaryValue)) {
                int maxSplitNum = subMapIdList.length;
                int subMapCount = GHashRoutingValue.getSubMapCount(binaryValue);
                if (subMapCount == maxSplitNum && tmpPageAddress == null && subCompactionMap.isEmpty()) {
                    tmpPageAddress = GHashRoutingValue.getSubMapPageAddress(partIndex, binaryValue);
                    tmpMapping = binaryValue.getPageMapping();
                    continue;
                }
                if (partIndex < GHashRoutingValue.getSubMapCount(binaryValue)) {
                    GBinaryHashMap<Object> subMap = GHashRoutingValue.getSubGBinaryHashMapWithKey(null, partIndex, binaryValue, mkTypeSerializer);
                    compactionCount = (int)((long)compactionCount + subMap.getCompactionCount());
                    DataPageKMapImpl.divideBinaryMapToBuckets(subMap.getBinaryMap(), buckets[i]);
                }
            } else if (partIndex == 0) {
                GBinaryHashMap<MK> gBinaryHashMap = new GBinaryHashMap<MK>(DataPageKMapImpl.getDuplicateBB(binaryValue), mkTypeSerializer);
                compactionCount = (int)((long)compactionCount + gBinaryHashMap.getCompactionCount());
                Map<BinaryKey, BinaryValue> normalMap = gBinaryHashMap.getBinaryMap();
                DataPageKMapImpl.divideBinaryMapToBuckets(normalMap, buckets[i]);
            }
            if (buckets[i][partIndex] == null) continue;
            if (tmpPageAddress != null && subCompactionMap.isEmpty()) {
                subCompactionMap.putAll(DataPageKMapImpl.getBinaryMap(tmpPageAddress, tmpMapping, mkTypeSerializer));
            }
            subCompactionMap.putAll(buckets[i][partIndex]);
        }
        if (subCompactionMap.isEmpty() && tmpPageAddress != null) {
            subMapId = mapping.putGByteBufferAddress(tmpPageAddress);
            subMapSize = tmpPageAddress.getDataLen();
        } else {
            GBinaryHashMap<MK> subMap = GBinaryHashMap.ofBinaryMap(DataPage.DataPageType.KV, isMajor, version, logicPageId, mkTypeSerializer, allocator, subCompactionMap, compactionCount, stateFilter, gRegionContext);
            subMapId = mapping.putGByteBufferAddress(new DataPageHashSubPageImpl(subMap));
            subMapSize = subMap.bytesSize();
        }
        subMapIdList[partIndex] = subMapId;
        for (int i = 0; i < listByOrder.size(); ++i) {
            buckets[i][partIndex] = null;
        }
        return subMapSize;
    }

    private static <MK> Map<BinaryKey, BinaryValue> getBinaryMap(PageAddress subMapPageAddress, GBufferAddressMapping pageMapping, TypeSerializer<MK> mkTypeSerializer) {
        GByteBuffer gByteBuffer = pageMapping.getGByteBuffer(subMapPageAddress, null);
        if (gByteBuffer == null) {
            return new HashMap<BinaryKey, BinaryValue>();
        }
        GBinaryHashMap<MK> gBinaryHashMap = new GBinaryHashMap<MK>(gByteBuffer, mkTypeSerializer);
        return gBinaryHashMap.getBinaryMap();
    }

    private static void divideBinaryMapToBuckets(Map<BinaryKey, BinaryValue> binaryMap, Map<BinaryKey, BinaryValue>[] bucket) {
        for (Map.Entry<BinaryKey, BinaryValue> entry : binaryMap.entrySet()) {
            int index = entry.getKey().hashCode() & bucket.length - 1;
            if (bucket[index] == null) {
                bucket[index] = new HashMap<BinaryKey, BinaryValue>();
            }
            bucket[index].put(entry.getKey(), entry.getValue());
        }
    }

    static GValueType judgeFinalValueType(ByteBuffer bb, GValueType firstValueType, boolean isMajor) {
        if (bb == null) {
            return GValueType.Delete;
        }
        if (firstValueType == GValueType.Delete) {
            return GValueType.PutMap;
        }
        return firstValueType;
    }

    protected static <MK> Map<BinaryKey, BinaryValue> doCompactValueToBinaryMap(List<BinaryValue> binaryValueReversedOrderList, TypeSerializer<MK> mkTypeSerializer) {
        try {
            HashMap<BinaryKey, BinaryValue> newMap = new HashMap<BinaryKey, BinaryValue>();
            for (int i = binaryValueReversedOrderList.size() - 1; i >= 0; --i) {
                BinaryValue binaryValue = binaryValueReversedOrderList.get(i);
                if (GHashRoutingValue.isGHashRoutingValue(binaryValue)) {
                    List<GBinaryHashMap<MK>> subMapList = GHashRoutingValue.getAllSubGBinaryHashMap(binaryValue, mkTypeSerializer);
                    for (GBinaryHashMap<MK> subMap : subMapList) {
                        newMap.putAll(subMap.getBinaryMap());
                    }
                    continue;
                }
                GBinaryHashMap<MK> mapValue = new GBinaryHashMap<MK>(DataPageKMapImpl.getDuplicateBB(binaryValue), mkTypeSerializer);
                newMap.putAll(mapValue.getBinaryMap());
            }
            return newMap;
        }
        catch (Exception e) {
            throw new GeminiRuntimeException("Internal BUG " + e.getMessage(), e);
        }
    }

    public static <K, MK, MV> DataPageKMapImpl<K, MK, MV> readKMapPageFrom(PageSerdeFlink2Key<K, MK, MV> pageSerdeFlink, GByteBuffer dataPage, int crc) {
        GBinaryHashMap gBinaryHashMap = new GBinaryHashMap(dataPage, pageSerdeFlink.getKeySerde(), crc);
        return new DataPageKMapImpl(gBinaryHashMap, pageSerdeFlink.getKey2Serde(), pageSerdeFlink.getValueSerde(), pageSerdeFlink.getMapValueTypeSerializer());
    }

    @Override
    public Tuple2<DataPage, DataPage> getSplitDataByGBinaryMap(GBinaryHashMap<K> gBinaryHashMap1, GBinaryHashMap<K> gBinaryHashMap2) {
        DataPageKMapImpl<K, MK, MV> dataPage1 = gBinaryHashMap1 == GBinaryHashMap.EMPTY_G_BINARY_HASHMAP ? null : new DataPageKMapImpl<K, MK, MV>(gBinaryHashMap1, this.mkTypeSerializer, this.mvTypeSerializer, this.valueTypeSerializer);
        DataPageKMapImpl<K, MK, MV> dataPage2 = gBinaryHashMap2 == GBinaryHashMap.EMPTY_G_BINARY_HASHMAP ? null : new DataPageKMapImpl<K, MK, MV>(gBinaryHashMap2, this.mkTypeSerializer, this.mvTypeSerializer, this.valueTypeSerializer);
        return Tuple2.of(dataPage1, (Object)dataPage2);
    }
}

