/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.gemini.engine.page;

import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.runtime.state.gemini.engine.GRegionContext;
import org.apache.flink.runtime.state.gemini.engine.exceptions.GeminiRuntimeException;
import org.apache.flink.runtime.state.gemini.engine.memstore.GSValue;
import org.apache.flink.runtime.state.gemini.engine.page.DataPage;
import org.apache.flink.runtime.state.gemini.engine.page.GValueType;
import org.apache.flink.runtime.state.gemini.engine.page.PageIndexContext;
import org.apache.flink.runtime.state.gemini.engine.page.PageSerdeFlink;
import org.apache.flink.runtime.state.gemini.engine.page.bmap.BinaryKey;
import org.apache.flink.runtime.state.gemini.engine.page.bmap.BinaryValue;
import org.apache.flink.runtime.state.gemini.engine.page.bmap.ByteBufferDataInputView;
import org.apache.flink.runtime.state.gemini.engine.page.bmap.GBinaryHashMap;
import org.apache.flink.runtime.state.gemini.engine.page.compress.GCompressAlgorithm;
import org.apache.flink.runtime.state.gemini.engine.rm.Allocator;
import org.apache.flink.runtime.state.gemini.engine.rm.GByteBuffer;
import org.apache.flink.runtime.state.gemini.engine.vm.HitRecord;
import org.apache.flink.util.MathUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataPageKVImpl<K, V>
implements DataPage<K, V> {
    private static final Logger LOG = LoggerFactory.getLogger(DataPageKVImpl.class);
    protected final TypeSerializer<V> valueTypeSerializer;
    protected final GBinaryHashMap<K> gBinaryHashMap;
    protected final HitRecord hitRecord = new HitRecord();
    protected volatile short chainIndex = 0;

    public DataPageKVImpl(GBinaryHashMap<K> gBinaryHashMap, TypeSerializer<V> valueTypeSerializer) {
        this.gBinaryHashMap = gBinaryHashMap;
        this.valueTypeSerializer = valueTypeSerializer;
        if (gBinaryHashMap.getGByteBuffer() != null) {
            gBinaryHashMap.getGByteBuffer().setWaitSeqId();
        }
    }

    @Override
    public void retain() {
        if (this.gBinaryHashMap != null) {
            this.gBinaryHashMap.retain();
        }
    }

    @Override
    public void release() {
        if (this.gBinaryHashMap != null) {
            this.gBinaryHashMap.release();
        }
    }

    @Override
    public int refCnt() {
        return this.gBinaryHashMap.refCnt();
    }

    @Override
    public void close() {
        this.release();
    }

    @Override
    public int getCheckSum() {
        return this.gBinaryHashMap == null ? 0 : this.gBinaryHashMap.getOriginChecksum();
    }

    @Override
    public BinaryValue getBinaryValue(K key) {
        try {
            BinaryValue binaryValue = this.gBinaryHashMap.get(key);
            if (binaryValue == null) {
                return null;
            }
            return binaryValue;
        }
        catch (Exception e) {
            throw new GeminiRuntimeException("get exception: " + e.getMessage(), e);
        }
    }

    @Override
    public GSValue<V> get(K key) {
        try {
            BinaryValue binaryValue = this.gBinaryHashMap.get(key);
            if (binaryValue == null) {
                return null;
            }
            if (binaryValue.getGValueType() == GValueType.Delete) {
                return new GSValue<Object>(null, GValueType.Delete, binaryValue.getSeqID());
            }
            ByteBufferDataInputView byteBufferDataInputView = new ByteBufferDataInputView(binaryValue.getBb(), binaryValue.getValueOffset(), binaryValue.getValueLen());
            Object value = this.valueTypeSerializer.deserialize((DataInputView)byteBufferDataInputView);
            return new GSValue<Object>(value, binaryValue.getGValueType(), binaryValue.getSeqID());
        }
        catch (Exception e) {
            throw new GeminiRuntimeException("get exception: " + e.getMessage(), e);
        }
    }

    @Override
    public boolean contains(K key) {
        GSValue<V> result = this.get(key);
        return result != null && result.getValue() != null;
    }

    @Override
    public long getVersion() {
        return this.gBinaryHashMap.getVersion();
    }

    @Override
    public DataPage.DataPageType getDataPageType() {
        return DataPage.DataPageType.KV;
    }

    @Override
    public int getSize() {
        return this.gBinaryHashMap.bytesSize();
    }

    @Override
    public int getCount() {
        return this.gBinaryHashMap.keyCount();
    }

    @Override
    public Map<K, GSValue<V>> getPOJOMap() {
        return this.gBinaryHashMap.toPOJOMap(this.valueTypeSerializer);
    }

    @Override
    public Set<K> getPOJOSet() {
        return this.gBinaryHashMap.toPOJOSet();
    }

    @Override
    public Tuple2<DataPage, DataPage> split(PageIndexContext indexContext, int curBucketNum, int curIndex, Allocator allocator, GCompressAlgorithm gCompressAlgorithm, GRegionContext gRegionContext) {
        Map<BinaryKey, BinaryValue> binaryMap = this.gBinaryHashMap.getBinaryMap();
        ArrayList<Tuple2<BinaryKey, BinaryValue>> list1 = new ArrayList<Tuple2<BinaryKey, BinaryValue>>();
        ArrayList<Tuple2<BinaryKey, BinaryValue>> list2 = new ArrayList<Tuple2<BinaryKey, BinaryValue>>();
        for (Map.Entry<BinaryKey, BinaryValue> entry : binaryMap.entrySet()) {
            int checkBucketNum;
            int hash = MathUtils.bitMix((int)entry.getKey().hashCode());
            int index = hash & (checkBucketNum = curBucketNum << 1) - 1 - curIndex;
            if (index == 0) {
                list1.add((Tuple2<BinaryKey, BinaryValue>)Tuple2.of((Object)entry.getKey(), (Object)entry.getValue()));
                continue;
            }
            list2.add(Tuple2.of((Object)entry.getKey(), (Object)entry.getValue()));
        }
        long version = this.getVersion();
        long compactionCount = this.getCompactionCount();
        int logicPageId = this.gBinaryHashMap.getLogicPageId();
        TypeSerializer<K> keySerializer = this.gBinaryHashMap.getKeyTypeSerializer();
        GBinaryHashMap<K> gBinaryHashMap1 = GBinaryHashMap.ofBinaryList(-1, -1, this.getDataPageType(), list1, keySerializer, version, logicPageId, allocator, compactionCount, gCompressAlgorithm, gRegionContext);
        GBinaryHashMap<K> gBinaryHashMap2 = GBinaryHashMap.ofBinaryList(-1, -1, this.getDataPageType(), list2, keySerializer, version, logicPageId + curBucketNum, allocator, compactionCount, gCompressAlgorithm, gRegionContext);
        return this.getSplitDataByGBinaryMap(gBinaryHashMap1, gBinaryHashMap2);
    }

    public Tuple2<DataPage, DataPage> getSplitDataByGBinaryMap(GBinaryHashMap<K> gBinaryHashMap1, GBinaryHashMap<K> gBinaryHashMap2) {
        DataPageKVImpl<K, V> dataPage1 = gBinaryHashMap1 == GBinaryHashMap.EMPTY_G_BINARY_HASHMAP ? null : new DataPageKVImpl<K, V>(gBinaryHashMap1, this.valueTypeSerializer);
        DataPageKVImpl<K, V> dataPage2 = gBinaryHashMap2 == GBinaryHashMap.EMPTY_G_BINARY_HASHMAP ? null : new DataPageKVImpl<K, V>(gBinaryHashMap2, this.valueTypeSerializer);
        return Tuple2.of(dataPage1, (Object)dataPage2);
    }

    @Override
    public long getCompactionCount() {
        return this.gBinaryHashMap.getCompactionCount();
    }

    @Override
    public GBinaryHashMap<K> getGBinaryHashMap() {
        return this.gBinaryHashMap;
    }

    @Override
    public void setChainIndex(int index) {
        this.chainIndex = (short)index;
    }

    @Override
    public int getChainIndex() {
        return this.chainIndex;
    }

    public static <K, V> DataPageKVImpl<K, V> readKVPageFrom(PageSerdeFlink<K, V> pageSerdeFlink, GByteBuffer dataPage, int crc) {
        GBinaryHashMap<K> gBinaryHashMap = new GBinaryHashMap<K>(dataPage, pageSerdeFlink.getKeySerde(), crc);
        return new DataPageKVImpl<K, V>(gBinaryHashMap, pageSerdeFlink.getValueSerde());
    }

    @Override
    public void addRequestCount(long tickTime, int i) {
        this.hitRecord.addRequestCount(tickTime, i);
    }

    @Override
    public double score(long tickTime) {
        return this.hitRecord.score(tickTime, this.getSize(), this.getChainIndex());
    }

    @Override
    public long getRequestCount(long tickTime) {
        return this.hitRecord.getRequestCount(tickTime);
    }
}

