/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.gemini.engine.page;

import java.nio.ByteBuffer;
import java.util.zip.CRC32;
import org.apache.flink.runtime.state.gemini.engine.exceptions.GeminiRuntimeException;
import org.apache.flink.runtime.state.gemini.engine.fs.FileReader;
import org.apache.flink.runtime.state.gemini.engine.page.AbstractDataPageUtil;
import org.apache.flink.runtime.state.gemini.engine.page.PageAddress;
import org.apache.flink.runtime.state.gemini.engine.page.compress.GCompressAlgorithm;
import org.apache.flink.runtime.state.gemini.engine.page.compress.GCompressHeaderHelper;
import org.apache.flink.runtime.state.gemini.engine.rm.GByteBuffer;
import org.apache.flink.runtime.state.gemini.engine.rm.GUnPooledByteBuffer;

public class DfsDataPageUtil
extends AbstractDataPageUtil {
    public DfsDataPageUtil(boolean enableChecksum) {
        super(enableChecksum);
    }

    @Override
    public GByteBuffer getDataPageFromReader(FileReader reader, int offsetInFile, PageAddress pageAddress) {
        try {
            int firstReadLength = 16;
            byte[] header = new byte[firstReadLength];
            reader.read(offsetInFile, header, 0, firstReadLength);
            byte[] pageData = new byte[pageAddress.getDataLen()];
            if (GCompressHeaderHelper.isPageCompressed(header)) {
                GCompressHeaderHelper.checkMagicNumber(header);
                GCompressAlgorithm algorithm = GCompressHeaderHelper.readCompressAlgorithm(header);
                int pageHeaderLength = 64;
                int pageHeaderOffset = offsetInFile + 16;
                reader.read(pageHeaderOffset, pageData, 0, pageHeaderLength);
                int diskLength = GCompressHeaderHelper.readDiskLength(header);
                byte[] compressed = new byte[diskLength];
                int rawPageDataOffset = pageHeaderOffset + 64;
                reader.read(rawPageDataOffset, compressed, 0, compressed.length);
                algorithm.getCompressorCodec().decompress(compressed, 0, compressed.length, pageData, pageHeaderLength);
            } else {
                System.arraycopy(header, 0, pageData, 0, firstReadLength);
                reader.read(offsetInFile + firstReadLength, pageData, firstReadLength, pageAddress.getDataLen() - firstReadLength);
            }
            if (this.enableChecksum) {
                CRC32 crc32 = new CRC32();
                crc32.update(pageData);
                int crc = (int)crc32.getValue();
                if (crc != pageAddress.getChecksum()) {
                    throw new GeminiRuntimeException("checkSum fail, " + pageAddress + " when reading from file=" + reader.getFileMeta() + " ,expected=" + pageAddress.getChecksum() + " ,now=" + crc);
                }
            }
            return new GUnPooledByteBuffer(ByteBuffer.wrap(pageData));
        }
        catch (Exception e) {
            LOG.error("DfsUtil PageAddress:{}", (Object)(pageAddress + " => " + e + " reader=>" + reader.getFileMeta()));
            throw new GeminiRuntimeException(e);
        }
    }
}

