/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.gemini.engine.page;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.runtime.state.gemini.engine.memstore.GSValue;
import org.apache.flink.runtime.state.gemini.engine.page.AbstractGMapValueTypeSerializer;
import org.apache.flink.runtime.state.gemini.engine.page.DataPage;
import org.apache.flink.runtime.state.gemini.engine.page.bmap.ByteBufferDataInputView;
import org.apache.flink.runtime.state.gemini.engine.page.bmap.GBinarySortedMap;
import org.apache.flink.runtime.state.gemini.engine.page.bmap.GBufferAddressMapping;
import org.apache.flink.runtime.state.gemini.engine.page.bmap.GComparator;
import org.apache.flink.runtime.state.gemini.engine.page.bmap.SplitSortedMapValueHelper;

public final class GSortedMapValueTypeSerializer<MK, MV>
extends AbstractGMapValueTypeSerializer<MK, MV> {
    private final GComparator<MK> gComparator;

    public GSortedMapValueTypeSerializer(TypeSerializer<MK> mkTypeSerializer, TypeSerializer<MV> mvTypeSerializer, GComparator<MK> gComparator, boolean checksumEnable) {
        super(mkTypeSerializer, mvTypeSerializer, checksumEnable);
        this.gComparator = gComparator;
    }

    public void serialize(Map<MK, GSValue<MV>> record, DataOutputView target) throws IOException {
        List keyValueList = record.entrySet().stream().map(entry -> new Tuple2(entry.getKey(), entry.getValue())).collect(Collectors.toList());
        GBinarySortedMap gBinarySortedMap = GBinarySortedMap.of(DataPage.DataPageType.KV, keyValueList, this.mkTypeSerializer, this.mvTypeSerializer, this.gComparator, -1L, -1, this.allocator, 1L);
        if (gBinarySortedMap == GBinarySortedMap.EMPTY_G_BINARY_SORTEDMAP) {
            return;
        }
        byte[] bytes = gBinarySortedMap.getDataByte(this.checksumEnable);
        target.write(bytes);
    }

    public void trySplitAndSerialize(Map<MK, GSValue<MV>> record, DataOutputView target, @Nullable GBufferAddressMapping mapping, int mapSplitSubMapSize, int mapSplitMinKeyNum) throws IOException {
        List keyValueList = record.entrySet().stream().map(entry -> new Tuple2(entry.getKey(), entry.getValue())).collect(Collectors.toList());
        GBinarySortedMap gBinarySortedMap = SplitSortedMapValueHelper.trySplit(DataPage.DataPageType.KV, keyValueList, this.mkTypeSerializer, this.mvTypeSerializer, this.gComparator, -1L, -1, this.allocator, 1L, mapping, mapSplitSubMapSize, mapSplitMinKeyNum);
        if (gBinarySortedMap == GBinarySortedMap.EMPTY_G_BINARY_SORTEDMAP) {
            return;
        }
        byte[] bytes = gBinarySortedMap.getDataByte(this.checksumEnable);
        target.write(bytes);
    }

    public Map<MK, GSValue<MV>> deserialize(DataInputView source) throws IOException {
        TreeMap result = new TreeMap(this.gComparator.getJDKCompactor());
        ByteBufferDataInputView bufferDataInputView = (ByteBufferDataInputView)source;
        int size = bufferDataInputView.available();
        if (size == 0) {
            return result;
        }
        byte[] bytes = new byte[size];
        source.readFully(bytes);
        GBinarySortedMap<MK> gBinarySortedMap = new GBinarySortedMap<MK>(ByteBuffer.wrap(bytes), this.mkTypeSerializer, this.gComparator);
        return gBinarySortedMap.getGBinaryHashMap().toPOJOMap(result, this.mvTypeSerializer);
    }
}

