/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.gemini.engine.page;

import java.nio.ByteBuffer;
import java.util.zip.CRC32;
import org.apache.flink.runtime.state.gemini.engine.exceptions.GeminiRuntimeException;
import org.apache.flink.runtime.state.gemini.engine.fs.FileReader;
import org.apache.flink.runtime.state.gemini.engine.page.AbstractDataPageUtil;
import org.apache.flink.runtime.state.gemini.engine.page.PageAddress;
import org.apache.flink.runtime.state.gemini.engine.page.bmap.ByteBufferUtils;
import org.apache.flink.runtime.state.gemini.engine.page.compress.CompressorCodec;
import org.apache.flink.runtime.state.gemini.engine.page.compress.GCompressAlgorithm;
import org.apache.flink.runtime.state.gemini.engine.page.compress.GCompressHeaderHelper;
import org.apache.flink.runtime.state.gemini.engine.rm.Allocator;
import org.apache.flink.runtime.state.gemini.engine.rm.GByteBuffer;
import org.apache.flink.runtime.state.gemini.engine.rm.ReferenceCountable;
import org.apache.flink.runtime.state.gemini.engine.rm.UnpoolAllocatorImpl;

public class LocalDataPageUtil
extends AbstractDataPageUtil {
    private final Allocator allocator;

    public LocalDataPageUtil() {
        this(new UnpoolAllocatorImpl(), true);
    }

    public LocalDataPageUtil(Allocator allocator, boolean enableChecksum) {
        super(enableChecksum);
        this.allocator = allocator;
    }

    @Override
    public GByteBuffer getDataPageFromReader(FileReader reader, int offsetInFile, PageAddress pageAddress) {
        ReferenceCountable headerGByteBuffer = null;
        ReferenceCountable dataGByteBuffer = null;
        try {
            int firstReadLength = 16;
            headerGByteBuffer = this.allocator.allocate(firstReadLength);
            ByteBuffer headerBuffer = headerGByteBuffer.getByteBuffer();
            reader.readByteBuffer(offsetInFile, headerBuffer, 16);
            dataGByteBuffer = this.allocator.allocate(pageAddress.getDataLen());
            if (GCompressHeaderHelper.isPageCompressed(headerBuffer)) {
                GCompressHeaderHelper.checkMagicNumber(headerBuffer);
                GCompressAlgorithm compressAlgorithm = GCompressHeaderHelper.readCompressAlgorithm(headerBuffer);
                CompressorCodec compressorCodec = compressAlgorithm.getCompressorCodec();
                int diskLength = GCompressHeaderHelper.readDiskLength(headerBuffer);
                int pageHeaderLengthOnDisk = 64;
                ByteBuffer diskDataBB = compressorCodec.getReuseByteBuffer(diskLength);
                if (diskDataBB.position() != 0) {
                    throw new GeminiRuntimeException("bb pool position should be 0, now is " + diskDataBB.position());
                }
                ByteBuffer pageByteBuffer = dataGByteBuffer.getByteBuffer();
                pageByteBuffer.position(0);
                int pageHeaderStartOffset = offsetInFile + 16;
                reader.readByteBuffer(pageHeaderStartOffset, pageByteBuffer, pageHeaderLengthOnDisk);
                int pageDataStartOffset = pageHeaderStartOffset + pageHeaderLengthOnDisk;
                reader.readByteBuffer(pageDataStartOffset, diskDataBB, diskLength);
                pageByteBuffer.position(pageHeaderLengthOnDisk);
                compressorCodec.decompress((ByteBuffer)diskDataBB.flip(), pageByteBuffer);
            } else {
                ByteBuffer pageDataBuffer = dataGByteBuffer.getByteBuffer();
                ByteBufferUtils.copyFromBufferToBuffer(headerBuffer, pageDataBuffer, 0, 0, firstReadLength);
                pageDataBuffer.position(firstReadLength);
                reader.readByteBuffer(offsetInFile + firstReadLength, pageDataBuffer, pageAddress.getDataLen() - firstReadLength);
            }
            dataGByteBuffer.getByteBuffer().position(0);
            if (this.enableChecksum) {
                CRC32 crc32 = new CRC32();
                crc32.update(dataGByteBuffer.getByteBuffer());
                int crc = (int)crc32.getValue();
                if (crc != pageAddress.getChecksum()) {
                    throw new GeminiRuntimeException("checkSum fail, " + pageAddress + " when reading from file=" + reader.getFileMeta() + " ,expected=" + pageAddress.getChecksum() + " ,now=" + crc);
                }
                dataGByteBuffer.getByteBuffer().position(0);
            }
            ReferenceCountable referenceCountable = dataGByteBuffer;
            return referenceCountable;
        }
        catch (Exception e) {
            if (dataGByteBuffer != null) {
                dataGByteBuffer.release();
            }
            LOG.error("Local PageAddress:{}", (Object)(pageAddress + " => " + e + " reader=>" + reader.getFileMeta()));
            throw new GeminiRuntimeException(e);
        }
        finally {
            if (headerGByteBuffer != null) {
                headerGByteBuffer.release();
            }
        }
    }
}

