/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.gemini.engine.page;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.Spliterators;
import java.util.stream.StreamSupport;
import org.apache.flink.runtime.state.gemini.engine.exceptions.GeminiRuntimeException;
import org.apache.flink.runtime.state.gemini.engine.page.DataPage;
import org.apache.flink.runtime.state.gemini.engine.page.LogicalPageChain;
import org.apache.flink.runtime.state.gemini.engine.page.PageAddress;
import org.apache.flink.runtime.state.gemini.engine.page.PageAddressCompositeImpl;
import org.apache.flink.runtime.state.gemini.engine.page.PageAddressSingleImpl;
import org.apache.flink.runtime.state.gemini.engine.page.PageIndexHashImpl;
import org.apache.flink.runtime.state.gemini.engine.page.PageStatus;
import org.apache.flink.runtime.state.gemini.engine.page.PageStoreStats;
import org.apache.flink.runtime.state.gemini.engine.page.bmap.GBinarySplitHashMap;
import org.apache.flink.runtime.state.gemini.engine.snapshot.RegionSnapshot;
import org.apache.flink.runtime.state.gemini.engine.snapshot.SnapshotMetaFile;
import org.apache.flink.shaded.guava18.com.google.common.base.MoreObjects;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.function.ThrowingConsumer;

public class LogicalPageChainImpl
implements LogicalPageChain {
    private volatile int chainIndex = -1;
    private volatile PageAddress[] pageAddresses;
    private volatile byte pageStatus;
    private volatile int pageSize = 0;

    public LogicalPageChainImpl(PageStatus pageStatus) {
        this.pageStatus = pageStatus.getCode();
    }

    public LogicalPageChainImpl(PageStatus pageStatus, int defaultChainLen) {
        this.pageStatus = pageStatus.getCode();
        this.initChainPageImpl(defaultChainLen);
    }

    private LogicalPageChainImpl(LogicalPageChainImpl logicalPageChain, Map<PageAddress, DataPage> copiedDataPage) {
        this.chainIndex = logicalPageChain.chainIndex;
        if (logicalPageChain.pageAddresses != null) {
            this.pageAddresses = new PageAddress[logicalPageChain.pageAddresses.length];
            System.arraycopy(logicalPageChain.pageAddresses, 0, this.pageAddresses, 0, this.chainIndex + 1);
        }
        for (int i = 0; i <= this.chainIndex; ++i) {
            DataPage dataPage = this.pageAddresses[i].getDataPage();
            if (dataPage == null) continue;
            copiedDataPage.put(this.pageAddresses[i], dataPage);
        }
        this.pageStatus = logicalPageChain.pageStatus;
    }

    private void initChainPageImpl(int defaultChainLen) {
        Preconditions.checkArgument((defaultChainLen >= 3 ? 1 : 0) != 0, (Object)"defaultChainLen too small");
        this.pageAddresses = new PageAddress[defaultChainLen];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean compareAndSetStatus(PageStatus expectedPageStatus, PageStatus targetStatus) {
        if (expectedPageStatus == null) {
            this.pageStatus = targetStatus.getCode();
            return true;
        }
        if (this.pageStatus != expectedPageStatus.getCode()) {
            return false;
        }
        LogicalPageChainImpl logicalPageChainImpl = this;
        synchronized (logicalPageChainImpl) {
            if (this.pageStatus != expectedPageStatus.getCode()) {
                return false;
            }
            this.pageStatus = targetStatus.getCode();
            return true;
        }
    }

    @Override
    public void addPageSize(int pageSize) {
        this.pageSize += pageSize;
    }

    @Override
    public int getPageSize() {
        return this.pageSize;
    }

    @Override
    public int getSubPageNum() {
        int subPageNum = 0;
        for (int i = 0; i <= this.chainIndex; ++i) {
            subPageNum += this.pageAddresses[i].getSubPageNum();
        }
        return subPageNum;
    }

    @Override
    public int getSubPageSize() {
        int subPageSize = 0;
        for (int i = 0; i <= this.chainIndex; ++i) {
            subPageSize += this.pageAddresses[i].getSubPageDataLen();
        }
        return subPageSize;
    }

    @Override
    public PageStatus getPageStatus() {
        return PageStatus.valueOf(this.pageStatus);
    }

    @Override
    public PageAddress getPageAddress(int chainIndex) {
        Preconditions.checkArgument((chainIndex >= 0 && chainIndex <= this.chainIndex ? 1 : 0) != 0, (Object)"logicPage overflow");
        return this.pageAddresses[chainIndex];
    }

    @Override
    public PageAddress createPage(DataPage dataPage) {
        Preconditions.checkArgument((this.chainIndex < this.pageAddresses.length ? 1 : 0) != 0, (Object)"logicPage overflow");
        this.checkSpace();
        PageAddress pageAddress = dataPage.getGBinaryHashMap() instanceof GBinarySplitHashMap ? new PageAddressCompositeImpl(dataPage) : new PageAddressSingleImpl(dataPage);
        this.pageAddresses[this.chainIndex + 1] = pageAddress;
        ++this.chainIndex;
        pageAddress.setChainIndex(this.chainIndex);
        return pageAddress;
    }

    @Override
    public int insertPage(PageAddress pageAddress) {
        Preconditions.checkArgument((this.chainIndex < this.pageAddresses.length ? 1 : 0) != 0, (Object)"logicPage overflow");
        this.checkSpace();
        this.pageAddresses[++this.chainIndex] = pageAddress;
        pageAddress.setChainIndex(this.chainIndex);
        return this.chainIndex;
    }

    private void checkSpace() {
        if (this.chainIndex == this.pageAddresses.length - 1) {
            PageAddress[] newpageAddresses = new PageAddress[this.pageAddresses.length + 1];
            System.arraycopy(this.pageAddresses, 0, newpageAddresses, 0, this.pageAddresses.length);
            this.pageAddresses = newpageAddresses;
        }
    }

    @Override
    public int getCurrentPageChainIndex() {
        return this.chainIndex;
    }

    @Override
    public int getPageChainCapacity() {
        return this.pageAddresses.length;
    }

    @Override
    public LogicalPageChain copy(Map<PageAddress, DataPage> copiedDataPage) {
        if (this == PageIndexHashImpl.WAIT_SPLITTING_PAGE) {
            return PageIndexHashImpl.WAIT_SPLITTING_PAGE;
        }
        return new LogicalPageChainImpl(this, copiedDataPage);
    }

    @Override
    public Iterator<PageAddress> pageIterator() {
        if (this.pageAddresses == null) {
            return Collections.emptyIterator();
        }
        return Arrays.stream(this.pageAddresses).filter(Objects::nonNull).flatMap(index -> StreamSupport.stream(Spliterators.spliteratorUnknownSize(index.pageIterator(), 0), false)).iterator();
    }

    @Override
    public void snapshot(Collection<RegionSnapshot> regionSnapshots) throws IOException {
        SnapshotMetaFile.writerFunc(regionSnapshots, (ThrowingConsumer<SnapshotMetaFile.Writer, IOException>)((ThrowingConsumer)w -> w.writeInt(this.chainIndex)));
        for (int i = 0; i <= this.chainIndex; ++i) {
            PageAddress pageAddress = this.pageAddresses[i];
            SnapshotMetaFile.writerFunc(regionSnapshots, (ThrowingConsumer<SnapshotMetaFile.Writer, IOException>)((ThrowingConsumer)w -> w.writeByte(pageAddress.getPageAddressType())));
            pageAddress.snapshot(regionSnapshots);
        }
    }

    @Override
    public void restore(SnapshotMetaFile.Reader reader, PageStoreStats pageStoreStats) throws IOException {
        this.chainIndex = reader.readInt();
        this.pageAddresses = new PageAddress[this.chainIndex + 1];
        for (int i = 0; i <= this.chainIndex; ++i) {
            PageAddress pageAddress;
            byte pageType = reader.readByte();
            switch (pageType) {
                case 1: {
                    pageAddress = PageAddressSingleImpl.restore(reader, pageStoreStats);
                    break;
                }
                case 2: {
                    pageAddress = PageAddressCompositeImpl.restore(reader, pageStoreStats);
                    break;
                }
                default: {
                    throw new GeminiRuntimeException("error pageAddress:" + pageType);
                }
            }
            pageStoreStats.addLogicSubPageCount(pageAddress.getSubPageNum());
            pageStoreStats.addLogicSubPageSize(pageAddress.getSubPageDataLen());
            this.pageAddresses[i] = pageAddress;
            this.addPageSize(pageAddress.getDataLen());
        }
        pageStoreStats.addLogicPageChainLen(this.chainIndex + 1);
        pageStoreStats.addLogicPageChainCapacity(this.chainIndex + 1);
    }

    @Override
    public Set<DataPage> getAllDataPageReferenced() {
        HashSet<DataPage> set = new HashSet<DataPage>();
        for (PageAddress address : this.pageAddresses) {
            DataPage dataPage = address.getDataPage();
            if (dataPage == null) continue;
            set.add(dataPage);
        }
        return set;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("pageAddresses", (Object)Arrays.toString(this.pageAddresses)).toString();
    }
}

