/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.gemini.engine.page;

import java.io.IOException;
import java.util.Objects;
import org.apache.flink.api.common.typeutils.CompatibilityResult;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.TypeSerializerConfigSnapshot;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.runtime.state.gemini.engine.GeminiPKey2;
import org.apache.flink.util.Preconditions;

public class PKey2Serializer<F, S>
extends TypeSerializer<GeminiPKey2<F, S>> {
    private final TypeSerializer<F> firstSerializer;
    private final TypeSerializer<S> secondSerializer;

    public PKey2Serializer(TypeSerializer<F> firstSerializer, TypeSerializer<S> secondSerializer) {
        this.firstSerializer = (TypeSerializer)Preconditions.checkNotNull(firstSerializer);
        this.secondSerializer = (TypeSerializer)Preconditions.checkNotNull(secondSerializer);
    }

    public boolean isImmutableType() {
        return true;
    }

    public TypeSerializer<GeminiPKey2<F, S>> duplicate() {
        throw new UnsupportedOperationException();
    }

    public GeminiPKey2<F, S> createInstance() {
        return new GeminiPKey2<Object, Object>(this.firstSerializer.createInstance(), this.secondSerializer.createInstance());
    }

    public GeminiPKey2<F, S> copy(GeminiPKey2<F, S> from) {
        return new GeminiPKey2<Object, Object>(this.firstSerializer.copy(from.getFirstKey()), this.secondSerializer.copy(from.getSecondKey()));
    }

    public GeminiPKey2<F, S> copy(GeminiPKey2<F, S> from, GeminiPKey2<F, S> reuse) {
        return this.copy(from);
    }

    public int getLength() {
        return 0;
    }

    public void serialize(GeminiPKey2<F, S> record, DataOutputView target) throws IOException {
        this.firstSerializer.serialize(record.getFirstKey(), target);
        this.secondSerializer.serialize(record.getSecondKey(), target);
    }

    public GeminiPKey2<F, S> deserialize(DataInputView source) throws IOException {
        return new GeminiPKey2<Object, Object>(this.firstSerializer.deserialize(source), this.secondSerializer.deserialize(source));
    }

    public GeminiPKey2<F, S> deserialize(GeminiPKey2<F, S> reuse, DataInputView source) throws IOException {
        return this.deserialize(source);
    }

    public void copy(DataInputView source, DataOutputView target) throws IOException {
        this.firstSerializer.copy(source, target);
        this.secondSerializer.copy(source, target);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || obj.getClass() != ((Object)((Object)this)).getClass()) {
            return false;
        }
        PKey2Serializer other = (PKey2Serializer)((Object)obj);
        return other.firstSerializer.equals(this.firstSerializer) && other.secondSerializer.equals(this.secondSerializer);
    }

    public boolean canEqual(Object obj) {
        return obj instanceof PKey2Serializer;
    }

    public int hashCode() {
        return Objects.hash(this.firstSerializer, this.secondSerializer);
    }

    public TypeSerializerConfigSnapshot snapshotConfiguration() {
        throw new UnsupportedOperationException();
    }

    public CompatibilityResult<GeminiPKey2<F, S>> ensureCompatibility(TypeSerializerConfigSnapshot configSnapshot) {
        throw new UnsupportedOperationException();
    }

    public TypeSerializer<F> getFirstSerializer() {
        return this.firstSerializer;
    }

    public TypeSerializer<S> getSecondSerializer() {
        return this.secondSerializer;
    }
}

