/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.gemini.engine.page;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.flink.runtime.state.gemini.engine.GRegionContext;
import org.apache.flink.runtime.state.gemini.engine.exceptions.GeminiRuntimeException;
import org.apache.flink.runtime.state.gemini.engine.filecache.FileCache;
import org.apache.flink.runtime.state.gemini.engine.page.DataPage;
import org.apache.flink.runtime.state.gemini.engine.page.PageAddress;
import org.apache.flink.runtime.state.gemini.engine.page.PageAddressSingleImpl;
import org.apache.flink.runtime.state.gemini.engine.page.PageStoreStats;
import org.apache.flink.runtime.state.gemini.engine.page.bmap.GBinaryHashMap;
import org.apache.flink.runtime.state.gemini.engine.page.bmap.GBinarySplitHashMap;
import org.apache.flink.runtime.state.gemini.engine.page.bmap.GBufferAddressMapping;
import org.apache.flink.runtime.state.gemini.engine.rm.GByteBuffer;
import org.apache.flink.runtime.state.gemini.engine.snapshot.RegionSnapshot;
import org.apache.flink.runtime.state.gemini.engine.snapshot.SnapshotMetaFile;
import org.apache.flink.shaded.guava18.com.google.common.base.MoreObjects;
import org.apache.flink.shaded.guava18.com.google.common.base.Preconditions;
import org.apache.flink.shaded.netty4.io.netty.util.concurrent.EventExecutor;
import org.apache.flink.util.function.ThrowingConsumer;

public class PageAddressCompositeImpl
implements PageAddress {
    private final int totalDataLen;
    private final PageAddress mainPageAddress;
    private final PageAddress[] subPageAddress;

    public PageAddressCompositeImpl(DataPage dataPage) {
        this.mainPageAddress = new PageAddressSingleImpl(dataPage);
        Preconditions.checkArgument((boolean)(dataPage.getGBinaryHashMap() instanceof GBinarySplitHashMap));
        this.subPageAddress = ((GBinarySplitHashMap)dataPage.getGBinaryHashMap()).getBufferAddressMapping().getSubPageAddress();
        this.totalDataLen = this.calcTotalDataLen();
    }

    public PageAddressCompositeImpl(int dataLen, int checksum, GBufferAddressMapping subPageAddress) {
        this.mainPageAddress = new PageAddressSingleImpl(dataLen, checksum);
        this.subPageAddress = subPageAddress.getSubPageAddress();
        this.totalDataLen = this.calcTotalDataLen();
    }

    public PageAddressCompositeImpl(PageAddress mainPageAddress, PageAddress[] subPageAddress) {
        this.mainPageAddress = mainPageAddress;
        this.subPageAddress = subPageAddress;
        this.totalDataLen = this.calcTotalDataLen();
    }

    private int calcTotalDataLen() {
        return this.mainPageAddress.getDataLen() + Arrays.stream(this.subPageAddress).map(PageAddress::getDataLen).reduce(0, Integer::sum);
    }

    public PageAddress[] getSubPageAddress() {
        return this.subPageAddress;
    }

    @Override
    public int getDataLen() {
        return this.totalDataLen;
    }

    @Override
    public int getMainPageDataLen() {
        return this.mainPageAddress.getDataLen();
    }

    @Override
    public int getSubPageNum() {
        return this.subPageAddress.length;
    }

    @Override
    public int getSubPageDataLen() {
        return Arrays.stream(this.subPageAddress).map(PageAddress::getDataLen).reduce(0, Integer::sum);
    }

    @Override
    public void setChainIndex(int chainIndex) {
        this.mainPageAddress.setChainIndex(chainIndex);
        Arrays.stream(this.subPageAddress).forEach(pageAddress -> pageAddress.setChainIndex(chainIndex));
    }

    @Override
    public int getMemorySize() {
        return this.mainPageAddress.getMemorySize() + Arrays.stream(this.subPageAddress).map(PageAddress::getMemorySize).reduce(0, Integer::sum);
    }

    @Override
    public void discard(FileCache fileCache, GRegionContext gRegionContext, EventExecutor eventExecutor) {
        Arrays.stream(this.subPageAddress).forEach(pageAddress -> pageAddress.discard(fileCache, gRegionContext, eventExecutor));
        this.mainPageAddress.discard(fileCache, gRegionContext, eventExecutor);
    }

    @Override
    public GByteBuffer getGByteBufferWithReference() {
        throw new GeminiRuntimeException("Internal Bug! PageAddressCompositeImpl shouldn't call getGByteBufferWithReference");
    }

    @Override
    public GByteBuffer getGByteBufferNoReference() {
        throw new GeminiRuntimeException("Internal Bug! PageAddressCompositeImpl shouldn't call getGByteBufferNoReference");
    }

    @Override
    public byte getPageAddressType() {
        return 2;
    }

    @Override
    public DataPage getDataPage() {
        return this.mainPageAddress.getDataPage();
    }

    @Override
    public DataPage getDataPageNoReference() {
        return this.mainPageAddress.getDataPageNoReference();
    }

    @Override
    public boolean hasDataPage() {
        throw new GeminiRuntimeException("Internal Bug! PageAddressCompositeImpl shouldn't call hasDataPage");
    }

    @Override
    public long getDfsAddress() {
        throw new GeminiRuntimeException("Internal Bug! PageAddressCompositeImpl shouldn't call getDfsAddress");
    }

    @Override
    public long getLocalAddress() {
        throw new GeminiRuntimeException("Internal Bug! PageAddressCompositeImpl shouldn't call getLocalAddress");
    }

    @Override
    public long getVersion() {
        throw new GeminiRuntimeException("Internal Bug! PageAddressCompositeImpl shouldn't call getVersion");
    }

    @Override
    public void setDataPage(DataPage dataPage) {
        throw new GeminiRuntimeException("Internal Bug! PageAddressCompositeImpl shouldn't call setDataPage");
    }

    @Override
    public void setDfsAddress(long dfsAddress) {
        throw new GeminiRuntimeException("Internal Bug! PageAddressCompositeImpl shouldn't call setDfsAddress");
    }

    @Override
    public void setLocalAddress(long localAddress) {
        throw new GeminiRuntimeException("Internal Bug! PageAddressCompositeImpl shouldn't call setLocalAddress");
    }

    @Override
    public void setPageStatus(boolean flag) {
        throw new GeminiRuntimeException("Internal Bug! PageAddressCompositeImpl shouldn't call setPageStatus");
    }

    @Override
    public boolean isPageValid() {
        return this.mainPageAddress.isPageValid();
    }

    @Override
    public void setLocalStatus(boolean flag) {
        throw new GeminiRuntimeException("Internal Bug! PageAddressCompositeImpl shouldn't call setLocalStatus");
    }

    @Override
    public boolean isLocalValid() {
        throw new GeminiRuntimeException("Internal Bug! PageAddressCompositeImpl shouldn't call isLocalValid");
    }

    @Override
    public void setDfsStatus(boolean flag) {
        throw new GeminiRuntimeException("Internal Bug! PageAddressCompositeImpl shouldn't call setDfsStatus");
    }

    @Override
    public boolean isDfsValid() {
        throw new GeminiRuntimeException("Internal Bug! PageAddressCompositeImpl shouldn't call isDfsValid");
    }

    @Override
    public int getChecksum() {
        throw new GeminiRuntimeException("Internal Bug! PageAddressCompositeImpl shouldn't call getChecksum");
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("mainPageAddress", (Object)this.mainPageAddress).add("subPageAddress", Arrays.asList(this.subPageAddress)).toString();
    }

    @Override
    public void snapshot(Collection<RegionSnapshot> regionSnapshots) throws IOException {
        this.mainPageAddress.snapshot(regionSnapshots);
        Preconditions.checkArgument((this.subPageAddress != null ? 1 : 0) != 0, (Object)"Internal Bug!");
        SnapshotMetaFile.writerFunc(regionSnapshots, (ThrowingConsumer<SnapshotMetaFile.Writer, IOException>)((ThrowingConsumer)w -> w.writeInt(this.subPageAddress.length)));
        for (PageAddress pageAddress : this.subPageAddress) {
            pageAddress.snapshot(regionSnapshots);
        }
    }

    public static PageAddress restore(SnapshotMetaFile.Reader reader, PageStoreStats pageStoreStats) throws IOException {
        PageAddress mainPageAddress = PageAddressSingleImpl.restore(reader, pageStoreStats);
        int subSize = reader.readInt();
        PageAddress[] subPageAddress = new PageAddress[subSize];
        for (int i = 0; i < subSize; ++i) {
            subPageAddress[i] = PageAddressSingleImpl.restore(reader, pageStoreStats);
        }
        return new PageAddressCompositeImpl(mainPageAddress, subPageAddress);
    }

    @Override
    public GBinaryHashMap toBoxGBinaryHashMap(GBinaryHashMap gBinaryHashMap, GRegionContext gRegionContext, int logicPageChainIndex, int logicPageChainHashCode) {
        GBufferAddressMapping mapping = new GBufferAddressMapping(this.subPageAddress, gRegionContext, logicPageChainIndex, logicPageChainHashCode);
        return new GBinarySplitHashMap(gBinaryHashMap, mapping);
    }

    @Override
    public Iterator<PageAddress> pageIterator() {
        return this.createOrderedPage();
    }

    @Override
    public Iterator<PageAddress> pageIteratorOrdered() {
        return this.createOrderedPage();
    }

    private Iterator<PageAddress> createOrderedPage() {
        return new Iterator<PageAddress>(){
            private int nextPageIndex = -1;

            @Override
            public boolean hasNext() {
                return this.nextPageIndex < PageAddressCompositeImpl.this.subPageAddress.length;
            }

            @Override
            public PageAddress next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                PageAddress page = this.nextPageIndex == -1 ? PageAddressCompositeImpl.this.mainPageAddress : PageAddressCompositeImpl.this.subPageAddress[this.nextPageIndex];
                ++this.nextPageIndex;
                return page;
            }
        };
    }

    public PageAddress getMainPageAddress() {
        return this.mainPageAddress;
    }

    @Override
    public void addRequestCountForNewPage(long currentTickTime, int requestCount) {
        this.mainPageAddress.addRequestCountForNewPage(currentTickTime, requestCount);
        Arrays.stream(this.subPageAddress).forEach(pageAddress -> pageAddress.addRequestCountForNewPage(currentTickTime, requestCount));
    }

    @Override
    public int getPageNum() {
        return 1 + this.subPageAddress.length;
    }
}

