/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.gemini.engine.page;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import org.apache.flink.runtime.state.gemini.engine.GRegionContext;
import org.apache.flink.runtime.state.gemini.engine.filecache.FileCache;
import org.apache.flink.runtime.state.gemini.engine.page.DataPage;
import org.apache.flink.runtime.state.gemini.engine.page.PageAddress;
import org.apache.flink.runtime.state.gemini.engine.page.PageStoreStats;
import org.apache.flink.runtime.state.gemini.engine.page.bmap.GBinaryHashMap;
import org.apache.flink.runtime.state.gemini.engine.rm.GByteBuffer;
import org.apache.flink.runtime.state.gemini.engine.snapshot.RegionSnapshot;
import org.apache.flink.runtime.state.gemini.engine.snapshot.SnapshotMetaFile;
import org.apache.flink.shaded.guava18.com.google.common.base.MoreObjects;
import org.apache.flink.shaded.netty4.io.netty.util.concurrent.EventExecutor;
import org.apache.flink.util.function.ThrowingConsumer;

public class PageAddressSingleImpl
implements PageAddress {
    private DataPage dataPage;
    private volatile long dfsAddress;
    private volatile long localAddress;
    private final int oriDataLen;
    private final int checksum;
    private volatile byte status;

    public PageAddressSingleImpl(DataPage dataPage) {
        this.dataPage = dataPage;
        this.oriDataLen = dataPage.getSize();
        this.status = 1;
        this.checksum = dataPage.getCheckSum();
    }

    public PageAddressSingleImpl(int dataLen, int checksum) {
        this.status = 1;
        this.oriDataLen = dataLen;
        this.checksum = checksum;
    }

    @Override
    public DataPage getDataPage() {
        DataPage tmpDataPage = this.dataPage;
        if (tmpDataPage != null) {
            tmpDataPage.retain();
            return tmpDataPage;
        }
        return null;
    }

    @Override
    public GByteBuffer getGByteBufferWithReference() {
        DataPage tmpDataPage = this.dataPage;
        if (tmpDataPage != null) {
            GByteBuffer buffer = tmpDataPage.getGBinaryHashMap().getGByteBuffer();
            if (buffer != null) {
                buffer.retain();
                if (buffer.isPooled() && buffer.refCnt() == 1) {
                    buffer.release();
                    return null;
                }
            }
            return buffer;
        }
        return null;
    }

    @Override
    public GByteBuffer getGByteBufferNoReference() {
        DataPage tmpDataPage = this.dataPage;
        if (tmpDataPage != null) {
            return tmpDataPage.getGBinaryHashMap().getGByteBuffer();
        }
        return null;
    }

    @Override
    public DataPage getDataPageNoReference() {
        return this.dataPage;
    }

    @Override
    public boolean hasDataPage() {
        return this.dataPage != null;
    }

    @Override
    public long getDfsAddress() {
        return this.dfsAddress;
    }

    @Override
    public long getLocalAddress() {
        return this.localAddress;
    }

    @Override
    public long getVersion() {
        return this.dataPage != null ? this.dataPage.getVersion() : -1L;
    }

    @Override
    public void setDataPage(DataPage dataPage) {
        this.dataPage = dataPage;
    }

    @Override
    public void setDfsAddress(long dfsAddress) {
        this.dfsAddress = dfsAddress;
    }

    @Override
    public void setLocalAddress(long localAddress) {
        this.localAddress = localAddress;
    }

    @Override
    public void setPageStatus(boolean flag) {
        byte st = this.status;
        this.status = (byte)(flag ? st | 1 : st & 0xFFFFFFFE);
    }

    @Override
    public boolean isPageValid() {
        return (this.status & 1) != 0;
    }

    @Override
    public void setLocalStatus(boolean flag) {
        byte st = this.status;
        this.status = (byte)(flag ? st | 2 : st & 0xFFFFFFFD);
    }

    @Override
    public boolean isLocalValid() {
        return (this.status & 2) != 0;
    }

    @Override
    public void setDfsStatus(boolean flag) {
        byte st = this.status;
        this.status = (byte)(flag ? st | 4 : st & 0xFFFFFFFB);
    }

    @Override
    public boolean isDfsValid() {
        return (this.status & 4) != 0;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("dataPage", (Object)this.dataPage).add("dfsAddress", this.dfsAddress).add("localAddress", this.localAddress).add("oriDataLen", this.oriDataLen).toString();
    }

    @Override
    public int getDataLen() {
        return this.oriDataLen;
    }

    @Override
    public int getMainPageDataLen() {
        return this.oriDataLen;
    }

    @Override
    public int getSubPageNum() {
        return 0;
    }

    @Override
    public int getSubPageDataLen() {
        return 0;
    }

    @Override
    public int getChecksum() {
        return this.checksum;
    }

    @Override
    public void snapshot(Collection<RegionSnapshot> regionSnapshots) throws IOException {
        int len = this.getDataLen();
        int checksum = this.getChecksum();
        long localAddress = this.getLocalAddress();
        long dfsAddress = this.getDfsAddress();
        SnapshotMetaFile.writerFunc(regionSnapshots, (ThrowingConsumer<SnapshotMetaFile.Writer, IOException>)((ThrowingConsumer)w -> {
            w.writeInt(len);
            w.writeInt(checksum);
            w.writeLong(dfsAddress);
        }));
        for (RegionSnapshot regionSnapshot : regionSnapshots) {
            if (regionSnapshot.isLocalSnapshot()) {
                if (this.isLocalValid()) {
                    regionSnapshot.getWriter().writeBoolean(true);
                    regionSnapshot.getWriter().writeLong(localAddress);
                } else {
                    regionSnapshot.getWriter().writeBoolean(false);
                }
                regionSnapshot.updateFileMeta(localAddress, 1, len);
                continue;
            }
            regionSnapshot.getWriter().writeBoolean(false);
            regionSnapshot.updateFileMeta(dfsAddress, 1, len);
        }
    }

    @Override
    public byte getPageAddressType() {
        return 1;
    }

    @Override
    public void setChainIndex(int chainIndex) {
        if (this.dataPage != null) {
            this.dataPage.setChainIndex(chainIndex);
        }
    }

    @Override
    public int getMemorySize() {
        return this.dataPage == null ? 0 : this.oriDataLen;
    }

    @Override
    public void discard(FileCache fileCache, GRegionContext gRegionContext, EventExecutor eventExecutor) {
        fileCache.discardPage(this, gRegionContext, eventExecutor);
        if (this.dataPage != null) {
            gRegionContext.tryToDelHugePage(this.dataPage);
            this.dataPage.release();
            if (this.isLocalValid()) {
                this.dataPage = null;
            }
        }
        gRegionContext.getGContext().getSupervisor().getBloomFilterManager().removeBloomFilter(this);
    }

    public static PageAddress restore(SnapshotMetaFile.Reader reader, PageStoreStats pageStoreStats) throws IOException {
        int pageLen = reader.readInt();
        int checksum = reader.readInt();
        PageAddressSingleImpl pageAddress = new PageAddressSingleImpl(pageLen, checksum);
        long dfsAddress = reader.readLong();
        pageAddress.setDfsAddress(dfsAddress);
        pageAddress.setDfsStatus(true);
        if (reader.readBoolean()) {
            long localAddress = reader.readLong();
            pageAddress.setLocalAddress(localAddress);
            pageAddress.setLocalStatus(true);
        }
        pageStoreStats.addLogicPageSize(pageLen);
        return pageAddress;
    }

    @Override
    public GBinaryHashMap toBoxGBinaryHashMap(GBinaryHashMap gBinaryHashMap, GRegionContext gRegionContext, int logicPageChainIndex, int logicPageChainHashCode) {
        return gBinaryHashMap;
    }

    @Override
    public Iterator<PageAddress> pageIterator() {
        return Collections.singleton(this).iterator();
    }

    @Override
    public Iterator<PageAddress> pageIteratorOrdered() {
        return Collections.singleton(this).iterator();
    }

    @Override
    public void addRequestCountForNewPage(long currentTickTime, int requestCount) {
        if (this.dataPage != null) {
            this.dataPage.addRequestCount(currentTickTime, requestCount);
        }
    }

    @Override
    public int getPageNum() {
        return 1;
    }
}

