/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.gemini.engine.page;

import org.apache.flink.annotation.Internal;
import org.apache.flink.runtime.state.gemini.engine.GRegionID;
import org.apache.flink.runtime.state.gemini.engine.exceptions.GeminiRuntimeException;
import org.apache.flink.util.Preconditions;

@Internal
public class PageContext {
    public static final PageContext INVALID_PAGE_CONTEXT = null;
    private final GRegionID regionID;
    private final int logicPageIndex;
    private final int logicPageHashCode;
    private volatile CacheStatus cacheStatues;

    public PageContext(GRegionID gRegionID, int logicPageIndex, int logicPageHashCode, CacheStatus cacheStatues) {
        Preconditions.checkArgument((logicPageIndex >= 0 ? 1 : 0) != 0);
        this.regionID = (GRegionID)Preconditions.checkNotNull((Object)gRegionID);
        this.logicPageIndex = logicPageIndex;
        this.logicPageHashCode = logicPageHashCode;
        this.cacheStatues = (CacheStatus)((Object)Preconditions.checkNotNull((Object)((Object)cacheStatues)));
    }

    public static PageContext of(GRegionID regionID, int logicPageIndex, int logicPageHashCode) {
        return new PageContext(regionID, logicPageIndex, logicPageHashCode, CacheStatus.UNKNOW);
    }

    public static PageContext of(GRegionID regionID, int logicPageIndex, int logicPageHashCode, CacheStatus cacheStatues) {
        return new PageContext(regionID, logicPageIndex, logicPageHashCode, cacheStatues);
    }

    public GRegionID getGRegionID() {
        return this.regionID;
    }

    public int getLogicPageIndex() {
        return this.logicPageIndex;
    }

    public int getLogicPageChainHashCode() {
        return this.logicPageHashCode;
    }

    public CacheStatus getCacheStatus() {
        return this.cacheStatues;
    }

    public synchronized CacheStatus setCacheStatus(CacheStatus newStatus) {
        CacheStatus old = this.cacheStatues;
        this.cacheStatues = newStatus;
        return old;
    }

    public int hashCode() {
        int hashCode2 = this.regionID.hashCode();
        hashCode2 = hashCode2 * 31 + this.logicPageIndex;
        hashCode2 = hashCode2 * 31 + this.logicPageHashCode;
        hashCode2 = hashCode2 * 31 + this.cacheStatues.getCode();
        return hashCode2;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        PageContext other = (PageContext)obj;
        return this.regionID.equals(other.getGRegionID()) && this.logicPageIndex == other.logicPageIndex && this.logicPageHashCode == other.logicPageHashCode && this.cacheStatues.equals((Object)other.cacheStatues);
    }

    public static enum CacheStatus {
        UNKNOW(0),
        IN_LRU(1),
        CACHING_TO_MAIN(2);

        private final byte code;

        private CacheStatus(byte code) {
            this.code = code;
        }

        byte getCode() {
            return this.code;
        }

        public static CacheStatus valueOf(byte code) {
            switch (code) {
                case 0: {
                    return UNKNOW;
                }
                case 1: {
                    return IN_LRU;
                }
                case 2: {
                    return CACHING_TO_MAIN;
                }
            }
            throw new GeminiRuntimeException("Wrong cache status " + code);
        }
    }
}

