/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.gemini.engine.page;

import java.util.Objects;
import org.apache.flink.runtime.state.gemini.engine.page.LogicalPageChain;
import org.apache.flink.runtime.state.gemini.engine.page.PageIndexContext;

public class PageIndexContextHashImpl
implements PageIndexContext {
    private final int curBucketNum;
    private final int curIndex;
    private final LogicalPageChain logicalPageChain;
    private final boolean needSplit;

    public PageIndexContextHashImpl(int curBucketNum, int curIndex, LogicalPageChain logicalPageChain, boolean needSplit) {
        this.curBucketNum = curBucketNum;
        this.curIndex = curIndex;
        this.logicalPageChain = logicalPageChain;
        this.needSplit = needSplit;
    }

    public static PageIndexContext of(int curBucketNum, int curIndex, LogicalPageChain logicalPageChain, boolean needSplit) {
        return new PageIndexContextHashImpl(curBucketNum, curIndex, logicalPageChain, needSplit);
    }

    public static PageIndexContext of(PageIndexContextHashImpl pageIndexContext, LogicalPageChain logicalPageChain) {
        return new PageIndexContextHashImpl(pageIndexContext.curBucketNum, pageIndexContext.curIndex, logicalPageChain, false);
    }

    @Override
    public LogicalPageChain getLogicalPageChain() {
        return this.logicalPageChain;
    }

    @Override
    public int getPageIndexID() {
        return this.curIndex;
    }

    @Override
    public boolean isNeedSplit() {
        return this.needSplit;
    }

    public int getCurBucketNum() {
        return this.curBucketNum;
    }

    public int getCurIndex() {
        return this.curIndex;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PageIndexContextHashImpl that = (PageIndexContextHashImpl)o;
        return this.curBucketNum == that.curBucketNum && this.curIndex == that.curIndex && this.needSplit == that.needSplit && Objects.equals(this.logicalPageChain, that.logicalPageChain);
    }

    public int hashCode() {
        return Objects.hash(this.curBucketNum, this.curIndex, this.logicalPageChain, this.needSplit);
    }
}

