/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.gemini.engine.page;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Spliterators;
import java.util.stream.StreamSupport;
import org.apache.flink.runtime.state.gemini.engine.GConfiguration;
import org.apache.flink.runtime.state.gemini.engine.GRegionContext;
import org.apache.flink.runtime.state.gemini.engine.exceptions.GeminiRuntimeException;
import org.apache.flink.runtime.state.gemini.engine.page.DataPage;
import org.apache.flink.runtime.state.gemini.engine.page.LogicalPageChain;
import org.apache.flink.runtime.state.gemini.engine.page.LogicalPageChainImpl;
import org.apache.flink.runtime.state.gemini.engine.page.PageAddress;
import org.apache.flink.runtime.state.gemini.engine.page.PageIndex;
import org.apache.flink.runtime.state.gemini.engine.page.PageIndexContext;
import org.apache.flink.runtime.state.gemini.engine.page.PageIndexContextHashImpl;
import org.apache.flink.runtime.state.gemini.engine.page.PageStatus;
import org.apache.flink.runtime.state.gemini.engine.page.PageStore;
import org.apache.flink.runtime.state.gemini.engine.page.PageStoreStats;
import org.apache.flink.runtime.state.gemini.engine.snapshot.RegionSnapshot;
import org.apache.flink.runtime.state.gemini.engine.snapshot.SnapshotMetaFile;
import org.apache.flink.util.MathUtils;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.function.ThrowingConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PageIndexHashImpl<K>
implements PageIndex<K> {
    private static final Logger LOG = LoggerFactory.getLogger(PageIndexHashImpl.class);
    public static final LogicalPageChain WAIT_SPLITTING_PAGE = new LogicalPageChainImpl(PageStatus.Init);
    public static final LogicalPageChain NO_PAGE = null;
    private final int baseBucketNum;
    private volatile int curBucketNum;
    private final PageStore pageStore;
    private final PageStoreStats pageStoreStats;
    private volatile LogicalPageChain[] pageIndex;
    private final int logicPageChainLenDefault;

    public PageIndexHashImpl(GConfiguration config, PageStore pageStore, PageStoreStats pageStoreStats) {
        int configBucketNum = config.getPageIndexBucketLenDefault();
        Preconditions.checkArgument(((configBucketNum & configBucketNum - 1) == 0 ? 1 : 0) != 0, (Object)"curBucketNum should be a power of 2.");
        this.baseBucketNum = configBucketNum;
        this.curBucketNum = configBucketNum;
        this.pageIndex = new LogicalPageChain[configBucketNum];
        this.pageStore = pageStore;
        this.pageStoreStats = pageStoreStats;
        this.logicPageChainLenDefault = config.getLogicTableDefaultChainLen();
        this.pageStoreStats.setIndexCapacity(this.curBucketNum);
    }

    public PageIndexHashImpl(LogicalPageChain[] pageIndex, PageStore pageStore, PageStoreStats pageStoreStats, int baseBucketNum, int curBucketNum, int logicPageChainLenDefault) {
        this.baseBucketNum = baseBucketNum;
        this.curBucketNum = curBucketNum;
        this.pageIndex = pageIndex;
        this.pageStore = pageStore;
        this.pageStoreStats = pageStoreStats;
        this.logicPageChainLenDefault = logicPageChainLenDefault;
        this.pageStoreStats.setIndexCapacity(curBucketNum);
    }

    private PageIndexHashImpl(PageIndexHashImpl pageIndexHash, Map<PageAddress, DataPage> copiedDataPage) {
        this.baseBucketNum = pageIndexHash.baseBucketNum;
        this.curBucketNum = pageIndexHash.curBucketNum;
        this.pageStore = pageIndexHash.pageStore;
        this.pageStoreStats = pageIndexHash.pageStoreStats;
        this.logicPageChainLenDefault = pageIndexHash.logicPageChainLenDefault;
        this.pageIndex = new LogicalPageChain[pageIndexHash.pageIndex.length];
        for (int i = 0; i < this.pageIndex.length; ++i) {
            LogicalPageChain pageChain = pageIndexHash.pageIndex[i];
            if (pageChain == null) continue;
            this.pageIndex[i] = pageChain.copy(copiedDataPage);
        }
    }

    @Override
    public PageIndexContext getPageIndexContext(K key, boolean createIfMissing) {
        PageIndexContextHashImpl result;
        block3: {
            int hash = MathUtils.bitMix((int)key.hashCode());
            int checkBucketNum = this.curBucketNum;
            int curIndex = hash & checkBucketNum - 1;
            if (createIfMissing) {
                return this.internalGetPageIndexContext(hash, curIndex, checkBucketNum, true);
            }
            while (true) {
                result = (PageIndexContextHashImpl)this.internalGetPageIndexContext(hash, curIndex, checkBucketNum, false);
                if (checkBucketNum != this.curBucketNum) {
                    checkBucketNum = this.curBucketNum;
                    curIndex = hash & checkBucketNum - 1;
                    continue;
                }
                if (result.getCurBucketNum() == this.curBucketNum) break block3;
                PageIndexContextHashImpl checkResult = (PageIndexContextHashImpl)this.internalGetPageIndexContext(hash, hash & this.curBucketNum - 1, this.curBucketNum, false);
                if (result.getCurIndex() == checkResult.getCurIndex()) break;
            }
            return result;
        }
        return result;
    }

    private PageIndexContext internalGetPageIndexContext(int hash, int curIndex, int checkBucketNum, boolean createIfMiss) {
        PageIndexContext result;
        PageIndexContext pageIndexContext = result = this.pageIndex[curIndex] == WAIT_SPLITTING_PAGE ? this.recursiveGetPageContext(hash, checkBucketNum) : PageIndexContextHashImpl.of(checkBucketNum, curIndex, this.pageIndex[curIndex], false);
        if (result.getLogicalPageChain() != NO_PAGE || !createIfMiss) {
            return result;
        }
        this.pageIndex[curIndex] = this.createLogicalPageChain();
        this.pageStoreStats.addLogicPageCount(1);
        this.pageStoreStats.addLogicPageChainCapacity(this.logicPageChainLenDefault);
        return PageIndexContextHashImpl.of(checkBucketNum, curIndex, this.pageIndex[curIndex], false);
    }

    private PageIndexContext recursiveGetPageContext(int hash, int checkBucketNum) {
        checkBucketNum >>= 1;
        while (checkBucketNum >= this.baseBucketNum) {
            int index = hash & checkBucketNum - 1;
            if (this.pageIndex[index] != WAIT_SPLITTING_PAGE) {
                return PageIndexContextHashImpl.of(checkBucketNum, index, this.pageIndex[index], true);
            }
            checkBucketNum >>= 1;
        }
        throw new GeminiRuntimeException("Internal Bug!");
    }

    @Override
    public void expand() {
        Object[] pageIndexNew = new LogicalPageChain[this.curBucketNum << 1];
        System.arraycopy(this.pageIndex, 0, pageIndexNew, 0, this.pageIndex.length);
        Arrays.fill(pageIndexNew, this.pageIndex.length, pageIndexNew.length, WAIT_SPLITTING_PAGE);
        this.pageIndex = pageIndexNew;
        this.curBucketNum = pageIndexNew.length;
        this.pageStoreStats.setIndexCapacity(this.curBucketNum);
    }

    @Override
    public void shrink() {
        this.pageStoreStats.setIndexCapacity(this.curBucketNum);
    }

    @Override
    public void snapshot(Collection<RegionSnapshot> regionSnapshots) throws IOException {
        SnapshotMetaFile.writerFunc(regionSnapshots, (ThrowingConsumer<SnapshotMetaFile.Writer, IOException>)((ThrowingConsumer)w -> {
            w.writeInt(this.baseBucketNum);
            w.writeInt(this.curBucketNum);
            w.writeInt(this.logicPageChainLenDefault);
            w.writeInt(this.pageIndex.length);
        }));
        for (LogicalPageChain logicalPageChain : this.pageIndex) {
            if (logicalPageChain == null) {
                SnapshotMetaFile.writerFunc(regionSnapshots, (ThrowingConsumer<SnapshotMetaFile.Writer, IOException>)((ThrowingConsumer)w -> w.writeBoolean(true)));
                continue;
            }
            SnapshotMetaFile.writerFunc(regionSnapshots, (ThrowingConsumer<SnapshotMetaFile.Writer, IOException>)((ThrowingConsumer)w -> w.writeBoolean(false)));
            if (logicalPageChain == WAIT_SPLITTING_PAGE) {
                SnapshotMetaFile.writerFunc(regionSnapshots, (ThrowingConsumer<SnapshotMetaFile.Writer, IOException>)((ThrowingConsumer)w -> w.writeBoolean(true)));
                continue;
            }
            SnapshotMetaFile.writerFunc(regionSnapshots, (ThrowingConsumer<SnapshotMetaFile.Writer, IOException>)((ThrowingConsumer)w -> w.writeBoolean(false)));
            logicalPageChain.snapshot(regionSnapshots);
        }
    }

    @Override
    public boolean updateLogicPageStatus(int logicPageId, PageStatus expectedStatus, PageStatus targetStatus) {
        Preconditions.checkArgument((logicPageId < this.pageIndex.length ? 1 : 0) != 0, (Object)String.format("It's illegal to update page status at index %s, due to out of current pages bound: %s.", logicPageId, this.pageIndex.length));
        return this.pageIndex[logicPageId].compareAndSetStatus(expectedStatus, targetStatus);
    }

    @Override
    public PageIndex<K> copy(Map<PageAddress, DataPage> copiedDataPage) {
        return new PageIndexHashImpl<K>(this, copiedDataPage);
    }

    @Override
    public void removeLogicPage(int logicPageId) {
        this.pageIndex[logicPageId] = NO_PAGE;
        this.pageStoreStats.addLogicPageCount(-1);
    }

    @Override
    public LogicalPageChain getLogicPage(int logicPageId) {
        return this.pageIndex[logicPageId];
    }

    @Override
    public void updateLogicPage(int logicPageId, LogicalPageChain targetLogicPage) {
        Preconditions.checkArgument((logicPageId < this.pageIndex.length ? 1 : 0) != 0, (Object)String.format("It's illegal to update page at index %s, due to out of current pages bound: %s.", logicPageId, this.pageIndex.length));
        this.pageIndex[logicPageId] = targetLogicPage;
    }

    @Override
    public LogicalPageChain createLogicalPageChain() {
        return new LogicalPageChainImpl(PageStatus.Normal, this.logicPageChainLenDefault);
    }

    @Override
    public Iterator<PageAddress> pageIterator() {
        return Arrays.stream(this.pageIndex).filter(Objects::nonNull).flatMap(index -> StreamSupport.stream(Spliterators.spliteratorUnknownSize(index.pageIterator(), 0), false)).iterator();
    }

    @Override
    public int getIndexCapacity() {
        return this.curBucketNum;
    }

    @Override
    public LogicalPageChain[] getPageIndex() {
        return this.pageIndex;
    }

    public int getBucketNumASPageFinishSplit(int curBucketNum, int curIndex) {
        while (true) {
            if (this.getLogicPage(curIndex) == WAIT_SPLITTING_PAGE) {
                throw new GeminiRuntimeException("Gemini Internal Bug, want to split a invalid page");
            }
            int checkBucketNum = curBucketNum >> 1;
            if (checkBucketNum <= curIndex || this.getLogicPage(curIndex + checkBucketNum) != WAIT_SPLITTING_PAGE) break;
            curBucketNum = checkBucketNum;
        }
        return curBucketNum;
    }

    public static class Builder {
        private final int baseBucketNum;
        private final int curBucketNum;
        private final int logicPageChainLenDefault;
        private final LogicalPageChain[] pageIndex;
        private final GRegionContext regionContext;

        public Builder(SnapshotMetaFile.Reader reader, GRegionContext context) throws IOException {
            this.baseBucketNum = reader.readInt();
            this.curBucketNum = reader.readInt();
            this.logicPageChainLenDefault = reader.readInt();
            this.regionContext = context;
            int pageIndexLength = reader.readInt();
            this.pageIndex = new LogicalPageChain[pageIndexLength];
            for (int i = 0; i < pageIndexLength; ++i) {
                LogicalPageChain logicalPageChain;
                boolean emptyPage = reader.readBoolean();
                if (emptyPage) {
                    logicalPageChain = null;
                } else {
                    boolean waitSplitting = reader.readBoolean();
                    if (waitSplitting) {
                        logicalPageChain = WAIT_SPLITTING_PAGE;
                    } else {
                        logicalPageChain = new LogicalPageChainImpl(PageStatus.Normal);
                        logicalPageChain.restore(reader, this.regionContext.getPageStoreStats());
                        this.regionContext.getPageStoreStats().addLogicPageCount(1);
                    }
                }
                this.pageIndex[i] = logicalPageChain;
            }
        }

        public PageIndex build() {
            return new PageIndexHashImpl(this.pageIndex, null, this.regionContext.getPageStoreStats(), this.baseBucketNum, this.curBucketNum, this.logicPageChainLenDefault);
        }
    }
}

