/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.gemini.engine.page;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.runtime.state.gemini.engine.GRegion;
import org.apache.flink.runtime.state.gemini.engine.exceptions.GeminiRuntimeException;
import org.apache.flink.runtime.state.gemini.engine.exceptions.GeminiShutDownException;
import org.apache.flink.runtime.state.gemini.engine.memstore.GSValue;
import org.apache.flink.runtime.state.gemini.engine.page.AbstractHashPageStore;
import org.apache.flink.runtime.state.gemini.engine.page.DataPage;
import org.apache.flink.runtime.state.gemini.engine.page.DataPageKList;
import org.apache.flink.runtime.state.gemini.engine.page.DataPageKListImpl;
import org.apache.flink.runtime.state.gemini.engine.page.GValueType;
import org.apache.flink.runtime.state.gemini.engine.page.LogicalPageChain;
import org.apache.flink.runtime.state.gemini.engine.page.PageAddress;
import org.apache.flink.runtime.state.gemini.engine.page.PageIndex;
import org.apache.flink.runtime.state.gemini.engine.page.PageIndexContext;
import org.apache.flink.runtime.state.gemini.engine.page.PageSerdeFlinkListImpl;
import org.apache.flink.runtime.state.gemini.engine.page.PageStoreKList;
import org.apache.flink.runtime.state.gemini.engine.page.bmap.BinaryKey;
import org.apache.flink.runtime.state.gemini.engine.page.bmap.BinaryValue;
import org.apache.flink.runtime.state.gemini.engine.page.bmap.ByteBufferDataInputView;
import org.apache.flink.runtime.state.gemini.engine.page.bmap.GBinaryHashMap;
import org.apache.flink.runtime.state.gemini.engine.page.bmap.GBufferAddressMapping;
import org.apache.flink.runtime.state.gemini.engine.rm.GByteBuffer;
import org.apache.flink.shaded.netty4.io.netty.util.concurrent.EventExecutor;

public class PageStoreHashKListImpl<K, E>
extends AbstractHashPageStore<K, List<GSValue<E>>>
implements PageStoreKList<K, E> {
    protected PageSerdeFlinkListImpl<K, E> pageSerdeFlinkListImpl;

    public PageStoreHashKListImpl(GRegion gRegion, EventExecutor eventExecutor) {
        this(gRegion, null, eventExecutor);
    }

    public PageStoreHashKListImpl(GRegion gRegion, PageIndex pageIndex, EventExecutor eventExecutor) {
        super(DataPage.DataPageType.KList, gRegion, pageIndex, eventExecutor);
        this.pageSerdeFlinkListImpl = (PageSerdeFlinkListImpl)this.gRegionContext.getPageSerdeFlink();
    }

    @Override
    public boolean contains(K key) {
        Object result = this.get((Object)key);
        return this.get((Object)key) != null && !result.isEmpty();
    }

    @Override
    long getRequestCount(List<Tuple2<K, GSValue<List<GSValue<E>>>>> dataSet) {
        return dataSet.stream().map(value -> ((GSValue)value.f1).getRequestCount()).reduce(0, (a, b) -> a + b).intValue();
    }

    @Override
    DataPage<K, List<GSValue<E>>> createDataPage(long version, List<Tuple2<K, GSValue<List<GSValue<E>>>>> dataSet, int logicPageId) {
        GBinaryHashMap gBinaryHashMap = GBinaryHashMap.of(this.getDataPageType(), dataSet, this.pageSerdeFlink.getKeySerde(), this.pageSerdeFlinkListImpl.getgListValueTypeSerializer(), version, logicPageId, this.gContext.getSupervisor().getAllocator(), 1L, this.gRegionContext.getGContext().getInPageGCompressAlgorithm());
        return gBinaryHashMap == GBinaryHashMap.EMPTY_G_BINARY_HASHMAP ? null : new DataPageKListImpl(gBinaryHashMap, this.pageSerdeFlinkListImpl.getValueSerde(), this.pageSerdeFlinkListImpl.getgListValueTypeSerializer());
    }

    @Override
    public List<GSValue<E>> get(K key) {
        PageIndexContext pageIndexContext = this.pageIndex.getPageIndexContext(key, false);
        LogicalPageChain logicPageID = pageIndexContext.getLogicalPageChain();
        if (this.isNullPage(logicPageID)) {
            return null;
        }
        List<GSValue<GSValue<E>>> finalResult = null;
        int curIndex = logicPageID.getCurrentPageChainIndex();
        ArrayList<BinaryValue> binaryValueReversedOrderList = new ArrayList<BinaryValue>();
        HashMap<Integer, DataPage> fetchedDataPageMap = new HashMap<Integer, DataPage>();
        ArrayList<DataPage> needToRelease = new ArrayList<DataPage>();
        while (curIndex >= 0 && this.gContext.isDBNormal()) {
            DataPage dataPage2 = this.getDataPageAutoLoadIfNeed(key, logicPageID, pageIndexContext.getPageIndexID(), curIndex, fetchedDataPageMap);
            if (dataPage2 == null) {
                --curIndex;
                continue;
            }
            needToRelease.add(dataPage2);
            if (!(dataPage2 instanceof DataPageKList)) {
                needToRelease.forEach(page -> page.release());
                fetchedDataPageMap.values().forEach(page -> page.release());
                throw new IllegalArgumentException("Internal BUG, error page");
            }
            dataPage2.addRequestCount(this.cacheManager.getCurrentTickTime(), 1);
            this.gRegionContext.getPageStoreStats().addPageRequestCount(1L);
            BinaryValue binaryValue = dataPage2.getBinaryValue(key);
            if (binaryValue != null) {
                if (binaryValue.getGValueType() == GValueType.Delete) break;
                binaryValueReversedOrderList.add(binaryValue);
                if (binaryValue.getGValueType() == GValueType.PutList) break;
            }
            --curIndex;
        }
        if (!this.gContext.isDBNormal()) {
            needToRelease.forEach(dataPage -> dataPage.release());
            fetchedDataPageMap.values().forEach(dataPage -> dataPage.release());
            throw new GeminiShutDownException("DB is in abnormal status " + this.gContext.getDBStatus().name());
        }
        finalResult = binaryValueReversedOrderList.size() == 0 ? null : this.doCompactValueToPOJO(binaryValueReversedOrderList);
        needToRelease.forEach(dataPage -> dataPage.release());
        this.tryLaunchCompactionByRead(pageIndexContext, logicPageID, fetchedDataPageMap);
        return finalResult;
    }

    protected List<GSValue<E>> doCompactValueToPOJO(List<BinaryValue> binaryValueReversedOrderList) {
        try {
            ArrayList<GSValue<E>> result = new ArrayList<GSValue<E>>();
            int index = binaryValueReversedOrderList.size() - 1;
            while (index >= 0) {
                BinaryValue binaryValue = binaryValueReversedOrderList.get(index);
                ByteBufferDataInputView byteBufferDataInputView = new ByteBufferDataInputView(binaryValue.getBb(), binaryValue.getValueOffset(), binaryValue.getValueLen());
                Object gsValueList = this.pageSerdeFlinkListImpl.getgListValueTypeSerializer().deserialize(byteBufferDataInputView);
                if (gsValueList == null) continue;
                result.addAll((Collection<GSValue<E>>)gsValueList);
                --index;
            }
            return result;
        }
        catch (Exception e) {
            throw new GeminiRuntimeException("Exception: " + e.getMessage(), e);
        }
    }

    @Override
    public void getAll(Map<K, GSValue<List<GSValue<E>>>> container) {
    }

    @Override
    public DataPage doCompactPage(PageIndexContext pageIndexContext, boolean isMajor, List<DataPage> canCompactPageListReversedOrder, long version, int logicPageId) {
        if (canCompactPageListReversedOrder == null || canCompactPageListReversedOrder.size() == 0) {
            throw new GeminiRuntimeException("Internal BUG");
        }
        return this.doCompactPageForStructureValue(pageIndexContext, isMajor, canCompactPageListReversedOrder, version, logicPageId);
    }

    @Override
    protected DataPage doBuildDataPageFromGBinaryMap(boolean isMajor, long version, int logicPageId, TypeSerializer<K> keySerde, Map<BinaryKey, BinaryValue> finalCompactedMap, long compactionCount, GBufferAddressMapping pageMapping) {
        GBinaryHashMap gBinaryHashMap = GBinaryHashMap.ofBinaryMap(this.getDataPageType(), isMajor, version, logicPageId, this.pageSerdeFlink.getKeySerde(), this.gContext.getSupervisor().getAllocator(), finalCompactedMap, compactionCount, this.gContext.getStateFilter(), this.gRegionContext);
        return gBinaryHashMap == GBinaryHashMap.EMPTY_G_BINARY_HASHMAP ? null : new DataPageKListImpl(gBinaryHashMap, this.pageSerdeFlinkListImpl.getValueSerde(), this.pageSerdeFlinkListImpl.getgListValueTypeSerializer());
    }

    @Override
    DataPage<K, List<GSValue<E>>> boxDataPage(PageAddress pageAddress, GByteBuffer byteBuffer, int logicPageChainIndex, int logicPageChainHashCode) {
        this.checkDataPageTypeToBox(byteBuffer);
        GBinaryHashMap gBinaryHashMap = new GBinaryHashMap(byteBuffer, this.pageSerdeFlink.getKeySerde(), pageAddress.getChecksum());
        return gBinaryHashMap == GBinaryHashMap.EMPTY_G_BINARY_HASHMAP ? null : new DataPageKListImpl(gBinaryHashMap, this.pageSerdeFlinkListImpl.getValueSerde(), this.pageSerdeFlinkListImpl.getgListValueTypeSerializer());
    }

    @Override
    BinaryValue doCompactValue(List<BinaryValue> binaryValueList, boolean isMajor, long version, int logicPageId, GBufferAddressMapping pageMapping) {
        return DataPageKListImpl.doCompactionKListValue(binaryValueList, this.pageSerdeFlink.getValueSerde(), isMajor, version, logicPageId, this.gContext.getSupervisor().getDefaultAllocator());
    }
}

