/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.gemini.engine.page.bloomfilter;

import java.util.Arrays;
import org.apache.flink.runtime.state.gemini.engine.page.DataPage;
import org.apache.flink.runtime.state.gemini.engine.page.bmap.GBinaryHashMap;
import org.apache.flink.util.Preconditions;

public class PageBloomFilter {
    public static final double DEFAULT_FPP = (double)0.03f;
    private final int numBits;
    private final int numHashFunctions;
    private final BitSet bitSet;

    public static PageBloomFilter createByPage(DataPage dataPage) {
        GBinaryHashMap gBinaryHashMap = dataPage.getGBinaryHashMap();
        if (gBinaryHashMap == null) {
            return null;
        }
        int indexLen = gBinaryHashMap.indexCount();
        int keyCount = gBinaryHashMap.keyCount();
        if (keyCount < 16) {
            return null;
        }
        PageBloomFilter pageBloomFilter = new PageBloomFilter(keyCount);
        for (int i = 0; i < keyCount; ++i) {
            pageBloomFilter.addHash(gBinaryHashMap.getHashCode(indexLen, i));
        }
        return pageBloomFilter;
    }

    public PageBloomFilter(long maxNumEntries) {
        this(maxNumEntries, 0.03f);
    }

    public PageBloomFilter(long maxNumEntries, double fpp) {
        Preconditions.checkArgument((maxNumEntries > 0L ? 1 : 0) != 0, (Object)"expectedEntries should be > 0");
        int nb = PageBloomFilter.optimalNumOfBits(maxNumEntries, fpp);
        this.numBits = nb + (64 - nb % 64);
        this.numHashFunctions = PageBloomFilter.optimalNumOfHashFunctions(maxNumEntries, this.numBits);
        this.bitSet = new BitSet(this.numBits);
    }

    public int byteSize() {
        return 24 + this.bitSet.getData().length * 8;
    }

    public void addHash(int hash32) {
        int hash1 = hash32;
        int hash2 = hash32 >>> 16;
        for (int i = 1; i <= this.numHashFunctions; ++i) {
            int combinedHash = hash1 + (i + 1) * hash2;
            if (combinedHash < 0) {
                combinedHash ^= 0xFFFFFFFF;
            }
            int pos = combinedHash % this.numBits;
            this.bitSet.set(pos);
        }
    }

    public boolean mightContain(int hash32) {
        int hash1 = hash32;
        int hash2 = hash32 >>> 16;
        for (int i = 1; i <= this.numHashFunctions; ++i) {
            int pos;
            int combinedHash = hash1 + (i + 1) * hash2;
            if (combinedHash < 0) {
                combinedHash ^= 0xFFFFFFFF;
            }
            if (this.bitSet.get(pos = combinedHash % this.numBits)) continue;
            return false;
        }
        return true;
    }

    public long[] getBitSet() {
        return this.bitSet.getData();
    }

    public String toString() {
        return "numBits: " + this.numBits + " numHashFunctions: " + this.numHashFunctions;
    }

    private static int optimalNumOfHashFunctions(long n, long m) {
        return Math.max(1, (int)Math.round((double)m / (double)n * Math.log(2.0)));
    }

    private static int optimalNumOfBits(long maxNumEntries, double fpp) {
        return (int)((double)(-maxNumEntries) * Math.log(fpp) / (Math.log(2.0) * Math.log(2.0)));
    }

    public static class BitSet {
        private final long[] data;

        BitSet(long bits) {
            this(new long[(int)Math.ceil((double)bits / 64.0)]);
        }

        BitSet(long[] data) {
            assert (data.length > 0) : "data length is zero!";
            this.data = data;
        }

        public void set(int index) {
            int n = index >>> 6;
            this.data[n] = this.data[n] | 1L << index;
        }

        public boolean get(int index) {
            return (this.data[index >>> 6] & 1L << index) != 0L;
        }

        public long[] getData() {
            return this.data;
        }

        public void putAll(BitSet array) {
            assert (this.data.length == array.data.length) : "BitArrays must be of equal length (" + this.data.length + "!= " + array.data.length + ")";
            for (int i = 0; i < this.data.length; ++i) {
                int n = i;
                this.data[n] = this.data[n] | array.data[i];
            }
        }

        public void clear() {
            Arrays.fill(this.data, 0L);
        }
    }
}

