/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.gemini.engine.page.bmap;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.apache.flink.runtime.state.gemini.engine.page.bmap.BinaryValue;
import org.apache.flink.runtime.state.gemini.engine.page.bmap.BinaryValueForSplit;
import org.apache.flink.runtime.state.gemini.engine.page.bmap.ByteBufferUtils;
import org.apache.flink.runtime.state.gemini.engine.rm.GByteBuffer;
import org.apache.flink.util.Preconditions;

public abstract class AbstractGRoutingValue {
    public static final int GROUTING_INFO_HEADER_LENGTH = 16;
    private static final int HEADER_ROUTING_TYPE_OFFSET = 0;
    private static final int HEADER_SUB_MAP_COUNT_OFFSET = 1;
    private static final int HEADER_SUB_MAP_MAX_SIZE_OFFSET = 5;
    private static final int HEADER_BASE_VALUE_OFFSET_OFFSET = 9;
    private static final int HEADER_BASE_KEY_OFFSET = 16;

    public static byte getHeaderGRoutingType(BinaryValue binaryValue) {
        return ByteBufferUtils.toByte(binaryValue.getBb(), binaryValue.getValueOffset() + 0);
    }

    public static byte getHeaderGRoutingType(ByteBuffer headerBuffer) {
        return ByteBufferUtils.toByte(headerBuffer, 0);
    }

    public static int getSubMapCount(BinaryValue binaryValue) {
        return ByteBufferUtils.toInt(binaryValue.getBb(), binaryValue.getValueOffset() + 1);
    }

    public static int getSubMapCount(ByteBuffer headerBuffer) {
        return ByteBufferUtils.toInt(headerBuffer, 1);
    }

    public static int getSubMapMaxSize(BinaryValue binaryValue) {
        return ByteBufferUtils.toInt(binaryValue.getBb(), binaryValue.getValueOffset() + 5);
    }

    public static int getGRoutingBaseValueOffset(BinaryValue binaryValue) {
        return ByteBufferUtils.toInt(binaryValue.getBb(), binaryValue.getValueOffset() + 9);
    }

    public static int getGRoutingBaseValueOffset(ByteBuffer byteBuffer) {
        return ByteBufferUtils.toInt(byteBuffer, 9);
    }

    public static void writeHeaderRoutingType(ByteBuffer headerBuffer, byte type) {
        ByteBufferUtils.putByte(headerBuffer, 0, type);
    }

    public static void writeHeaderSubMapCount(ByteBuffer headerBuffer, int subMapCount) {
        ByteBufferUtils.putInt(headerBuffer, 1, subMapCount);
    }

    public static void writeHeaderSubMapMaxSize(ByteBuffer headerBuffer, int subMapMaxSize) {
        ByteBufferUtils.putInt(headerBuffer, 5, subMapMaxSize);
    }

    public static void writeHeaderBaseValueOffset(ByteBuffer headerBuffer, int baseValueOffset) {
        ByteBufferUtils.putInt(headerBuffer, 9, baseValueOffset);
    }

    public static List<GByteBuffer> getAllSubMapByteBuffer(BinaryValue binaryValue) {
        Preconditions.checkState((boolean)(binaryValue instanceof BinaryValueForSplit));
        int subMapCount = AbstractGRoutingValue.getSubMapCount(binaryValue);
        ArrayList<GByteBuffer> bufferList = new ArrayList<GByteBuffer>(subMapCount);
        for (int i = 0; i < subMapCount; ++i) {
            int subMapId = ByteBufferUtils.toInt(binaryValue.getBb(), binaryValue.getValueOffset() + AbstractGRoutingValue.getGRoutingBaseValueOffset(binaryValue) + i * 4);
            GByteBuffer bb = binaryValue.getPageMapping().getGByteBuffer(subMapId, null);
            if (bb == null) continue;
            bufferList.add(bb);
        }
        return bufferList;
    }

    public static int[] getAllSubMapId(BinaryValue binaryValue) {
        Preconditions.checkState((boolean)(binaryValue instanceof BinaryValueForSplit));
        int subMapCount = AbstractGRoutingValue.getSubMapCount(binaryValue);
        int[] idList = new int[subMapCount];
        for (int i = 0; i < subMapCount; ++i) {
            idList[i] = ByteBufferUtils.toInt(binaryValue.getBb(), binaryValue.getValueOffset() + AbstractGRoutingValue.getGRoutingBaseValueOffset(binaryValue) + i * 4);
        }
        return idList;
    }
}

